/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.style.LineSpacing;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.util.Arrays;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;

public class AccessibleTextImpl
implements AccessibleText {
    static final double toPointFactor = 0.028985507246376812;
    static String[] attributeList = new String[]{"ParaAdjust", "CharBackColor", "CharWeight", "ParaFirstLineIndent", "CharFontPitch", "CharHeight", "CharColor", "CharPosture", "ParaLeftMargin", "ParaLineSpacing", "ParaTopMargin", "ParaBottomMargin", "CharStrikeout", "CharEscapement", "ParaTabStops", "CharUnderline"};
    XAccessibleText unoObject;
    private TabSet tabSet = null;
    private javax.swing.text.TabStop[] tabStops = null;
    private static Type TextSegmentType = new Type(class$com$sun$star$accessibility$TextSegment == null ? (class$com$sun$star$accessibility$TextSegment = AccessibleTextImpl.class$("com.sun.star.accessibility.TextSegment")) : class$com$sun$star$accessibility$TextSegment);
    static /* synthetic */ Class class$com$sun$star$accessibility$TextSegment;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleText;
    static /* synthetic */ Class class$com$sun$star$style$ParagraphAdjust;
    static /* synthetic */ Class class$com$sun$star$awt$FontSlant;
    static /* synthetic */ Class class$com$sun$star$style$LineSpacing;

    public AccessibleTextImpl(XAccessibleText xAccessibleText) {
        this.unoObject = xAccessibleText;
    }

    public static AccessibleText get(XInterface xInterface) {
        try {
            XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = AccessibleTextImpl.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText), (Object)xInterface);
            if (xAccessibleText != null) {
                return new AccessibleTextImpl(xAccessibleText);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    protected static short toTextType(int n) {
        short s = 0;
        switch (n) {
            case 1: {
                s = 1;
                break;
            }
            case 2: {
                s = 2;
                break;
            }
            case 3: {
                s = 3;
                break;
            }
            case 4: {
                s = 5;
                break;
            }
            case 5: {
                s = 7;
                break;
            }
        }
        return s;
    }

    protected static Object convertTextSegment(Object object) {
        try {
            TextSegment textSegment;
            if (AnyConverter.isObject((Object)object) && (textSegment = (TextSegment)AnyConverter.toObject((Type)TextSegmentType, (Object)object)) != null) {
                Object[] objectArray = new Object[]{new Integer(textSegment.SegmentStart), new Integer(textSegment.SegmentEnd), textSegment.SegmentText};
                return objectArray;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public String getAfterIndex(int n, int n2) {
        short s = AccessibleTextImpl.toTextType(n);
        try {
            TextSegment textSegment = this.unoObject.getTextBehindIndex(n2, s);
            if (n == 2 && textSegment.SegmentText.length() == 0) {
                return " ";
            }
            return textSegment.SegmentText;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (s == 5 && n2 > 0 && this.getCharCount() == n2) {
                return this.getAfterIndex(n, n2 - 1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public int getCaretPosition() {
        try {
            return this.unoObject.getCaretPosition();
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public int getSelectionStart() {
        try {
            int n = this.unoObject.getSelectionStart();
            if (n == -1) {
                n = this.getCaretPosition();
            }
            return n;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    protected void setAttribute(MutableAttributeSet mutableAttributeSet, PropertyValue propertyValue) {
        try {
            if (propertyValue.Name.equals("ParaAdjust")) {
                ParagraphAdjust paragraphAdjust = null;
                paragraphAdjust = propertyValue.Value instanceof ParagraphAdjust ? (ParagraphAdjust)propertyValue.Value : (propertyValue.Value instanceof Any ? (ParagraphAdjust)AnyConverter.toObject((Type)new Type(class$com$sun$star$style$ParagraphAdjust == null ? (class$com$sun$star$style$ParagraphAdjust = AccessibleTextImpl.class$("com.sun.star.style.ParagraphAdjust")) : class$com$sun$star$style$ParagraphAdjust), (Object)propertyValue.Value) : ParagraphAdjust.fromInt((int)AnyConverter.toInt((Object)propertyValue.Value)));
                if (paragraphAdjust != null) {
                    if (paragraphAdjust.equals(ParagraphAdjust.LEFT)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 0);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.RIGHT)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 2);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.CENTER)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 1);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.BLOCK) || paragraphAdjust.equals(ParagraphAdjust.STRETCH)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 3);
                    }
                }
            } else if (propertyValue.Name.equals("CharBackColor")) {
                StyleConstants.setBackground(mutableAttributeSet, new Color(AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharWeight")) {
                boolean bl = AnyConverter.toFloat((Object)propertyValue.Value) > 125.0f;
                StyleConstants.setBold(mutableAttributeSet, bl);
            } else if (propertyValue.Name.equals("ParaFirstLineIndent")) {
                StyleConstants.setFirstLineIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharFontPitch")) {
                if (AnyConverter.toShort((Object)propertyValue.Value) == 2) {
                    StyleConstants.setFontFamily(mutableAttributeSet, "Proportional");
                }
            } else if (propertyValue.Name.equals("CharHeight")) {
                StyleConstants.setFontSize(mutableAttributeSet, (int)AnyConverter.toFloat((Object)propertyValue.Value));
            } else if (propertyValue.Name.equals("CharColor")) {
                StyleConstants.setForeground(mutableAttributeSet, new Color(AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharPosture")) {
                FontSlant fontSlant = null;
                if (propertyValue.Value instanceof FontSlant) {
                    fontSlant = (FontSlant)propertyValue.Value;
                } else if (propertyValue.Value instanceof Any) {
                    fontSlant = (FontSlant)AnyConverter.toObject((Type)new Type(class$com$sun$star$awt$FontSlant == null ? (class$com$sun$star$awt$FontSlant = AccessibleTextImpl.class$("com.sun.star.awt.FontSlant")) : class$com$sun$star$awt$FontSlant), (Object)propertyValue.Value);
                }
                if (fontSlant != null) {
                    StyleConstants.setItalic(mutableAttributeSet, FontSlant.ITALIC.equals(fontSlant));
                }
            } else if (propertyValue.Name.equals("ParaLeftMargin")) {
                StyleConstants.setLeftIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaRightMargin")) {
                StyleConstants.setRightIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaLineSpacing")) {
                LineSpacing lineSpacing = null;
                if (propertyValue.Value instanceof LineSpacing) {
                    lineSpacing = (LineSpacing)propertyValue.Value;
                } else if (propertyValue.Value instanceof Any) {
                    lineSpacing = (LineSpacing)AnyConverter.toObject((Type)new Type(class$com$sun$star$style$LineSpacing == null ? (class$com$sun$star$style$LineSpacing = AccessibleTextImpl.class$("com.sun.star.style.LineSpacing")) : class$com$sun$star$style$LineSpacing), (Object)propertyValue.Value);
                }
                if (lineSpacing != null) {
                    StyleConstants.setLineSpacing(mutableAttributeSet, (float)(0.028985507246376812 * (double)lineSpacing.Height));
                }
            } else if (propertyValue.Name.equals("ParaTopMargin")) {
                StyleConstants.setSpaceAbove(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaBottomMargin")) {
                StyleConstants.setSpaceBelow(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharStrikeout")) {
                boolean bl = 0 != AnyConverter.toShort((Object)propertyValue.Value);
                StyleConstants.setStrikeThrough(mutableAttributeSet, bl);
            } else if (propertyValue.Name.equals("CharEscapement")) {
                short s = AnyConverter.toShort((Object)propertyValue.Value);
                if (s > 0) {
                    StyleConstants.setSuperscript(mutableAttributeSet, true);
                } else if (s < 0) {
                    StyleConstants.setSubscript(mutableAttributeSet, true);
                }
            } else if (propertyValue.Name.equals("ParaTabStops")) {
                TabStop[] tabStopArray = (TabStop[])AnyConverter.toArray((Object)propertyValue.Value);
                Object[] objectArray = new javax.swing.text.TabStop[tabStopArray.length];
                for (int i = 0; i < tabStopArray.length; ++i) {
                    float f = (float)(0.028985507246376812 * (double)tabStopArray[i].Position);
                    objectArray[i] = tabStopArray[i].Alignment.equals(TabAlign.LEFT) ? new javax.swing.text.TabStop(f, 0, 0) : (tabStopArray[i].Alignment.equals(TabAlign.CENTER) ? new javax.swing.text.TabStop(f, 2, 0) : (tabStopArray[i].Alignment.equals(TabAlign.RIGHT) ? new javax.swing.text.TabStop(f, 1, 0) : (tabStopArray[i].Alignment.equals(TabAlign.DECIMAL) ? new javax.swing.text.TabStop(f, 4, 0) : new javax.swing.text.TabStop(f))));
                }
                if (this.tabSet == null || !Arrays.equals(objectArray, this.tabStops)) {
                    this.tabStops = objectArray;
                    this.tabSet = new TabSet((javax.swing.text.TabStop[])objectArray);
                }
                StyleConstants.setTabSet(mutableAttributeSet, this.tabSet);
            } else if (propertyValue.Name.equals("CharUnderline")) {
                boolean bl = 0 != AnyConverter.toShort((Object)propertyValue.Value);
                StyleConstants.setUnderline(mutableAttributeSet, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public AttributeSet getCharacterAttribute(int n) {
        try {
            PropertyValue[] propertyValueArray = this.unoObject.getCharacterAttributes(n, attributeList);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (null != propertyValueArray) {
                for (int i = 0; i < propertyValueArray.length; ++i) {
                    this.setAttribute(simpleAttributeSet, propertyValueArray[i]);
                }
            }
            return simpleAttributeSet;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n > 0 && this.getCharCount() == n) {
                return this.getCharacterAttribute(n - 1);
            }
            return null;
        }
    }

    public int getIndexAtPoint(java.awt.Point point) {
        try {
            return this.unoObject.getIndexAtPoint(new Point(point.x, point.y));
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public int getSelectionEnd() {
        try {
            int n = this.unoObject.getSelectionEnd();
            if (n == -1) {
                n = this.getCaretPosition();
            }
            return n;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public String getBeforeIndex(int n, int n2) {
        short s = AccessibleTextImpl.toTextType(n);
        try {
            TextSegment textSegment = this.unoObject.getTextBeforeIndex(n2, s);
            if (n == 2 && textSegment.SegmentText.length() == 0) {
                return " ";
            }
            return textSegment.SegmentText;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (s == 5 && n2 > 0 && this.getCharCount() == n2) {
                return this.getBeforeIndex(n, n2 - 1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public String getAtIndex(int n, int n2) {
        short s = AccessibleTextImpl.toTextType(n);
        try {
            TextSegment textSegment = this.unoObject.getTextAtIndex(n2, s);
            if (n == 2 && textSegment.SegmentText.length() == 0) {
                return " ";
            }
            return textSegment.SegmentText;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (s == 5 && n2 > 0 && this.getCharCount() == n2) {
                return this.getAtIndex(n, n2 - 1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public int getCharCount() {
        try {
            return this.unoObject.getCharacterCount();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public String getSelectedText() {
        try {
            return this.unoObject.getSelectedText();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public java.awt.Rectangle getCharacterBounds(int n) {
        try {
            Rectangle rectangle = this.unoObject.getCharacterBounds(n);
            return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n > 0 && this.getCharCount() == n) {
                return this.getCharacterBounds(n - 1);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new java.awt.Rectangle();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

