/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.IUnmarshal;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Marshal;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.Union;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class Unmarshal
implements IUnmarshal {
    private static final boolean DEBUG = false;
    private InputStream _inputStream;
    private DataInput _dataInput;
    private IBridge _iBridge;
    private Object[] _objectCache;
    private ITypeDescription[] _iTypeDescriptionCache;
    private ThreadId[] _threadIdCache;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$star$lib$uno$environments$remote$ThreadId;
    static /* synthetic */ Class class$java$lang$Object;

    Unmarshal(IBridge iBridge, short s) {
        this._iBridge = iBridge;
        this._objectCache = new Object[s];
        this._iTypeDescriptionCache = new ITypeDescription[s];
        this._threadIdCache = new ThreadId[s];
        this._inputStream = new ByteArrayInputStream(new byte[0]);
        this._dataInput = new DataInputStream(this._inputStream);
    }

    Object readAny() {
        ITypeDescription iTypeDescription = this.readTypeDescription();
        switch (iTypeDescription.getTypeClass().getValue()) {
            case 0: {
                return Any.VOID;
            }
            case 1: {
                return this.readCharacter();
            }
            case 2: {
                return this.readBoolean();
            }
            case 3: {
                return this.readByte();
            }
            case 4: {
                return this.readShort();
            }
            case 5: {
                return new Any(Type.UNSIGNED_SHORT, (Object)this.readShort());
            }
            case 6: {
                return this.readInteger();
            }
            case 7: {
                return new Any(Type.UNSIGNED_LONG, (Object)this.readInteger());
            }
            case 8: {
                return this.readLong();
            }
            case 9: {
                return new Any(Type.UNSIGNED_HYPER, (Object)this.readLong());
            }
            case 10: {
                return this.readFloat();
            }
            case 11: {
                return this.readDouble();
            }
            case 12: {
                return this.readString();
            }
            case 13: {
                return new Type(this.readTypeDescription());
            }
            case 15: {
                return this.readEnum(iTypeDescription);
            }
            case 17: {
                return this.readStruct(iTypeDescription);
            }
            case 19: {
                return this.readThrowable(iTypeDescription);
            }
            case 20: {
                Object object = this.readSequence(iTypeDescription);
                ITypeDescription iTypeDescription2 = iTypeDescription.getComponentType();
                while (iTypeDescription2.getTypeClass() == TypeClass.SEQUENCE) {
                    iTypeDescription2 = iTypeDescription2.getComponentType();
                }
                switch (iTypeDescription2.getTypeClass().getValue()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return new Any(new Type(iTypeDescription), object);
                    }
                }
                return object;
            }
            case 22: {
                Object object = this.readReference(iTypeDescription);
                return iTypeDescription.getZClass() == (class$com$sun$star$uno$XInterface == null ? (class$com$sun$star$uno$XInterface = Unmarshal.class$("com.sun.star.uno.XInterface")) : class$com$sun$star$uno$XInterface) ? object : new Any(new Type(iTypeDescription), object);
            }
        }
        throw new RuntimeException("Reading Any with bad type " + iTypeDescription.getTypeClass());
    }

    boolean readboolean() {
        boolean bl;
        try {
            bl = this._dataInput.readBoolean();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readboolean - unexpected:" + iOException);
        }
        return bl;
    }

    Boolean readBoolean() {
        Boolean bl = new Boolean(this.readboolean());
        return bl;
    }

    Byte readByte() {
        Byte by = new Byte(this.readbyte());
        return by;
    }

    byte readbyte() {
        try {
            byte by = (byte)(this._dataInput.readByte() & 0xFF);
            return by;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readByte - unexpected:" + iOException);
        }
    }

    void read(byte[] byArray) {
        try {
            this._inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".read - unexpected:" + iOException);
        }
    }

    byte[] readbyteSequence() {
        int n = this.readCompressedInt();
        byte[] byArray = new byte[n];
        this.read(byArray);
        return byArray;
    }

    char readchar() {
        try {
            char c = this._dataInput.readChar();
            return c;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readChar - unexpected:" + iOException);
        }
    }

    Character readCharacter() {
        Character c = new Character(this.readchar());
        return c;
    }

    double readdouble() {
        try {
            double d = this._dataInput.readDouble();
            return d;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readDouble - unexpected:" + iOException);
        }
    }

    Double readDouble() {
        Double d = new Double(this.readdouble());
        return d;
    }

    Enum readEnum(ITypeDescription iTypeDescription) {
        try {
            Integer n = this.readInteger();
            Method method = iTypeDescription.getZClass().getMethod("fromInt", Integer.TYPE);
            Enum enum_ = (Enum)method.invoke(null, n);
            return enum_;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(this.getClass().getName() + ".readEnum - unexpected:" + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(this.getClass().getName() + ".readEnum - unexpected:" + invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(this.getClass().getName() + ".readEnum - unexpected:" + illegalAccessException);
        }
    }

    Throwable readThrowable(ITypeDescription iTypeDescription) {
        try {
            String string = this.readString();
            Constructor constructor = iTypeDescription.getZClass().getConstructor(class$java$lang$String == null ? (class$java$lang$String = Unmarshal.class$("java.lang.String")) : class$java$lang$String);
            Throwable throwable = (Throwable)constructor.newInstance(string);
            this.readStruct(iTypeDescription, throwable);
            return throwable;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(this.getClass().getName() + ".readThrowable - unexpected:" + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(this.getClass().getName() + ".readThrowable - unexpected:" + invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(this.getClass().getName() + ".readThrowable - unexpected:" + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(this.getClass().getName() + ".readThrowable - unexpected:" + instantiationException);
        }
    }

    float readfloat() {
        try {
            float f = this._dataInput.readFloat();
            return f;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readfloat - unexpected:" + iOException);
        }
    }

    Float readFloat() {
        Float f = new Float(this.readfloat());
        return f;
    }

    int readint() {
        try {
            int n = this._dataInput.readInt();
            return n;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readint - unexpected:" + iOException);
        }
    }

    Integer readInteger() {
        Integer n = new Integer(this.readint());
        return n;
    }

    long readlong() {
        try {
            long l = this._dataInput.readLong();
            return l;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readlong - unexpected:" + iOException);
        }
    }

    Long readLong() {
        Long l = new Long(this.readlong());
        return l;
    }

    public Object readObject(ITypeDescription iTypeDescription) {
        Object object = null;
        switch (iTypeDescription.getTypeClass().getValue()) {
            case 14: {
                object = this.readAny();
                break;
            }
            case 20: 
            case 21: {
                object = this.readSequence(iTypeDescription);
                break;
            }
            case 0: {
                break;
            }
            case 15: {
                object = this.readEnum(iTypeDescription);
                break;
            }
            case 18: {
                object = this.readUnion(iTypeDescription);
                break;
            }
            case 13: {
                object = new Type(this.readTypeDescription());
                break;
            }
            case 22: {
                object = this.readReference(iTypeDescription);
                break;
            }
            case 2: {
                object = this.readBoolean();
                break;
            }
            case 1: {
                object = this.readCharacter();
                break;
            }
            case 3: {
                object = this.readByte();
                break;
            }
            case 4: 
            case 5: {
                object = this.readShort();
                break;
            }
            case 6: 
            case 7: {
                object = this.readInteger();
                break;
            }
            case 8: 
            case 9: {
                object = this.readLong();
                break;
            }
            case 10: {
                object = this.readFloat();
                break;
            }
            case 11: {
                object = this.readDouble();
                break;
            }
            case 12: {
                object = this.readString();
                break;
            }
            case 19: {
                object = this.readThrowable(iTypeDescription);
                break;
            }
            case 17: {
                if (iTypeDescription.getZClass() == (class$com$sun$star$lib$uno$environments$remote$ThreadId == null ? (class$com$sun$star$lib$uno$environments$remote$ThreadId = Unmarshal.class$("com.sun.star.lib.uno.environments.remote.ThreadId")) : class$com$sun$star$lib$uno$environments$remote$ThreadId)) {
                    object = this.readThreadId();
                    break;
                }
                object = this.readStruct(iTypeDescription);
                break;
            }
            default: {
                throw new RuntimeException("unknown typeClass:" + iTypeDescription.getTypeClass());
            }
        }
        return object;
    }

    String readOid() {
        Marshal.M_InterfaceReference m_InterfaceReference = (Marshal.M_InterfaceReference)this.readObject(Marshal.__M_InterfaceReferenceTypeDescription);
        String string = null;
        if (m_InterfaceReference.cache != -1) {
            if (m_InterfaceReference.full.length() > 0) {
                this._objectCache[m_InterfaceReference.cache] = m_InterfaceReference.full;
            }
            string = (String)this._objectCache[m_InterfaceReference.cache];
        } else if (m_InterfaceReference.full.length() > 0) {
            string = m_InterfaceReference.full;
        }
        return string;
    }

    Object readReference(ITypeDescription iTypeDescription) {
        String string = this.readOid();
        Object object = null;
        if (string != null) {
            object = this._iBridge.mapInterfaceFrom(string, new Type(iTypeDescription));
        }
        return object;
    }

    Object readSequence(ITypeDescription iTypeDescription) {
        Object object = null;
        if (iTypeDescription.getTypeClass() == TypeClass.BYTE) {
            object = this.readbyteSequence();
        } else {
            int n = this.readCompressedInt();
            object = (iTypeDescription = iTypeDescription.getComponentType()).getTypeClass() == TypeClass.ANY ? (Object)Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = Unmarshal.class$("java.lang.Object")) : class$java$lang$Object, n) : (Object)Array.newInstance(iTypeDescription.getZClass(), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, this.readObject(iTypeDescription));
            }
        }
        return object;
    }

    Short readShort() {
        Short s = new Short(this.readshort());
        return s;
    }

    short readshort() {
        try {
            short s = this._dataInput.readShort();
            return s;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readshort - unexpected:" + iOException);
        }
    }

    int readCompressedInt() {
        int n = this.readbyte() & 0xFF;
        if (n == 255) {
            n = this.readint();
        }
        return n;
    }

    String readString() {
        try {
            int n = this.readCompressedInt();
            byte[] byArray = new byte[n];
            this.read(byArray);
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + ".readString - unexpected:" + unsupportedEncodingException);
        }
    }

    void readStruct(ITypeDescription iTypeDescription, Object object) {
        IFieldDescription[] iFieldDescriptionArray = iTypeDescription.getFieldDescriptions();
        for (int i = 0; i < iFieldDescriptionArray.length; ++i) {
            try {
                iFieldDescriptionArray[i].getField().set(object, this.readObject(iFieldDescriptionArray[i].getTypeDescription()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(this.getClass().getName() + ".readStruct - unexpected:" + illegalAccessException);
            }
        }
    }

    Object readStruct(ITypeDescription iTypeDescription) {
        try {
            Object t = iTypeDescription.getZClass().newInstance();
            this.readStruct(iTypeDescription, t);
            return t;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(this.getClass().getName() + ".readStruct - unexpected:" + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(this.getClass().getName() + ".readStruct - unexpected:" + instantiationException);
        }
    }

    ThreadId readThreadId() {
        Marshal.M_ThreadId m_ThreadId = (Marshal.M_ThreadId)this.readObject(Marshal.__M_ThreadIdTypeDescription);
        ThreadId threadId = null;
        if (m_ThreadId.cache != -1) {
            if (m_ThreadId.full.length != 0) {
                this._threadIdCache[m_ThreadId.cache] = new ThreadId(m_ThreadId.full);
            }
            threadId = this._threadIdCache[m_ThreadId.cache];
        } else if (m_ThreadId.full.length != 0) {
            threadId = new ThreadId(m_ThreadId.full);
        }
        return threadId;
    }

    int readunsignedbyte() {
        try {
            byte by = (byte)(this._dataInput.readUnsignedByte() & 0xFF);
            return by;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".readunsignedbyte - unexpected:" + iOException);
        }
    }

    ITypeDescription readTypeDescription() {
        int n = this.readunsignedbyte() & 0xFF;
        TypeClass typeClass = TypeClass.fromInt((int)(n & 0x7F));
        TypeDescription typeDescription = null;
        if (TypeDescription.isTypeClassSimple((TypeClass)typeClass)) {
            typeDescription = TypeDescription.getTypeDescription((TypeClass)typeClass);
        } else {
            try {
                short s = this.readshort();
                if (s != -1) {
                    if ((n & 0x80) != 0) {
                        this._iTypeDescriptionCache[s] = TypeDescription.getTypeDescription((String)this.readString());
                    }
                    typeDescription = this._iTypeDescriptionCache[s];
                } else {
                    typeDescription = TypeDescription.getTypeDescription((String)this.readString());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(this.getClass().getName() + ".readTypeDescription - unexpected:" + classNotFoundException);
            }
        }
        return typeDescription;
    }

    Union readUnion(ITypeDescription iTypeDescription) {
        throw new RuntimeException(this.getClass().getName() + ".readUnion - not implemented!!!");
    }

    void reset(byte[] byArray) {
        this._inputStream = new ByteArrayInputStream(byArray);
        this._dataInput = new DataInputStream(this._inputStream);
    }

    int bytesLeft() {
        try {
            return this._inputStream.available();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".bytesLeft - unexpected:" + iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

