/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class ProxyFactory {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private static final Method METHOD_QUERY_INTERFACE;
    private static final Method METHOD_IS_SAME;
    private static final Method METHOD_GET_OID;
    private static final Object debugCountLock;
    private static int debugCount;
    private final RequestHandler requestHandler;
    static /* synthetic */ Class class$com$sun$star$lib$uno$Proxy;
    static /* synthetic */ Class class$com$sun$star$uno$IQueryInterface;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$star$uno$Type;

    public ProxyFactory(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public Object create(String string, Type type) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$com$sun$star$lib$uno$Proxy == null ? (class$com$sun$star$lib$uno$Proxy = ProxyFactory.class$("com.sun.star.lib.uno.Proxy")) : class$com$sun$star$lib$uno$Proxy, class$com$sun$star$uno$IQueryInterface == null ? (class$com$sun$star$uno$IQueryInterface = ProxyFactory.class$("com.sun.star.uno.IQueryInterface")) : class$com$sun$star$uno$IQueryInterface, type.getZClass()}, (InvocationHandler)new Handler(string, type));
    }

    public boolean isProxy(Object object, Type type) {
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            return invocationHandler instanceof Handler && ((Handler)invocationHandler).matches(this, type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            return debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            ++debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            --debugCount;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            METHOD_EQUALS = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object);
            METHOD_HASH_CODE = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            METHOD_TO_STRING = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", null);
            METHOD_QUERY_INTERFACE = (class$com$sun$star$uno$IQueryInterface == null ? (class$com$sun$star$uno$IQueryInterface = ProxyFactory.class$("com.sun.star.uno.IQueryInterface")) : class$com$sun$star$uno$IQueryInterface).getMethod("queryInterface", class$com$sun$star$uno$Type == null ? (class$com$sun$star$uno$Type = ProxyFactory.class$("com.sun.star.uno.Type")) : class$com$sun$star$uno$Type);
            METHOD_IS_SAME = (class$com$sun$star$uno$IQueryInterface == null ? (class$com$sun$star$uno$IQueryInterface = ProxyFactory.class$("com.sun.star.uno.IQueryInterface")) : class$com$sun$star$uno$IQueryInterface).getMethod("isSame", class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object);
            METHOD_GET_OID = (class$com$sun$star$uno$IQueryInterface == null ? (class$com$sun$star$uno$IQueryInterface = ProxyFactory.class$("com.sun.star.uno.IQueryInterface")) : class$com$sun$star$uno$IQueryInterface).getMethod("getOid", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
        debugCountLock = new Object();
        debugCount = 0;
    }

    private final class Handler
    implements InvocationHandler {
        private final String oid;
        private final Type type;

        public Handler(String string, Type type) {
            this.oid = string;
            this.type = type;
            ProxyFactory.incrementDebugCount();
        }

        public boolean matches(ProxyFactory proxyFactory, Type type) {
            return ProxyFactory.this == proxyFactory && this.type.equals((Object)type);
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.equals(METHOD_EQUALS) || method.equals(METHOD_IS_SAME)) {
                return new Boolean(objectArray[0] != null && this.oid.equals(UnoRuntime.generateOid(objectArray[0])));
            }
            if (method.equals(METHOD_HASH_CODE)) {
                return new Integer(this.oid.hashCode());
            }
            if (method.equals(METHOD_TO_STRING)) {
                return "[Proxy:" + System.identityHashCode(object) + "," + this.oid + "," + this.type + "]";
            }
            if (method.equals(METHOD_QUERY_INTERFACE)) {
                return objectArray[0].equals(this.type) ? object : this.request("queryInterface", objectArray);
            }
            if (method.equals(METHOD_GET_OID)) {
                return this.oid;
            }
            return this.request(method.getName(), objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.request("release", null);
            }
            finally {
                ProxyFactory.decrementDebugCount();
            }
        }

        private Object request(String string, Object[] objectArray) throws Throwable {
            return ProxyFactory.this.requestHandler.sendRequest(this.oid, this.type, string, objectArray);
        }
    }
}

