/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility.logging;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class XAccessibleEventLog
implements XAccessibleEventListener {
    private static XAccessibleEventLog theEventListener = null;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEventBroadcaster;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;

    private static XAccessibleEventListener get() {
        if (theEventListener == null) {
            theEventListener = new XAccessibleEventLog();
        }
        return theEventListener;
    }

    public static void addEventListener(XAccessibleContext xAccessibleContext) {
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEventBroadcaster == null ? (class$com$sun$star$accessibility$XAccessibleEventBroadcaster = XAccessibleEventLog.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster")) : class$com$sun$star$accessibility$XAccessibleEventBroadcaster), (Object)xAccessibleContext);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(XAccessibleEventLog.get());
        }
    }

    public void disposing(EventObject eventObject) {
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 5: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved active descendant event.");
                break;
            }
            case 4: {
                this.logStateChange(accessibleEventObject.Source, accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                break;
            }
            case 7: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved children event.");
                break;
            }
            case 6: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved boundrect changed event.");
                break;
            }
            case 10: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved visible data changed event.");
                break;
            }
            case 8: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved invalidate children event.");
                break;
            }
        }
    }

    public void logStateChange(Object object, Object object2, Object object3) {
        try {
            if (AnyConverter.isShort((Object)object2)) {
                this.logStateChange(object, AnyConverter.toShort((Object)object2), " is no longer ");
            }
            if (AnyConverter.isShort((Object)object3)) {
                this.logStateChange(object, AnyConverter.toShort((Object)object3), " is now ");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void logStateChange(Object object, short s, String string) {
        switch (s) {
            case 1: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.ACTIVE);
                break;
            }
            case 2: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.ARMED);
                break;
            }
            case 4: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.CHECKED);
                break;
            }
            case 7: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.ENABLED);
                break;
            }
            case 11: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.FOCUSED);
                break;
            }
            case 20: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.PRESSED);
                break;
            }
            case 23: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.SELECTED);
                break;
            }
            case 25: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.SELECTED);
                break;
            }
            case 30: {
                XAccessibleEventLog.logMessage(object, string + AccessibleState.VISIBLE);
                break;
            }
            default: {
                XAccessibleEventLog.logMessage(object, string + "??? (FIXME)");
            }
        }
    }

    protected static void logMessage(Object object, String string) {
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = XAccessibleEventLog.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible), (Object)object);
        XAccessibleEventLog.logMessage((Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(xAccessible)), string);
    }

    protected static void logMessage(Accessible accessible, String string) {
        if (accessible != null) {
            XAccessibleEventLog.logMessage(accessible.getAccessibleContext(), string);
        } else {
            XAccessibleEventLog.logMessage(string);
        }
    }

    protected static void logMessage(AccessibleContext accessibleContext, String string) {
        if (accessibleContext != null) {
            XAccessibleEventLog.logMessage("[" + accessibleContext.getAccessibleRole() + "] " + accessibleContext.getAccessibleName() + ": " + string);
        } else {
            XAccessibleEventLog.logMessage(string);
        }
    }

    protected static void logMessage(String string) {
        System.err.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

