/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.IMarshal;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Cache;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.uno.typeinfo.MemberTypeInfo;
import com.sun.star.lib.uno.typeinfo.TypeInfo;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.Union;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

class Marshal
implements IMarshal {
    private static final boolean DEBUG = false;
    public static final ITypeDescription __xInterfaceTypeDescription = TypeDescription.getTypeDescription((Class)(class$com$sun$star$uno$XInterface == null ? (class$com$sun$star$uno$XInterface = Marshal.class$("com.sun.star.uno.XInterface")) : class$com$sun$star$uno$XInterface));
    public static final ITypeDescription __M_InterfaceReferenceTypeDescription = TypeDescription.getTypeDescription((Class)(class$com$sun$star$lib$uno$protocols$urp$Marshal$M_InterfaceReference == null ? (class$com$sun$star$lib$uno$protocols$urp$Marshal$M_InterfaceReference = Marshal.class$("com.sun.star.lib.uno.protocols.urp.Marshal$M_InterfaceReference")) : class$com$sun$star$lib$uno$protocols$urp$Marshal$M_InterfaceReference));
    public static final ITypeDescription __M_ThreadIdTypeDescription = TypeDescription.getTypeDescription((Class)(class$com$sun$star$lib$uno$protocols$urp$Marshal$M_ThreadId == null ? (class$com$sun$star$lib$uno$protocols$urp$Marshal$M_ThreadId = Marshal.class$("com.sun.star.lib.uno.protocols.urp.Marshal$M_ThreadId")) : class$com$sun$star$lib$uno$protocols$urp$Marshal$M_ThreadId));
    private static final M_InterfaceReference __null_M_InterfaceReference = new M_InterfaceReference("", -1);
    static final Class __anyArray;
    private ByteArrayOutputStream _byteArrayOutputStream;
    private DataOutput _dataOutput;
    private IBridge _iBridge;
    private Cache _objectCache;
    private Cache _typeCache;
    private Cache _threadIdCache;
    private boolean _useCaches = true;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;
    static /* synthetic */ Class class$com$sun$star$lib$uno$protocols$urp$Marshal$M_InterfaceReference;
    static /* synthetic */ Class class$com$sun$star$lib$uno$protocols$urp$Marshal$M_ThreadId;

    Marshal(IBridge iBridge, short s) {
        this._iBridge = iBridge;
        this._byteArrayOutputStream = new ByteArrayOutputStream();
        this._dataOutput = new DataOutputStream(this._byteArrayOutputStream);
        this._objectCache = new Cache(s);
        this._typeCache = new Cache(s);
        this._threadIdCache = new Cache(s);
    }

    void writeAny(Object object) {
        Object object2 = null;
        if (object == null) {
            object2 = __xInterfaceTypeDescription;
        } else if (object instanceof Any) {
            Any any = (Any)object;
            try {
                object2 = TypeDescription.getTypeDescription((Type)any.getType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(this.getClass().getName() + " - unexpected:" + classNotFoundException);
            }
            object = any.getObject();
        } else {
            object2 = object instanceof XInterface ? __xInterfaceTypeDescription : TypeDescription.getTypeDescription(object.getClass());
        }
        this.writeTypeDescrption((ITypeDescription)object2);
        this.writeObject((ITypeDescription)object2, object);
    }

    void writeboolean(boolean bl) {
        try {
            this._dataOutput.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writeboolean - unexpected: " + iOException);
        }
    }

    void writeBoolean(Boolean bl) {
        this.writeboolean(bl);
    }

    void writebyte(byte by) {
        int n = by & 0xFF;
        try {
            this._dataOutput.writeByte(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writebyte - unexpected: " + iOException);
        }
    }

    void write(byte[] byArray) {
        try {
            this._dataOutput.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".write - unexpected: " + iOException);
        }
    }

    void writebyteSequence(byte[] byArray) {
        int n = 0;
        if (byArray == null) {
            System.err.println("WARNING! writing null sequence as empty sequence");
        } else {
            n = byArray.length;
        }
        this.writeCompressedInt(n);
        if (n != 0) {
            this.write(byArray);
        }
    }

    void writeByte(Byte by) {
        this.writebyte(by);
    }

    void writechar(char c) {
        try {
            this._dataOutput.writeChar(c);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writechar - unexpected: " + iOException);
        }
    }

    void writeCharacter(Character c) {
        this.writechar(c.charValue());
    }

    void writedouble(double d) {
        try {
            this._dataOutput.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writedouble - unexpected: " + iOException);
        }
    }

    void writeDouble(Double d) {
        this.writedouble(d);
    }

    void writeEnum(Enum enum_) {
        this.writeint(enum_.getValue());
    }

    void writeThrowable(ITypeDescription iTypeDescription, Throwable throwable) {
        String string = throwable.getMessage();
        this.writeString(string == null ? "" : string);
        this.writeStruct(iTypeDescription, throwable);
    }

    void writefloat(float f) {
        try {
            this._dataOutput.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writefloat - unexpected: " + iOException);
        }
    }

    void writeFloat(Float f) {
        this.writefloat(f.floatValue());
    }

    void writeInteger(Integer n) {
        this.writeint(n);
    }

    void writeint(int n) {
        try {
            this._dataOutput.writeInt(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writeint - unexpected: " + iOException);
        }
    }

    void writelong(long l) {
        try {
            this._dataOutput.writeLong(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writelong - unexpected: " + iOException);
        }
    }

    void writeLong(Long l) {
        this.writelong(l);
    }

    public void writeObject(ITypeDescription iTypeDescription, Object object) {
        switch (iTypeDescription.getTypeClass().getValue()) {
            case 14: {
                this.writeAny(object);
                break;
            }
            case 20: 
            case 21: {
                this.writeSequence(iTypeDescription, object);
                break;
            }
            case 0: {
                break;
            }
            case 15: {
                this.writeEnum((Enum)object);
                break;
            }
            case 18: {
                this.writeUnion((Union)object);
                break;
            }
            case 13: {
                try {
                    this.writeTypeDescrption(TypeDescription.getTypeDescription((Type)((Type)object)));
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(this.getClass().getName() + " - unexpected:" + classNotFoundException);
                }
            }
            case 22: {
                this.writeReference(iTypeDescription, object);
                break;
            }
            case 2: {
                this.writeBoolean((Boolean)object);
                break;
            }
            case 1: {
                this.writeCharacter((Character)object);
                break;
            }
            case 3: {
                this.writeByte((Byte)object);
                break;
            }
            case 4: 
            case 5: {
                this.writeShort((Short)object);
                break;
            }
            case 6: 
            case 7: {
                this.writeInteger((Integer)object);
                break;
            }
            case 8: 
            case 9: {
                this.writeLong((Long)object);
                break;
            }
            case 10: {
                this.writeFloat((Float)object);
                break;
            }
            case 11: {
                this.writeDouble((Double)object);
                break;
            }
            case 12: {
                this.writeString((String)object);
                break;
            }
            case 17: {
                if (object instanceof ThreadId) {
                    this.writeThreadId((ThreadId)object);
                    break;
                }
                this.writeStruct(iTypeDescription, object);
                break;
            }
            case 19: {
                this.writeThrowable(iTypeDescription, (Throwable)object);
                break;
            }
            default: {
                throw new RuntimeException(this.getClass().getName() + ".writeObject - unknown typeClass:" + iTypeDescription.getTypeClass().getValue());
            }
        }
    }

    void writeOid(String string) {
        M_InterfaceReference m_InterfaceReference = null;
        if (string == null) {
            m_InterfaceReference = __null_M_InterfaceReference;
        } else {
            boolean[] blArray = new boolean[1];
            short s = this._useCaches ? (short)this._objectCache.add(blArray, string) : (short)-1;
            m_InterfaceReference = new M_InterfaceReference(blArray[0] ? "" : string, s);
        }
        this.writeObject(__M_InterfaceReferenceTypeDescription, m_InterfaceReference);
    }

    void writeReference(ITypeDescription iTypeDescription, Object object) {
        this.writeOid(object != null ? (String)this._iBridge.mapInterfaceTo(object, new Type(iTypeDescription)) : null);
    }

    void writeSequence(ITypeDescription iTypeDescription, Object object) {
        if ((iTypeDescription = iTypeDescription.getComponentType()).getTypeClass() == TypeClass.BYTE) {
            this.writebyteSequence((byte[])object);
        } else {
            int n = 0;
            if (object == null) {
                System.err.println("WARNING! writing null sequence as empty sequence");
            } else {
                n = Array.getLength(object);
            }
            this.writeCompressedInt(n);
            int n2 = 0;
            while (n2 < n) {
                this.writeObject(iTypeDescription, Array.get(object, n2));
                ++n2;
            }
        }
    }

    void writeShort(Short s) {
        this.writeshort(s);
    }

    void writeshort(short s) {
        try {
            this._dataOutput.writeShort(s);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + ".writeshort - unexpected: " + iOException);
        }
    }

    void writeCompressedInt(int n) {
        if (n >= 255) {
            this.writebyte((byte)-1);
            this.writeint(n);
        } else {
            this.writebyte((byte)n);
        }
    }

    void writeString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeCompressedInt(byArray.length);
            this.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + ".writeString - unexpected:" + unsupportedEncodingException);
        }
    }

    void writeStruct(ITypeDescription iTypeDescription, Object object) {
        IFieldDescription[] iFieldDescriptionArray = iTypeDescription.getFieldDescriptions();
        int n = 0;
        while (n < iFieldDescriptionArray.length) {
            try {
                this.writeObject(iFieldDescriptionArray[n].getTypeDescription(), iFieldDescriptionArray[n].getField().get(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(this.getClass().getName() + ".writeStruct - unexpected:" + illegalAccessException);
            }
            ++n;
        }
    }

    void writeThreadId(ThreadId threadId) {
        boolean[] blArray = new boolean[1];
        short s = this._useCaches ? (short)this._threadIdCache.add(blArray, threadId.getBytes()) : (short)-1;
        M_ThreadId m_ThreadId = new M_ThreadId(blArray[0] ? null : threadId.getBytes(), s);
        this.writeObject(__M_ThreadIdTypeDescription, m_ThreadId);
    }

    void writeTypeDescrption(ITypeDescription iTypeDescription) {
        TypeClass typeClass = iTypeDescription.getTypeClass();
        if (TypeDescription.isTypeClassSimple((TypeClass)typeClass)) {
            this.writebyte((byte)typeClass.getValue());
        } else {
            boolean[] blArray = new boolean[1];
            short s = this._useCaches ? (short)this._typeCache.add(blArray, iTypeDescription.getTypeName()) : (short)-1;
            this.writebyte((byte)(typeClass.getValue() | (blArray[0] ? 0 : 128)));
            this.writeshort(s);
            if (!blArray[0]) {
                this.writeString(iTypeDescription.getTypeName());
            }
        }
    }

    void writeUnion(Union union) {
        throw new RuntimeException(this.getClass().getName() + ".writeUnion is not implemented yet!!!");
    }

    public byte[] reset() {
        byte[] byArray = this._byteArrayOutputStream.toByteArray();
        this._byteArrayOutputStream.reset();
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            __anyArray = Class.forName("[Lcom.sun.star.uno.Any;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("urp.Marshal.<cinit> - unexpected:" + classNotFoundException);
        }
    }

    public static class M_InterfaceReference {
        public String full;
        public short cache;
        public static final TypeInfo[] UNOTYPEINFO = new TypeInfo[]{new MemberTypeInfo("full", 0, 0), new MemberTypeInfo("cache", 1, 0)};

        M_InterfaceReference() {
        }

        M_InterfaceReference(String string, short s) {
            this.full = string;
            this.cache = s;
        }
    }

    public static class M_ThreadId {
        public byte[] full;
        public short cache;
        public static final TypeInfo[] UNOTYPEINFO = new TypeInfo[]{new MemberTypeInfo("full", 0, 0), new MemberTypeInfo("cache", 1, 0)};

        M_ThreadId() {
        }

        M_ThreadId(byte[] byArray, short s) {
            this.full = byArray;
            this.cache = s;
        }
    }
}

