/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile$
 *
 *  $Revision$
 *
 *  last change: $Author$ $Date$
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SC_XMLRUBYI_HXX
#define _SC_XMLRUBYI_HXX

#ifndef _XMLOFF_XMLICTXT_HXX
#include <xmloff/xmlictxt.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

class ScXMLImport;
class ScXMLTextPContext;
class ScXMLTableRowCellContext;

/**
 * A class for representing Asian phonetic guide information while loading ODF file.
 */
class ScXMLRubyContext : public SvXMLImportContext
{
	rtl::OUString		sStyleName;
	rtl::OUStringBuffer	sBaseText;
	rtl::OUStringBuffer	sRubyText;
	ScXMLTextPContext*	pTextContext;
	ScXMLTableRowCellContext*	pCellContext;

	const ScXMLImport& GetScImport() const { return (const ScXMLImport&)GetImport(); }
	ScXMLImport& GetScImport() { return (ScXMLImport&)GetImport(); }

public:

	/**
	 * A constructor of ScXMLRubyContext.
	 * @param rImport a reference of ScXMLImport.
	 * @param nPrfx the number of the element prefix.
	 * @param rLName the string of the element.
	 * @param xAttrList attribute list of the element.
	 * @param pContext a pointer of ScXMLTextPContext.
	 */
	ScXMLRubyContext( ScXMLImport& rImport, USHORT nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
										::com::sun::star::xml::sax::XAttributeList>& xAttrList,
						ScXMLTextPContext* pContext);
	/**
	 * A constructor of ScXMLRubyContext.
	 * @param rImport a reference of ScXMLImport.
	 * @param nPrfx the number of the element prefix.
	 * @param rLName the string of the element.
	 * @param xAttrList attribute list of the element.
	 * @param pContext a pointer of ScXMLTableRowCellContext.
	 */
	ScXMLRubyContext( ScXMLImport& rImport, USHORT nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
										::com::sun::star::xml::sax::XAttributeList>& xAttrList,
						ScXMLTableRowCellContext* pContext);

	virtual ~ScXMLRubyContext() {};

	/**
	 * Create a childs element context. By default, the import's
	 * CreateContext method is called to create a new default context.
	 * @return a new default context.
	 */
	virtual SvXMLImportContext *CreateChildContext( USHORT nPrefix,
									 const ::rtl::OUString& rLocalName,
									 const ::com::sun::star::uno::Reference<
									  	::com::sun::star::xml::sax::XAttributeList>& xAttrList );
	/**
	 * EndElement is called before a context will be destructed, but
	 * after a elements context has been parsed. It may be used for actions
	 * that require virtual methods. The default is to do nothing.
	 */
	virtual void EndElement();

	/**
	 * Adds string into cell string as base string of phonetic infrmation
	 * @param rText the base string.
	 */
	void AddBaseText(const ::rtl::OUString& rText);
	/**
	 * Adds string into cell string as phonetic text
	 * @param rText the phonetic text.
	 */
	void AddRubyText(const ::rtl::OUString& rText);
};

/**
 * A class for representing base text of phonetic guide information while loading ODF file.
 */
class ScXMLRubyBaseContext : public SvXMLImportContext
{
	ScXMLRubyContext*	pRubyContext;

	const ScXMLImport& GetScImport() const { return (const ScXMLImport&)GetImport(); }
	ScXMLImport& GetScImport() { return (ScXMLImport&)GetImport(); }

public:

	/**
	 * A constructor of ScXMLRubyBaseContext.
	 * @param rImport a reference of ScXMLImport.
	 * @param nPrfx the number of the element prefix.
	 * @param rLName the string of the element.
	 * @param xAttrList attribute list of the element.
	 * @param pContext a pointer of ScXMLRubyContext.
	 */
	ScXMLRubyBaseContext( ScXMLImport& rImport, USHORT nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
										::com::sun::star::xml::sax::XAttributeList>& xAttrList,
						ScXMLRubyContext* pContext);

	virtual ~ScXMLRubyBaseContext() {};

	/**
	 * This method is called for all characters that are contained in the
	 * current element. The default is to ignore them.
	 * @param rChars the character reference
	 */ 
	virtual void Characters( const ::rtl::OUString& rChars );
};


/**
 * A class for representing phonetic text of phonetic guide information while loading ODF file.
 */
class ScXMLRubyTextContext : public SvXMLImportContext
{
	ScXMLRubyContext*	pRubyContext;

	const ScXMLImport& GetScImport() const { return (const ScXMLImport&)GetImport(); }
	ScXMLImport& GetScImport() { return (ScXMLImport&)GetImport(); }

public:

	/**
	 * A constructor of ScXMLRubyTextContext.
	 * @param rImport a reference of ScXMLImport.
	 * @param nPrfx the number of the element prefix.
	 * @param rLName the string of the element.
	 * @param xAttrList attribute list of the element.
	 * @param pContext a pointer of ScXMLRubyContext.
	 */
	ScXMLRubyTextContext( ScXMLImport& rImport, USHORT nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
										::com::sun::star::xml::sax::XAttributeList>& xAttrList,
						ScXMLRubyContext* pContext);

	virtual ~ScXMLRubyTextContext() {};

	/**
	 * This method is called for all characters that are contained in the
	 * current element. The default is to ignore them.
	 * @param rChars the character reference
	 */ 
	virtual void Characters( const ::rtl::OUString& rChars );
};

#endif
