/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile$
 *
 *  $Revision$
 *
 *  last change: $Author$ $Date$
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------

#ifndef _SC_XMLRUBYI_HXX
#include "xmlrubyi.hxx"
#endif
#ifndef SC_XMLIMPRT_HXX
#include "xmlimprt.hxx"
#endif
#ifndef SC_XMLCELLI_HXX
#include "xmlcelli.hxx"
#endif
#ifndef _SC_XMLTEXTPCONTEXT_HXX
#include "XMLTextPContext.hxx"
#endif
#ifndef _XMLSTYLI_HXX
#include "xmlstyli.hxx"
#endif

#ifndef _XMLOFF_XMLNMSPE_HXX
#include <xmloff/xmlnmspe.hxx>
#endif
#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif
#ifndef _XMLOFF_NMSPMAP_HXX
#include <xmloff/nmspmap.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXT_HPP_
#include <com/sun/star/text/XText.hpp>
#endif

using namespace com::sun::star;
using namespace xmloff::token;

ScXMLRubyContext::ScXMLRubyContext( ScXMLImport& rImport,
									  USHORT nPrfx,
									  const ::rtl::OUString& rLName,
									  const ::com::sun::star::uno::Reference<
									  ::com::sun::star::xml::sax::XAttributeList>& xTempAttrList,
									  ScXMLTextPContext* pTempTextContext) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	pCellContext( NULL ),
	pTextContext( pTempTextContext )
{
	sal_Int16 nAttrCount(xTempAttrList.is() ? xTempAttrList->getLength() : 0);
	const SvXMLTokenMap& rAttrTokenMap = GetScImport().GetTableRowCellElemTextRubyAttrTokenMap();
	for( sal_Int16 i=0; i < nAttrCount; ++i )
	{
		const rtl::OUString& sAttrName(xTempAttrList->getNameByIndex( i ));
		rtl::OUString aLocalName;
		USHORT nPrefix(GetScImport().GetNamespaceMap().GetKeyByAttrName(
					   sAttrName, &aLocalName ));
		const rtl::OUString& sValue(xTempAttrList->getValueByIndex( i ));

		switch( rAttrTokenMap.Get( nPrefix, aLocalName ) )
		{
		case XML_TOK_TABLE_ROW_CELL_TEXT_RUBY_ATTR_STYLE_NAME:
			sStyleName = sValue;
			break;
		}
	}
}

ScXMLRubyContext::ScXMLRubyContext( ScXMLImport& rImport,
									  USHORT nPrfx,
									  const ::rtl::OUString& rLName,
									  const ::com::sun::star::uno::Reference<
									  ::com::sun::star::xml::sax::XAttributeList>& xTempAttrList,
									  ScXMLTableRowCellContext* pTempContext) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	pCellContext( pTempContext ),
	pTextContext( NULL )
{
	sal_Int16 nAttrCount(xTempAttrList.is() ? xTempAttrList->getLength() : 0);
	const SvXMLTokenMap& rAttrTokenMap = GetScImport().GetTableRowCellElemTextRubyAttrTokenMap();
	for( sal_Int16 i=0; i < nAttrCount; ++i )
	{
		const rtl::OUString& sAttrName(xTempAttrList->getNameByIndex( i ));
		rtl::OUString aLocalName;
		USHORT nPrefix(GetScImport().GetNamespaceMap().GetKeyByAttrName(
					   sAttrName, &aLocalName ));
		const rtl::OUString& sValue(xTempAttrList->getValueByIndex( i ));

		switch( rAttrTokenMap.Get( nPrefix, aLocalName ) )
		{
		case XML_TOK_TABLE_ROW_CELL_TEXT_RUBY_ATTR_STYLE_NAME:
			sStyleName = sValue;
			break;
		}
	}
}

SvXMLImportContext *ScXMLRubyContext::CreateChildContext( USHORT nPrefix,
											const ::rtl::OUString& rLName,
											const ::com::sun::star::uno::Reference<
									  	::com::sun::star::xml::sax::XAttributeList>& xAttrList )
{
	SvXMLImportContext *pContext(NULL);

	const SvXMLTokenMap& rTokenMap = GetScImport().GetTableRowCellElemTextRubyTokenMap();
	switch( rTokenMap.Get( nPrefix, rLName ) )
	{
	case XML_TOK_TABLE_ROW_CELL_TEXT_RUBY_BASE:
		pContext = new ScXMLRubyBaseContext( GetScImport(), nPrefix, rLName, xAttrList, this);
		break;
	case XML_TOK_TABLE_ROW_CELL_TEXT_RUBY_TEXT:
		pContext = new ScXMLRubyTextContext( GetScImport(), nPrefix, rLName, xAttrList, this);
		break;
	}

	if( !pContext )
		pContext = new SvXMLImportContext( GetScImport(), nPrefix, rLName );

	return pContext;
}

void ScXMLRubyContext::EndElement()
{
	if ( pTextContext )
		pTextContext->AddRubyText( sBaseText.makeStringAndClear(), sRubyText.makeStringAndClear() );
	else if ( pCellContext )
		pCellContext->SetPhoneticText( sRubyText.makeStringAndClear() );
}

void ScXMLRubyContext::AddBaseText( const ::rtl::OUString& rText )
{
	sBaseText.append( rText );
}

void ScXMLRubyContext::AddRubyText( const ::rtl::OUString& rText )
{
	sRubyText.append( rText );
}

ScXMLRubyBaseContext::ScXMLRubyBaseContext( ScXMLImport& rImport,
									  USHORT nPrfx,
									  const ::rtl::OUString& rLName,
									  const ::com::sun::star::uno::Reference<
									  ::com::sun::star::xml::sax::XAttributeList>& xTempAttrList,
									  ScXMLRubyContext* pTempRubyContext) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	pRubyContext( pTempRubyContext )
{
	// here are no attributes
}

void ScXMLRubyBaseContext::Characters( const ::rtl::OUString& rChars )
{
	pRubyContext->AddBaseText( rChars );
}

ScXMLRubyTextContext::ScXMLRubyTextContext( ScXMLImport& rImport,
									  USHORT nPrfx,
									  const ::rtl::OUString& rLName,
									  const ::com::sun::star::uno::Reference<
									  ::com::sun::star::xml::sax::XAttributeList>& xTempAttrList,
									  ScXMLRubyContext* pTempRubyContext) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	pRubyContext( pTempRubyContext )
{
	// here are no attributes
}

void ScXMLRubyTextContext::Characters( const ::rtl::OUString& rChars )
{
	pRubyContext->AddRubyText( rChars );
}


