;NSIS Modern User Interface
;Multilingual Example Script
;Written by Joost Verburg

;--------------------------------
;Include Modern UI

  !include "MUI2.nsh"

;--------------------------------
;Constants

  !define SRC "..\wntmsci10.pro\misc\nsis\opt\openoffice.org2.4"
  !define DST "..\wntmsci10.pro\bin"
  !define PACKAGE_NAME "jsdp2007_2.4.0.1_OOo_2.4.0_Win32Intel.exe"

;--------------------------------
;General

  ;Name and file
  Name "jsdp2007 2.4.0.1 for OpenOffice.org 2.4"
  OutFile "${DST}\${PACKAGE_NAME}"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\OpenOffice.org 2.4"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\OpenOffice.org\OpenOffice.org 2.4" ""

  ;Request application privileges for Windows Vista
  RequestExecutionLevel admin

;--------------------------------
;Interface Configuration

;  !define MUI_HEADERIMAGE
;  !define MUI_HEADERIMAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Header\nsis.bmp" ; optional

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Language Selection Dialog Settings

  ;Remember the installer language
;  !define MUI_LANGDLL_REGISTRY_ROOT "HKCU" 
;  !define MUI_LANGDLL_REGISTRY_KEY "Software\Modern UI Test" 
;  !define MUI_LANGDLL_REGISTRY_VALUENAME "Installer Language"

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_LICENSE "License.txt"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English" ;first language is the default language
  !insertmacro MUI_LANGUAGE "German"
  !insertmacro MUI_LANGUAGE "SimpChinese"
  !insertmacro MUI_LANGUAGE "TradChinese"
  !insertmacro MUI_LANGUAGE "Japanese"
  !insertmacro MUI_LANGUAGE "Korean"

;--------------------------------
;Reserve Files
  
  ;If you are using solid compression, files that are required before
  ;the actual installation should be stored first in the data block,
  ;because this will make your installer start faster.
  
  !insertmacro MUI_RESERVEFILE_LANGDLL

;--------------------------------
;Installer Sections

SectionGroup "Patch files for Calc" GroupCalc

  Section "DLL files" CalcDLL

    SetOutPath "$INSTDIR\program"
      File "${SRC}\program\sc680mi.dll"
      File "${SRC}\program\scd680mi.dll"
      File "${SRC}\program\scui680mi.dll"
      File "${SRC}\program\vbaobj680mi.uno.dll"

  SectionEnd

  Section "English support" CalcEnglish
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680en-US.res"
  SectionEnd

  Section "German support" CalcGerman
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680de.res"
  SectionEnd

  Section "Japanese support" CalcJapanese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680ja.res"
  SectionEnd

  Section "Korean support" CalcKorean
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680ko.res"
  SectionEnd

  Section "Simplified Chinese support" CalcSimplifiedChinese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680zh-CN.res"
  SectionEnd

  Section "Traditional Chinese support" CalcTraditionalChinese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\sc680zh-TW.res"
  SectionEnd

SectionGroupEnd

;--------------------------------
;SectionGroup for Writer

SectionGroup "Patch files for Writer" GroupWriter

  Section "DLL files" WriterDll

    SetOutPath "$INSTDIR\program"
      File "${SRC}\program\cui680mi.dll"
      File "${SRC}\program\svx680mi.dll"
      File "${SRC}\program\sw680mi.dll"
      File "${SRC}\program\swd680mi.dll"
      File "${SRC}\program\swui680mi.dll"
      File "${SRC}\program\textconversiondlgs680mi.dll"
      File "${SRC}\program\xo680mi.dll"
      File "${SRC}\program\xof680mi.dll"

    SetOutPath "$INSTDIR\share\config"
      File "${SRC}\share\config\images.zip"
      File "${SRC}\share\config\images_crystal.zip"
      File "${SRC}\share\config\images_hicontrast.zip"
      File "${SRC}\share\config\images_industrial.zip"
      File "${SRC}\share\config\images_tango.zip"

    SetOutPath "$INSTDIR\share\config\soffice.cfg\modules\swriter\menubar"
      File "${SRC}\share\config\soffice.cfg\modules\swriter\menubar\menubar.xml"

    SetOutPath "$INSTDIR\share\config\soffice.cfg\modules\swriter\toolbar"
      File "${SRC}\share\config\soffice.cfg\modules\swriter\toolbar\drawtextobjectbar.xml"
      File "${SRC}\share\config\soffice.cfg\modules\swriter\toolbar\formtextobjectbar.xml"
      File "${SRC}\share\config\soffice.cfg\modules\swriter\toolbar\textobjectbar.xml"

    SetOutPath "$INSTDIR\share\registry\data\org\openoffice\Office\UI"
      File "${SRC}\share\registry\data\org\openoffice\Office\UI\GenericCommands.xcu"

    Delete "$APPDATA\OpenOffice.org2\user\registry\cache\org.openoffice.Office.UI.GenericCommands.dat"

  SectionEnd

  Section "English support" WriterEnglish
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680en-US.res"
      File "${SRC}\program\resource\ofa680en-US.res"
      File "${SRC}\program\resource\ooo680en-US.res"
      File "${SRC}\program\resource\svx680en-US.res"
      File "${SRC}\program\resource\sw680en-US.res"
      File "${SRC}\program\resource\textconversiondlgs680en-US.res"

    SetOutPath "$INSTDIR\share\registry\res\de\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\de\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

  Section "German support" WriterGerman
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680de.res"
      File "${SRC}\program\resource\ofa680de.res"
      File "${SRC}\program\resource\ooo680de.res"
      File "${SRC}\program\resource\svx680de.res"
      File "${SRC}\program\resource\sw680de.res"
      File "${SRC}\program\resource\textconversiondlgs680de.res"

    SetOutPath "$INSTDIR\share\registry\res\en-US\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\en-US\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

  Section "Japanese support" WriterJapanese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680ja.res"
      File "${SRC}\program\resource\ofa680ja.res"
      File "${SRC}\program\resource\ooo680ja.res"
      File "${SRC}\program\resource\svx680ja.res"
      File "${SRC}\program\resource\sw680ja.res"
      File "${SRC}\program\resource\textconversiondlgs680ja.res"

    SetOutPath "$INSTDIR\share\registry\res\ja\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\ja\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

  Section "Korean support" WriterKorean
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680ko.res"
      File "${SRC}\program\resource\ofa680ko.res"
      File "${SRC}\program\resource\ooo680ko.res"
      File "${SRC}\program\resource\svx680ko.res"
      File "${SRC}\program\resource\sw680ko.res"
      File "${SRC}\program\resource\textconversiondlgs680ko.res"

    SetOutPath "$INSTDIR\share\registry\res\ko\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\ko\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

  Section "Simplified Chinese support" WriterSimplifiedChinese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680zh-CN.res"
      File "${SRC}\program\resource\ofa680zh-CN.res"
      File "${SRC}\program\resource\ooo680zh-CN.res"
      File "${SRC}\program\resource\svx680zh-CN.res"
      File "${SRC}\program\resource\sw680zh-CN.res"
      File "${SRC}\program\resource\textconversiondlgs680zh-CN.res"

    SetOutPath "$INSTDIR\share\registry\res\zh-CN\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\zh-CN\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

  Section "Traditional Chinese support" WriterTraditionalChinese
    SetOutPath "$INSTDIR\program\resource"
      File "${SRC}\program\resource\gal680zh-TW.res"
      File "${SRC}\program\resource\ofa680zh-TW.res"
      File "${SRC}\program\resource\ooo680zh-TW.res"
      File "${SRC}\program\resource\svx680zh-TW.res"
      File "${SRC}\program\resource\sw680zh-TW.res"
      File "${SRC}\program\resource\textconversiondlgs680zh-TW.res"

    SetOutPath "$INSTDIR\share\registry\res\zh-TW\org\openoffice\Office\UI"
      File "${SRC}\share\registry\res\zh-TW\org\openoffice\Office\UI\GenericCommands.xcu"
  SectionEnd

SectionGroupEnd

;--------------------------------
;Installer Functions

Function .onInit

  !insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd

;--------------------------------
;Descriptions

  ;USE A LANGUAGE STRING IF YOU WANT YOUR DESCRIPTIONS TO BE LANGAUGE SPECIFIC

  ;Assign descriptions to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN

    !insertmacro MUI_DESCRIPTION_TEXT ${GroupCalc} "Patch files for Calc"
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcDLL} "DLL files for Calc. This component is required for any language." 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcEnglish} "English language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcGerman} "German language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcJapanese} "Japanese language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcKorean} "Korean language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcSimplifiedChinese} "Simplified Chinese language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${CalcTraditionalChinese} "Traditional Chinese language support" 

    !insertmacro MUI_DESCRIPTION_TEXT ${GroupWriter} "Patch files for Writer"
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterDLL} "DLL files for Writer. This component is required for any language." 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterEnglish} "English language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterGerman} "German language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterJapanese} "Japanese language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterKorean} "Korean language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterSimplifiedChinese} "Simplified Chinese language support" 
    !insertmacro MUI_DESCRIPTION_TEXT ${WriterTraditionalChinese} "Traditional Chinese language support" 


  !insertmacro MUI_FUNCTION_DESCRIPTION_END

