#! /bin/bash

version=0.2.1

# Usage:
#   bash -x SolarisMakePackage.sh 2>&1 | tee SolarisMakePackage_`date +%Y%m%d_%H%M`.log

echo Making a package of jsdp2007
echo
echo Batch file version: $version
echo

start_time=`date`

# Exits immediately if a command fails
set -o errexit

if [[ "$SRC_ROOT" == "" ]]; then
    echo $0: error: \$SRC_ROOT is not set.
    exit 1
fi

lang="en-US $WITH_LANG"
util=$SRC_ROOT/instsetoo_jsdp2007/util
bin=$util/../$INPATH/bin
misc=$util/../$INPATH/misc
name=jsdp2007_2.4.0.1_OOo_2.4.0_Solarisx86
dir=$misc/$name
out=$dir/opt/openoffice.org2.4

tar=/usr/sfw/bin/gtar

cd $util

echo 
echo ===========
echo Preparation
echo ===========
perl $SOLARENV/bin/mkout.pl
if [ -d $dir ]; then /bin/rm -rf $dir ; fi

echo 
echo ======
echo README
echo ======
src=$util
dst=$dir
mkdir -p $dst
cp -p $src/README.txt $dst

echo 
echo ====================
echo Shared library files
echo ====================
src=$SOLARVER/$INPATH/lib
dst=$out/program
mkdir -p $dst
cp -p $src/libcui680si.so $dst/libcui680si.so
cp -p $src/libsvx680si.so $dst/libsvx680si.so
cp -p $src/libtextconversiondlgs680si.so $dst/libtextconversiondlgs680si.so
cp -p $src/libsc680si.so $dst/libsc680si.so
cp -p $src/libscd680si.so $dst/libscd680si.so
cp -p $src/libscui680si.so $dst/libscui680si.so
cp -p $src/libvbaobj680si.uno.so $dst/libvbaobj680si.uno.so
cp -p $src/libsw680si.so $dst/libsw680si.so
cp -p $src/libswd680si.so $dst/libswd680si.so
cp -p $src/libswui680si.so $dst/libswui680si.so
cp -p $src/libxo680si.so $dst/libxo680si.so
cp -p $src/libxof680si.so $dst/libxof680si.so

echo 
echo ==============
echo Resource files
echo ==============
src=$SOLARVER/$INPATH/bin
dst=$out/program/resource
mkdir -p $dst
for x in $lang
do
	cp -p $src/gal680$x.res $dst
	cp -p $src/ofa680$x.res $dst
	cp -p $src/ooo680$x.res $dst
	cp -p $src/svx680$x.res $dst
	cp -p $src/textconversiondlgs680$x.res $dst
	cp -p $src/sc680$x.res $dst
	cp -p $src/sw680$x.res $dst
done

echo 
echo ===============
echo Image ZIP files
echo ===============
src=$SRC_ROOT/instsetoo_native/$INPATH/bin
dst=$out/share/config
mkdir -p $dst
cp -p $src/images_crystal.zip $dst
cp -p $src/images_hicontrast.zip $dst
cp -p $src/images_industrial.zip $dst
cp -p $src/images_tango.zip $dst
cp -p $src/images.zip $dst

echo 
echo ===============================================
echo Configuration files for tool bars and menu bars
echo ===============================================
src=$SOLARVER/$INPATH/bin
dst=$out/share/config/soffice.cfg
mkdir -p $dst
unzip -d $dst $src/uiconfig.zip \
	modules/swriter/toolbar/formtextobjectbar.xml \
	modules/swriter/toolbar/textobjectbar.xml \
	modules/swriter/toolbar/drawtextobjectbar.xml \
	modules/swriter/menubar/menubar.xml

echo 
echo ========================================
echo Configuration files for generic commands
echo ========================================
src=$SOLARVER/$INPATH/xml
dst=$out/share/registry/data/org/openoffice/Office/UI
mkdir -p $dst
cp -p $src/registry/data/org/openoffice/Office/UI/GenericCommands.xcu $dst

echo 
echo ==================================================
echo Configuration files for localized generic commands
echo ==================================================
src=$SOLARVER/$INPATH/pck
for x in $lang
do
	dst=$out/share/registry/res/$x
	mkdir -p $dst
	unzip -d $dst $src/registry_$x.zip \
		org/openoffice/Office/UI/GenericCommands.xcu
done

echo 
echo =============================
echo Making a .tar.gz package file
echo =============================
# chown -R root:root $misc/$name
$tar -zcf $bin/$name.tar.gz -C $misc $name

echo

finish_time=`date`

echo =====================
echo Succesfully finished.
echo =====================
echo
echo Started : $start_time
echo Finished: $finish_time
echo
ls -l $bin/$name.tar.gz
echo
