#! /bin/bash

version=0.2.1

# Usage:
#   bash -x LinuxMakePackage.sh 2>&1 | tee LinuxMakePackage_`date +%Y%m%d_%H%M`.log

echo Making a package of jsdp2007
echo
echo Batch file version: $version
echo

start_time=`date`

# Exits immediately if a command fails
set -o errexit

if [[ "$SRC_ROOT" == "" ]]; then
    echo $0: error: \$SRC_ROOT is not set.
    exit 1
fi

lang="en-US $WITH_LANG"
util=$SRC_ROOT/instsetoo_jsdp2007/util
bin=$util/../$INPATH/bin
misc=$util/../$INPATH/misc
name=jsdp2007_2.4.0.1_OOo_2.4.0_LinuxIntel
dir=$misc/$name
out=$dir/opt/openoffice.org2.4

cd $util

echo 
echo ===========
echo Preparation
echo ===========
perl $SOLARENV/bin/mkout.pl
if [ -d $dir ]; then /bin/rm -rf $dir ; fi

echo 
echo ======
echo README
echo ======
src=$util
dst=$dir
mkdir -p $dst
cp -p $src/README.txt $dst

echo 
echo ====================
echo Shared library files
echo ====================
src=$SOLARVER/$INPATH/lib
dst=$out/program
mkdir -p $dst
cp -p $src/libcui680li.so $dst/libcui680li.so.1.1
cp -p $src/libsvx680li.so $dst/libsvx680li.so.1.1
cp -p $src/libtextconversiondlgs680li.so $dst/libtextconversiondlgs680li.so.1.1
cp -p $src/libsc680li.so $dst/libsc680li.so
cp -p $src/libscd680li.so $dst/libscd680li.so
cp -p $src/libscui680li.so $dst/libscui680li.so
cp -p $src/libvbaobj680li.uno.so $dst/libvbaobj680li.uno.so
cp -p $src/libsw680li.so $dst/libsw680li.so.1.1
cp -p $src/libswd680li.so $dst/libswd680li.so
cp -p $src/libswui680li.so $dst/libswui680li.so
cp -p $src/libxo680li.so $dst/libxo680li.so.1.1
cp -p $src/libxof680li.so $dst/libxof680li.so.1.1

echo 
echo ==============
echo Resource files
echo ==============
src=$SOLARVER/$INPATH/bin
dst=$out/program/resource
mkdir -p $dst
for x in $lang
do
	cp -p $src/gal680$x.res $dst
	cp -p $src/ofa680$x.res $dst
	cp -p $src/ooo680$x.res $dst
	cp -p $src/svx680$x.res $dst
	cp -p $src/textconversiondlgs680$x.res $dst
	cp -p $src/sc680$x.res $dst
	cp -p $src/sw680$x.res $dst
done

echo 
echo ===============
echo Image ZIP files
echo ===============
src=$SRC_ROOT/instsetoo_native/$INPATH/bin
dst=$out/share/config
mkdir -p $dst
cp -p $src/images_crystal.zip $dst
cp -p $src/images_hicontrast.zip $dst
cp -p $src/images_industrial.zip $dst
cp -p $src/images_tango.zip $dst
cp -p $src/images.zip $dst

echo 
echo ===============================================
echo Configuration files for tool bars and menu bars
echo ===============================================
src=$SOLARVER/$INPATH/bin
dst=$out/share/config/soffice.cfg
mkdir -p $dst
unzip -d $dst $src/uiconfig.zip \
	modules/swriter/toolbar/formtextobjectbar.xml \
	modules/swriter/toolbar/textobjectbar.xml \
	modules/swriter/toolbar/drawtextobjectbar.xml \
	modules/swriter/menubar/menubar.xml

echo 
echo ========================================
echo Configuration files for generic commands
echo ========================================
src=$SOLARVER/$INPATH/xml
dst=$out/share/registry/data/org/openoffice/Office/UI
mkdir -p $dst
cp -p $src/registry/data/org/openoffice/Office/UI/GenericCommands.xcu $dst

echo 
echo ==================================================
echo Configuration files for localized generic commands
echo ==================================================
src=$SOLARVER/$INPATH/pck
for x in $lang
do
	dst=$out/share/registry/res/$x
	mkdir -p $dst
	unzip -d $dst $src/registry_$x.zip \
		org/openoffice/Office/UI/GenericCommands.xcu
done

echo 
echo =============================
echo Making a .tar.gz package file
echo =============================
# chown -R root:root $misc/$name
tar -zcf $bin/$name.tar.gz -C $misc $name

echo

finish_time=`date`

echo =====================
echo Succesfully finished.
echo =====================
echo
echo Started : $start_time
echo Finished: $finish_time
echo
ls -l $bin/$name.tar.gz
echo
