#! /bin/bash --noprofile --norc

version=0.8.1

# Usage:
#   bash Build.sh 2>&1 | tee Build_`date +%Y%m%d_%H%M`.log

echo Batch file for building OpenOffice.org modules of jsdp2007
echo
echo Batch file version: $version
echo \$SRC_ROOT: $SRC_ROOT
echo

start_time=`date`

# Exits immediately if a command fails
set -o errexit

# Confirm if $SRC_ROOT is set and cd to $SRC_ROOT
if [[ "$SRC_ROOT" == "" ]]; then
    echo $0: error: \$SRC_ROOT is not set.
    exit 1
fi
if [ ! -d "$SRC_ROOT" ]; then
    echo $0: error: $SRC_ROOT does not exist.
    exit 1
fi
cd $SRC_ROOT

# Doing the build and deliver
function work() {
    perl $SOLARENV/bin/build.pl -- $PROFULLSWITCH
    echo
    perl $SOLARENV/bin/deliver.pl
    echo
}

# Building a module
function building() {
    echo '#####################'
    echo  $module
    echo '#####################'
    cd $SRC_ROOT/$module
    echo -n "Start: "
    date
    echo
    time work
    echo
    echo -n "End: "
    date
    echo
}

# A list of modules that will be built
modules=(
    offapi
    offuh
    xmloff
    officecfg
    svx
    sc
    sw
)

# Building modules
for module in ${modules[*]} ; do
    building
done

# Doing dmake in the directory postprocess/packconfig
module=postprocess
echo '#####################'
echo  $module
echo '#####################'
echo
cd $SRC_ROOT/$module/packconfig
date ; time dmake $PROFULLSWITCH ; date ; echo
echo
perl $SOLARENV/bin/deliver.pl
echo

# Doing dmake in the directory instsetoo_native/packimages
module=instsetoo_native
echo '#####################'
echo  $module
echo '#####################'
echo
cd $SRC_ROOT/$module/packimages
date ; time dmake $PROFULLSWITCH ; date ; echo

echo

finish_time=`date`

echo =========================================================
echo Building OpenOffice.org jsdp2007 is succesfully finished.
echo =========================================================
echo
echo Started : $start_time
echo Finished: $finish_time
echo
