/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile$
 *
 *  $Revision$
 *
 *  last change: $Author$ $Date$
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------
#ifndef _SVX_DLGFIXTXT_HXX
#include <svx/dlgfixtxt.hxx>
#endif

// -----------------------------------------------------------------------

SvxMetricFixedText::SvxMetricFixedText( Window* pParent, const ResId& rResId )
    : FixedText( pParent, rResId ),
      MetricFormatter()
{
}

// -----------------------------------------------------------------------

void SvxMetricFixedText::SetValue( sal_Int64 nNewValue, FieldUnit eInUnit )
{ 
    // Todo: Use of MetricField::ConvertValue should be reconsidered later.
    mnValue = MetricField::ConvertValue( nNewValue, mnBaseValue, GetDecimalDigits(), eInUnit, meUnit );
    SetText( CreateFieldText( mnValue ) );
}

// -----------------------------------------------------------------------

void SvxMetricFixedText::SetValue( long nCoreValue, SfxMapUnit eUnit )
{ 
    sal_Int64 nVal = OutputDevice::LogicToLogic( nCoreValue, (MapUnit)eUnit, MAP_100TH_MM );
    nVal = Normalize( nVal );
    SetValue( nVal, FUNIT_100TH_MM );
}

// -----------------------------------------------------------------------

sal_Int64 SvxMetricFixedText::GetValue( FieldUnit eOutUnit ) const
{
    // Todo: Use of MetricField::ConvertValue should be reconsidered later.
    return MetricField::ConvertValue( mnValue, mnBaseValue, GetDecimalDigits(), meUnit, eOutUnit );
}

// -----------------------------------------------------------------------

void SvxMetricFixedText::CustomConvert()
{
}

// -----------------------------------------------------------------------

SvxNumericFixedText::SvxNumericFixedText( Window* pParent, const ResId& rResId )
    : FixedText( pParent, rResId ),
      NumericFormatter()
{
}

// -----------------------------------------------------------------------

void SvxNumericFixedText::SetValue( sal_Int64 nNewValue )
{ 
    SetText( CreateFieldText( nNewValue ) );
}

// <--
