/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: enum.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:23:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_ENUM_HXX
#define UDM_ENUM_HXX


// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS

namespace udm
{


/** @resp
*/
class EnumInfo
{
  public:
    typedef ::std::pair< intt, ::csv::String >      value;

    // LIFECYCLE
    virtual             ~EnumInfo() {}

    // OPERATORS
    const value &       operator[](
                            INT16                   i_n ) const;
    // INQUIRY
    INT16               find(
                            intt                    i_n ) const;
    INT16               find(
                            const ::csv::String &   i_str ) const;
    INT16               size() const;

  private:
    virtual const value &
                        op_array(
                            INT16                   i_n ) const = 0;
    // INQUIRY
    virtual INT16       inq_Find(
                            intt                    i_n ) const = 0;
    virtual INT16       inq_Find(
                            const ::csv::String &   i_str ) const = 0;
    virtual INT16       inq_Size() const = 0;
};



class Enum : public Data
{
  public:
    virtual             ~Enum() {}

    // OPERATIONS
    Enum &              operator++();
    Enum &              operator--();
                        operator bool() const;
    // OPERATIONS
    void                assign(
                            intt                i_n );
    void                assign(
                            const ::csv::String &
                                                i_str );
    void                assign_first_value();

    // INQUIRY
    intt                v_int() const;
    ::csv::String       v_str() const;

    const EnumInfo &    enum_info() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    // Locals
    virtual const EnumInfo &
                        inq_EnumInfo() const = 0;
    // DATA
    INT16               nIndex;
};


// IMPLEMENTATION

inline const EnumInfo &
Enum::enum_info() const
    { return inq_EnumInfo(); }

inline Enum &
Enum::operator++()
    { if ( ++nIndex >= enum_info().size() )
          nIndex = -1;
      return *this;
    }

inline Enum &
Enum::operator--()
    { if ( --nIndex < 0 )
          nIndex = -1;
      return *this;
    }

inline
Enum::operator bool() const
    { return nIndex > -1; }

inline void
Enum::assign( intt i_n )
    { nIndex = enum_info().find(i_n); }

inline void
Enum::assign( const ::csv::String & i_str )
    { nIndex = enum_info().find(i_str); }

void
Enum::assign_first_value()
    { nIndex = 0; }

inline intt
Enum::v_int() const
    { return enum_info()[nIndex].first; }

inline ::csv::String
Enum::v_str() const
    { return enum_info()[nIndex].second; }


inline const EnumInfo::value &
EnumInfo::operator[](INT16 i_n) const
    { return op_array(i_n); }
inline INT16
EnumInfo::find(intt  i_n) const
    { return inq_Find(i_n); }
inline INT16
EnumInfo::find(const ::csv::String & i_str) const
    { return inq_Find(i_str); }
inline INT16
EnumInfo::size() const
    { return inq_Size(); }


}   // namespace udm


#endif

