/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: linectrl.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:01:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_LINECTRL_HXX
#define _SVX_LINECTRL_HXX

#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXTBXCTRL_HXX //autogen
#include <sfx2/tbxctrl.hxx>
#endif
#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class XLineStyleItem;
class XLineDashItem;
class SvxLineBox;
class SvxMetricField;
class SvxColorBox;
class XLineEndList;

//========================================================================
// SvxLineStyleController:
//========================================================================

class SVX_DLLPUBLIC SvxLineStyleToolBoxControl : public SfxToolBoxControl
{
private:
	XLineStyleItem*		pStyleItem;
	XLineDashItem* 		pDashItem;

	BOOL				bUpdate;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxLineStyleToolBoxControl( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxLineStyleToolBoxControl();

	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );
	void 		        Update( const SfxPoolItem* pState );
	virtual Window*		CreateItemWindow( Window *pParent );
};

//========================================================================
// SvxLineWidthController:
//========================================================================

class SVX_DLLPUBLIC SvxLineWidthToolBoxControl : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxLineWidthToolBoxControl( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxLineWidthToolBoxControl();

	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );
	virtual Window*		CreateItemWindow( Window *pParent );
};

//========================================================================
// SvxLineColorController:
//========================================================================

class SVX_DLLPUBLIC SvxLineColorToolBoxControl : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxLineColorToolBoxControl( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxLineColorToolBoxControl();

	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );
	void 		        Update( const SfxPoolItem* pState );
	virtual Window*		CreateItemWindow( Window *pParent );
};

//========================================================================
// class SvxLineEndWindow
//========================================================================
class SvxLineEndWindow : public SfxPopupWindow
{
private:
	XLineEndList*	pLineEndList;
	ValueSet		aLineEndSet;
	USHORT			nCols;
	USHORT			nLines;
	ULONG 			nLineEndWidth;
	Size			aBmpSize;
	BOOL			bPopupMode;
	bool			mbInResize;
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > mxFrame;

	DECL_LINK( SelectHdl, void * );
	void			FillValueSet();
	void 			SetSize();
    void            implInit();

protected:
	virtual void	Resizing( Size& rSize );
	virtual void    Resize();
	virtual BOOL	Close();
	virtual void	PopupModeEnd();

    /** This function is called when the window gets the focus.  It grabs
        the focus to the line ends value set so that it can be controlled with
        the keyboard.
    */
	virtual void GetFocus (void);

public:
    SvxLineEndWindow( USHORT nId, 
                      const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame, 
                      const String& rWndTitle );
    SvxLineEndWindow( USHORT nId, 
                      const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame, 
                      Window* pParentWindow,
                      const String& rWndTitle );
	~SvxLineEndWindow();

	void            StartSelection();

	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
	virtual SfxPopupWindow* Clone() const;
};

//========================================================================
// class SvxColorToolBoxControl
//========================================================================

class SVX_DLLPUBLIC SvxLineEndToolBoxControl : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();
	SvxLineEndToolBoxControl( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxLineEndToolBoxControl();

	virtual void				StateChanged( USHORT nSID, SfxItemState eState,
											  const SfxPoolItem* pState );
	virtual SfxPopupWindowType	GetPopupWindowType() const;
	virtual SfxPopupWindow*		CreatePopupWindow();
};

#endif

