/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: logfile.h,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:38:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _RTL_LOGFILE_H_
#define _RTL_LOGFILE_H_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/**	This function allows to log arbitrary messages even in a product-environment.

	The logfile is created on first access and closed, when the sal-library gets unloaded.
	The file is line buffered. A log file is not created if no log messages are
	written.

	The first time, rtl_logfile_trace is called, it checks for the bootstrap variable
	RTL_LOGFILE. If the variable is not empty, it creates a file with the name
	$(RTL_LOGFILE)_$(PID).log, where $(PID) is the process id of the running process.

	@param pszformat A format string with fprintf-syntax
	@param ...       An arbitrary number of arguments for fprintf, matching the
	                 format string.
*/
void SAL_CALL rtl_logfile_trace( const sal_Char* pszFormat, ... );

/** Like rtl_logfile_trace, but prefixing every log entry with the current time
    and thread ID.

	@param format
    a format string with fprintf-like syntax

	@param ...
    an arbitrary number of arguments for fprintf, matching the given format
    string

    @since UDK 3.2.0
*/
void SAL_CALL rtl_logfile_longTrace(char const * format, ...);

#ifdef __cplusplus
}
#endif

#ifdef TIMELOG
#define RTL_LOGFILE_TRACE( string )  \
             rtl_logfile_longTrace( "| : %s\n", string )
#define RTL_LOGFILE_TRACE1( frmt, arg1 ) \
             rtl_logfile_longTrace( "| : " ); \
             rtl_logfile_trace( frmt, arg1 ); \
             rtl_logfile_trace( "\n" )

#define RTL_LOGFILE_TRACE2( frmt, arg1 , arg2 ) \
             rtl_logfile_longTrace( "| : " ); \
             rtl_logfile_trace( frmt, arg1 , arg2 ); \
             rtl_logfile_trace( "\n" )
#define RTL_LOGFILE_TRACE3( frmt, arg1 , arg2 , arg3 ) \
             rtl_logfile_longTrace( "| : " ); \
             rtl_logfile_trace( frmt, arg1 , arg2 , arg3 ); \
             rtl_logfile_trace( "\n" )

//	Now the macros with project and author arguments.  The strings
//	are formatted in a way, so that the log file can be parsed by
//	post processing scripts.
#define RTL_LOGFILE_TRACE_AUTHOR( project, author, string )  \
             rtl_logfile_longTrace( "| %s (%s) : %s\n", \
								project,\
								author,\
                                string )
#define RTL_LOGFILE_TRACE_AUTHOR1( project, author, frmt, arg1 ) \
             rtl_logfile_longTrace( "| %s (%s) : ", \
								project,\
								author );\
             rtl_logfile_trace( frmt, arg1 ); \
             rtl_logfile_trace( "\n" )

#define RTL_LOGFILE_TRACE_AUTHOR2( project, author, frmt, arg1 , arg2 ) \
             rtl_logfile_longTrace( "| %s (%s) : ", \
								project,\
								author ); \
             rtl_logfile_trace( frmt, arg1 , arg2 ); \
             rtl_logfile_trace( "\n" )
#define RTL_LOGFILE_TRACE_AUTHOR3( project, author, frmt, arg1 , arg2 , arg3 ) \
             rtl_logfile_longTrace( "| %s (%s) : ", \
								project,\
								author ); \
             rtl_logfile_trace( frmt, arg1 , arg2 , arg3 ); \
             rtl_logfile_trace( "\n" )
#else
#define RTL_LOGFILE_TRACE( string )  ((void)0)
#define RTL_LOGFILE_TRACE1( frmt, arg1 ) ((void)0)
#define RTL_LOGFILE_TRACE2( frmt, arg1 , arg2 ) ((void)0)
#define RTL_LOGFILE_TRACE3( frmt, arg1 , arg2 , arg3 ) ((void)0)

#define RTL_LOGFILE_TRACE_AUTHOR( project, author, string )  ((void)0)
#define RTL_LOGFILE_TRACE_AUTHOR1( project, author, frmt, arg1 ) ((void)0)
#define RTL_LOGFILE_TRACE_AUTHOR2( project, author, frmt, arg1 , arg2 ) ((void)0)
#define RTL_LOGFILE_TRACE_AUTHOR3( project, author, frmt, arg1 , arg2 , arg3 ) ((void)0)
#endif // TIMELOG
#endif
