/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.GeneralFunction;
import com.sun.star.sheet.SubTotalColumn;
import com.sun.star.sheet.XDatabaseRange;
import com.sun.star.sheet.XSheetFilterDescriptor;
import com.sun.star.sheet.XSubTotalDescriptor;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDatabaseRange
extends MultiMethodTest {
    public XDatabaseRange oObj = null;
    CellRangeAddress oldCRA = null;
    XCellRange xCellRange = null;
    XSubTotalDescriptor STD = null;
    final short COL = 0;
    final short STARTROW = 0;
    final short ENDROW = (short)5;

    protected void before() {
        this.oldCRA = (CellRangeAddress)this.tEnv.getObjRelation("DATAAREA");
        if (this.oldCRA == null) {
            throw new StatusException(Status.failed("Relation 'DATAAREA' not found"));
        }
        this.xCellRange = (XCellRange)this.tEnv.getObjRelation("XCELLRANGE");
        if (this.xCellRange == null) {
            throw new StatusException(Status.failed("Relation 'XCELLRANGE' not found"));
        }
    }

    public void _getDataArea() {
        boolean bl = true;
        CellRangeAddress cellRangeAddress = this.oObj.getDataArea();
        bl &= cellRangeAddress.EndColumn == this.oldCRA.EndColumn;
        bl &= cellRangeAddress.EndRow == this.oldCRA.EndRow;
        bl &= cellRangeAddress.Sheet == this.oldCRA.Sheet;
        bl &= cellRangeAddress.StartColumn == this.oldCRA.StartColumn;
        this.tRes.tested("getDataArea()", bl &= cellRangeAddress.StartRow == this.oldCRA.StartRow);
    }

    public void _getFilterDescriptor() {
        XSheetFilterDescriptor xSheetFilterDescriptor = this.oObj.getFilterDescriptor();
        this.tRes.tested("getFilterDescriptor()", xSheetFilterDescriptor != null);
    }

    public void _getImportDescriptor() {
        PropertyValue[] propertyValueArray = this.oObj.getImportDescriptor();
        this.tRes.tested("getImportDescriptor()", propertyValueArray != null);
    }

    public void _getSortDescriptor() {
        PropertyValue[] propertyValueArray = this.oObj.getSortDescriptor();
        this.tRes.tested("getSortDescriptor()", propertyValueArray != null);
    }

    public void _getSubTotalDescriptor() {
        this.STD = this.oObj.getSubTotalDescriptor();
        this.tRes.tested("getSubTotalDescriptor()", this.STD != null);
    }

    public void _refresh() {
        this.requiredMethod("getSubTotalDescriptor()");
        this.requiredMethod("setDataArea()");
        for (int i = 0; i < 6; ++i) {
            try {
                XCell xCell = this.xCellRange.getCellByPosition(0, i);
                xCell.setValue((double)i);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                this.tRes.tested("refresh()", false);
            }
        }
        SubTotalColumn[] subTotalColumnArray = new SubTotalColumn[]{new SubTotalColumn()};
        subTotalColumnArray[0].Column = 0;
        subTotalColumnArray[0].Function = GeneralFunction.SUM;
        double d = 0.0;
        try {
            XCell xCell = this.xCellRange.getCellByPosition(0, 5);
            d = xCell.getValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + d);
        this.log.println("Set new SubTotal descriptor...");
        this.STD.clear();
        this.STD.addNew(subTotalColumnArray, 1);
        double d2 = 0.0;
        try {
            XCell xCell = this.xCellRange.getCellByPosition(0, 5);
            d2 = xCell.getValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + d2);
        this.log.println("Now call refresh()...");
        this.oObj.refresh();
        double d3 = 0.0;
        try {
            XCell xCell = this.xCellRange.getCellByPosition(0, 5);
            d3 = xCell.getValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + d3);
        this.tRes.tested("refresh()", d != d3 && d == d2);
    }

    public void _setDataArea() {
        this.executeMethod("getDataArea()");
        CellRangeAddress cellRangeAddress = new CellRangeAddress();
        cellRangeAddress.Sheet = this.oldCRA.Sheet;
        cellRangeAddress.StartColumn = 0;
        cellRangeAddress.EndColumn = 0;
        cellRangeAddress.StartRow = 0;
        cellRangeAddress.EndRow = 5;
        this.oObj.setDataArea(cellRangeAddress);
        this.tRes.tested("setDataArea()", true);
    }

    protected void after() {
        this.disposeEnvironment();
    }
}

