/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;

public class _XHierarchicalPropertySet
extends MultiMethodTest {
    public XHierarchicalPropertySet oObj;

    public void _getHierarchicalPropertySetInfo() {
        XHierarchicalPropertySetInfo xHierarchicalPropertySetInfo = this.oObj.getHierarchicalPropertySetInfo();
        boolean bl = true;
        if (xHierarchicalPropertySetInfo == null) {
            this.log.println("The component doesn't provide HierarchicalPropertySetInfo");
            this.tRes.tested("getHierarchicalPropertySetInfo()", Status.skipped(true));
            return;
        }
        bl = this.checkHPSI(xHierarchicalPropertySetInfo);
        this.tRes.tested("getHierarchicalPropertySetInfo()", bl);
    }

    public void _getHierarchicalPropertyValue() {
        String[] stringArray = (String[])this.tEnv.getObjRelation("PropertyNames");
        String[] stringArray2 = (String[])this.tEnv.getObjRelation("PropertyTypes");
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.log.print("Property " + stringArray[i]);
                Object object = this.oObj.getHierarchicalPropertyValue(stringArray[i]);
                this.log.println(" has Value " + object.toString());
                bl &= this.checkType(stringArray[i], stringArray2[i], object);
                continue;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                this.log.println(" is unknown");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println(" is illegal");
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println(" throws expeption " + wrappedTargetException.getMessage());
            }
        }
        this.tRes.tested("getHierarchicalPropertyValue()", bl);
    }

    public void _setHierarchicalPropertyValue() {
        String string = (String)this.tEnv.getObjRelation("allReadOnly");
        if (string != null) {
            this.log.println(string);
            this.tRes.tested("setHierarchicalPropertyValue()", Status.skipped(true));
            return;
        }
        boolean bl = true;
        String[] stringArray = (String[])this.tEnv.getObjRelation("PropertyNames");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.oObj.getHierarchicalPropertyValue(stringArray[i]);
                Object object2 = ValueChanger.changePValue(object);
                this.oObj.setHierarchicalPropertyValue(stringArray[i], object2);
                Object object3 = this.oObj.getHierarchicalPropertyValue(stringArray[i]);
                boolean bl2 = ValueComparer.equalValue(object3, object2);
                if (!bl2) {
                    this.log.println("Expected " + object2.toString());
                    this.log.println("Gained " + object3.toString());
                }
                this.oObj.setHierarchicalPropertyValue(stringArray[i], object);
                bl &= bl2;
                continue;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                this.log.println("Property is unknown");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("IllegalArgument " + illegalArgumentException.getMessage());
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                this.log.println("VetoException " + propertyVetoException.getMessage());
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println("WrappedTarget " + wrappedTargetException.getMessage());
            }
        }
        this.tRes.tested("setHierarchicalPropertyValue()", bl);
    }

    protected boolean checkHPSI(XHierarchicalPropertySetInfo xHierarchicalPropertySetInfo) {
        this.log.println("Checking the resulting HierarchicalPropertySetInfo");
        this.log.println("### NOT yet implemented");
        return true;
    }

    protected boolean checkType(String string, String string2, Object object) {
        boolean bl = true;
        if (string2.equals("Boolean")) {
            bl = object instanceof Boolean;
            if (!bl) {
                this.log.println("Wrong Type for property " + string);
                this.log.println("Expected " + string2);
                this.log.println("getting " + object.getClass());
            }
        } else if (string2.equals("Short") && !(bl = object instanceof Short)) {
            this.log.println("Wrong Type for property " + string);
            this.log.println("Expected " + string2);
            this.log.println("getting " + object.getClass());
        }
        return bl;
    }
}

