/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.awt.FocusEvent;
import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.PaintEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.WindowEvent;
import com.sun.star.awt.XFocusListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XMouseMotionListener;
import com.sun.star.awt.XPaintListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowListener;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.EventObject;
import lib.MultiMethodTest;
import util.ValueComparer;

public class _XWindow
extends MultiMethodTest {
    public XWindow oObj = null;
    private Rectangle posSize = null;
    private XWindow win = null;
    private TestWindowListener wListener = new TestWindowListener();
    private TestFocusListener fListener = new TestFocusListener();
    private TestKeyListener kListener = new TestKeyListener();
    private TestMouseListener mListener = new TestMouseListener();
    private TestMouseMotionListener mmListener = new TestMouseMotionListener();
    private TestPaintListener pListener = new TestPaintListener();

    public void _getPosSize() {
        this.posSize = this.oObj.getPosSize();
        this.tRes.tested("getPosSize()", this.posSize != null);
    }

    public void _setPosSize() {
        Rectangle rectangle = new Rectangle();
        this.requiredMethod("getPosSize()");
        rectangle.X = this.posSize.X + 1;
        rectangle.Y = this.posSize.Y + 1;
        rectangle.Width = this.posSize.Width - 3;
        rectangle.Height = this.posSize.Height - 3;
        this.oObj.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)15);
        Rectangle rectangle2 = this.oObj.getPosSize();
        this.log.println("Was : (" + this.posSize.X + ", " + this.posSize.Y + ", " + this.posSize.Width + ", " + this.posSize.Height + "), ");
        this.log.println("Set : (" + rectangle.X + ", " + rectangle.Y + ", " + rectangle.Width + ", " + rectangle.Height + "), ");
        this.log.println("Get : (" + rectangle2.X + ", " + rectangle2.Y + ", " + rectangle2.Width + ", " + rectangle2.Height + "). ");
        this.tRes.tested("setPosSize()", ValueComparer.equalValue(rectangle, rectangle2));
    }

    public void _setFocus() {
        this.win = (XWindow)this.tEnv.getObjRelation("XWindow.AnotherWindow");
        this.oObj.setFocus();
        this.win.setFocus();
        this.oObj.setFocus();
        this.tRes.tested("setFocus()", true);
    }

    public void _setVisible() {
        this.oObj.setVisible(false);
        this.oObj.setVisible(true);
        this.tRes.tested("setVisible()", true);
    }

    public void _setEnable() {
        this.oObj.setEnable(false);
        this.oObj.setEnable(true);
        this.tRes.tested("setEnable()", true);
    }

    public void _addWindowListener() {
        this.executeMethod("setPosSize()");
        this.executeMethod("setVisible()");
        boolean bl = true;
        this.oObj.addWindowListener((XWindowListener)this.wListener);
        XControlShape xControlShape = (XControlShape)this.tEnv.getObjRelation("XWindow.ControlShape");
        this.log.println("change object position and size...");
        if (xControlShape != null) {
            try {
                Size size = xControlShape.getSize();
                size.Height += 100;
                xControlShape.setSize(size);
                Point point = xControlShape.getPosition();
                point.X += 100;
                xControlShape.setPosition(point);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.log.println("Couldn't change size or position: ");
                propertyVetoException.printStackTrace(this.log);
            }
        } else {
            this.oObj.setPosSize(this.posSize.X + 2, 0, 0, 0, (short)1);
            this.oObj.setPosSize(0, 0, 100, 100, (short)4);
        }
        this.shortWait();
        boolean bl2 = this.wListener.resized && this.wListener.moved && !this.wListener.hidden && !this.wListener.shown;
        bl &= bl2;
        if (!bl2) {
            this.log.println("\twindowHidden()  wasn't called: " + !this.wListener.hidden);
            this.log.println("\twindowShown()   wasn't called: " + !this.wListener.shown);
            this.log.println("\twindowResized()    was called: " + this.wListener.resized);
            this.log.println("\twindowMoved()      was called: " + this.wListener.moved);
        } else {
            this.log.println("windowMoved() and windowResized() was called");
        }
        this.wListener.init();
        this.shortWait();
        this.log.println("set object invisible...");
        this.oObj.setVisible(false);
        this.shortWait();
        bl2 = this.wListener.hidden && !this.wListener.resized && !this.wListener.moved && !this.wListener.shown;
        bl &= bl2;
        if (!bl2) {
            this.log.println("\twindowHidden()     was called: " + this.wListener.hidden);
            this.log.println("\twindowShown()   wasn't called: " + !this.wListener.shown);
            this.log.println("\twindowResized() wasn't called: " + !this.wListener.resized);
            this.log.println("\twindowMoved()   wasn't called: " + !this.wListener.moved);
        } else {
            this.log.println("windowHidden() was called");
        }
        this.wListener.init();
        this.shortWait();
        this.log.println("set object visible...");
        this.oObj.setVisible(true);
        this.shortWait();
        bl2 = this.wListener.shown && !this.wListener.resized && !this.wListener.hidden && !this.wListener.moved;
        bl &= bl2;
        if (!bl2) {
            this.log.println("\twindowHidden()  wasn't called: " + !this.wListener.hidden);
            this.log.println("\twindowShown()      was called: " + this.wListener.shown);
            this.log.println("\twindowResized() wasn't called: " + !this.wListener.resized);
            this.log.println("\twindowMoved()   wasn't called: " + !this.wListener.moved);
        } else {
            this.log.println("windowShown() was called");
        }
        this.tRes.tested("addWindowListener()", bl);
    }

    public void _removeWindowListener() {
        this.requiredMethod("addWindowListener()");
        this.oObj.removeWindowListener((XWindowListener)this.wListener);
        this.wListener.init();
        this.oObj.setPosSize(this.posSize.X, this.posSize.Y, this.posSize.Width, this.posSize.Height, (short)15);
        this.oObj.setVisible(false);
        this.oObj.setVisible(true);
        boolean bl = !this.wListener.resized && !this.wListener.moved && !this.wListener.hidden && !this.wListener.shown;
        this.tRes.tested("removeWindowListener()", bl);
    }

    public void _addFocusListener() {
        boolean bl = true;
        this.requiredMethod("setFocus()");
        this.oObj.addFocusListener((XFocusListener)this.fListener);
        this.oObj.setFocus();
        this.shortWait();
        this.win.setFocus();
        this.shortWait();
        bl &= this.fListener.lost;
        if (!this.fListener.lost) {
            this.log.println("Lost focus was not notified about");
        }
        this.oObj.setFocus();
        this.shortWait();
        bl &= this.fListener.gained;
        if (!this.fListener.gained) {
            this.log.println("Gained focus was not notified about");
        }
        this.tRes.tested("addFocusListener()", bl);
    }

    public void _removeFocusListener() {
        this.requiredMethod("addFocusListener()");
        this.oObj.removeFocusListener((XFocusListener)this.fListener);
        this.fListener.init();
        this.oObj.setFocus();
        this.win.setFocus();
        this.oObj.setFocus();
        boolean bl = !this.fListener.gained && !this.fListener.lost;
        this.tRes.tested("removeFocusListener()", bl);
    }

    public void _addKeyListener() {
        this.oObj.addKeyListener((XKeyListener)this.kListener);
        this.tRes.tested("addKeyListener()", true);
    }

    public void _removeKeyListener() {
        this.requiredMethod("addKeyListener()");
        this.oObj.removeKeyListener((XKeyListener)this.kListener);
        this.tRes.tested("removeKeyListener()", true);
    }

    public void _addMouseListener() {
        this.oObj.addMouseListener((XMouseListener)this.mListener);
        this.tRes.tested("addMouseListener()", true);
    }

    public void _removeMouseListener() {
        this.requiredMethod("addMouseListener()");
        this.oObj.removeMouseListener((XMouseListener)this.mListener);
        this.tRes.tested("removeMouseListener()", true);
    }

    public void _addMouseMotionListener() {
        this.oObj.addMouseMotionListener((XMouseMotionListener)this.mmListener);
        this.tRes.tested("addMouseMotionListener()", true);
    }

    public void _removeMouseMotionListener() {
        this.requiredMethod("addMouseMotionListener()");
        this.oObj.removeMouseMotionListener((XMouseMotionListener)this.mmListener);
        this.tRes.tested("removeMouseMotionListener()", true);
    }

    public void _addPaintListener() {
        this.oObj.addPaintListener((XPaintListener)this.pListener);
        this.tRes.tested("addPaintListener()", true);
    }

    public void _removePaintListener() {
        this.requiredMethod("addPaintListener()");
        this.oObj.removePaintListener((XPaintListener)this.pListener);
        this.tRes.tested("removePaintListener()", true);
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }

    public class TestPaintListener
    implements XPaintListener {
        public boolean paint = false;

        public void windowPaint(PaintEvent paintEvent) {
            this.paint = true;
        }

        public void disposing(EventObject eventObject) {
        }

        public void init() {
            this.paint = false;
        }
    }

    public class TestMouseMotionListener
    implements XMouseMotionListener {
        public boolean dragged = false;
        public boolean moved = false;

        public void mouseDragged(MouseEvent mouseEvent) {
            this.dragged = true;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.moved = true;
        }

        public void disposing(EventObject eventObject) {
        }

        public void init() {
            this.dragged = false;
            this.moved = false;
        }
    }

    public class TestMouseListener
    implements XMouseListener {
        public boolean pressed = false;
        public boolean released = false;
        public boolean entered = false;
        public boolean exited = false;

        public void mousePressed(MouseEvent mouseEvent) {
            this.pressed = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.released = true;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.entered = true;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.exited = true;
        }

        public void disposing(EventObject eventObject) {
        }

        public void init() {
            this.pressed = false;
            this.released = false;
            this.exited = false;
            this.entered = false;
        }
    }

    public class TestKeyListener
    implements XKeyListener {
        public boolean pressed = false;
        public boolean released = false;

        public void keyPressed(KeyEvent keyEvent) {
            this.pressed = true;
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.released = true;
        }

        public void disposing(EventObject eventObject) {
        }

        public void init() {
            this.pressed = false;
            this.released = false;
        }
    }

    public class TestFocusListener
    implements XFocusListener {
        public boolean gained = false;
        public boolean lost = false;

        public void focusGained(FocusEvent focusEvent) {
            this.gained = true;
        }

        public void focusLost(FocusEvent focusEvent) {
            this.lost = true;
        }

        public void init() {
            this.gained = false;
            this.lost = false;
        }

        public void disposing(EventObject eventObject) {
        }
    }

    public class TestWindowListener
    implements XWindowListener {
        public boolean resized = false;
        public boolean moved = false;
        public boolean hidden = false;
        public boolean shown = false;

        public void init() {
            this.resized = false;
            this.moved = false;
            this.hidden = false;
            this.shown = false;
        }

        public void windowResized(WindowEvent windowEvent) {
            this.resized = true;
        }

        public void windowMoved(WindowEvent windowEvent) {
            this.moved = true;
        }

        public void windowHidden(EventObject eventObject) {
            this.hidden = true;
        }

        public void windowShown(EventObject eventObject) {
            this.shown = true;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

