/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.SysUtils;

public class _XAccessibleText
extends MultiMethodTest {
    public XAccessibleText oObj = null;
    protected Rectangle bounds = null;
    String text = null;
    String editOnly = null;
    Object LimitedBounds = null;
    Rectangle chBounds = null;
    int chCount = 0;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    protected void before() {
        Object object = this.tEnv.getObjRelation("XAccessibleText");
        XAccessibleComponent xAccessibleComponent = null;
        if (object != null) {
            this.oObj = (XAccessibleText)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = _XAccessibleText.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText, object);
            xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = _XAccessibleText.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, object);
        }
        this.text = (String)this.tEnv.getObjRelation("XAccessibleText.Text");
        if (this.text == null) {
            this.text = this.oObj.getText();
        }
        if (this.text.length() == 0) {
            throw new StatusException(Status.failed("The length of text must be greater than zero"));
        }
        this.editOnly = (String)this.tEnv.getObjRelation("EditOnly");
        this.LimitedBounds = this.tEnv.getObjRelation("LimitedBounds");
        if (xAccessibleComponent == null) {
            xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = _XAccessibleText.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, (Object)this.tEnv.getTestObject());
        }
        this.bounds = xAccessibleComponent.getBounds();
        this.log.println("Text is '" + this.text + "'");
        System.out.println("############################");
    }

    public void _getCaretPosition() {
        this.requiredMethod("getCharacterCount()");
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        boolean bl = true;
        boolean bl2 = true;
        try {
            this.oObj.setCaretPosition(this.chCount - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int n = this.oObj.getCaretPosition();
        this.log.println("getCaretPosition: " + n);
        if (bl2) {
            bl = n == this.chCount - 1;
        } else {
            this.log.println("Object is read only and Caret position couldn't be set");
            bl = n == -1;
        }
        this.tRes.tested("getCaretPosition()", bl);
    }

    public void _setCaretPosition() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        try {
            this.log.print("setCaretPosition(-1):");
            this.oObj.setCaretPosition(-1);
            bl &= false;
            this.log.println("exception was expected ... FAILED");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("setCaretPosition(chCount+1):");
            this.oObj.setCaretPosition(this.chCount + 1);
            bl &= false;
            this.log.println("exception was expected  ... FAILED");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.println("setCaretPosition(chCount - 1)");
            this.oObj.setCaretPosition(this.chCount - 1);
            bl &= true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("unexpected exception  ... FAILED");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("setCaretPosition()", bl);
    }

    public void _getCharacter() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        try {
            this.log.println("getCharacter(-1)");
            this.oObj.getCharacter(-1);
            this.log.println("Exception was expected");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl = true;
        }
        try {
            this.log.println("getCharacter(chCount)");
            this.oObj.getCharacter(this.chCount);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.println("Checking of every character in the text...");
            boolean bl2 = true;
            for (int i = 0; i < this.chCount; ++i) {
                char c = this.oObj.getCharacter(i);
                bl2 = c == this.text.charAt(i);
                bl &= bl2;
                if (bl2) continue;
                this.log.println("At the position " + i + "was expected character: " + this.text.charAt(i));
                this.log.println("but was returned: " + c);
                break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getCharacter()", bl);
    }

    public void _getCharacterAttributes() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        String[] stringArray = new String[]{""};
        try {
            this.log.println("getCharacterAttributes(-1)");
            this.oObj.getCharacterAttributes(-1, stringArray);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.println("getCharacterAttributes(chCount)");
            this.oObj.getCharacterAttributes(this.chCount, stringArray);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.println("getCharacterAttributes(chCount-1)");
            PropertyValue[] propertyValueArray = this.oObj.getCharacterAttributes(this.chCount - 1, stringArray);
            bl &= propertyValueArray != null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getCharacterAttributes()", bl);
    }

    public void _getCharacterBounds() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        int n = this.chCount;
        if (this.LimitedBounds != null) {
            n = this.LimitedBounds instanceof Integer ? (Integer)this.LimitedBounds : this.chCount - 1;
            this.log.println(this.LimitedBounds);
        }
        try {
            this.log.println("getCharacterBounds(-1)");
            this.oObj.getCharacterBounds(-1);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.println("getCharacterBounds(" + (n + 1) + ")");
            this.oObj.getCharacterBounds(n + 1);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            for (int i = 0; i < n; ++i) {
                this.log.println("getCharacterBounds(" + i + ")");
                this.chBounds = this.oObj.getCharacterBounds(i);
                boolean bl2 = true;
                bl2 = this.chBounds.X >= 0;
                bl2 &= this.chBounds.Y >= 0;
                bl2 &= this.chBounds.X + this.chBounds.Width <= this.bounds.Width;
                bl2 &= this.chBounds.X + this.chBounds.Width > 0;
                bl2 &= this.chBounds.Y + this.chBounds.Height <= this.bounds.Height;
                if (bl2 &= this.chBounds.Y + this.chBounds.Height > 0) continue;
                this.log.println("Text at this place: " + this.oObj.getCharacter(i));
                this.log.println("Character bounds outside component");
                this.log.println("Character rect: " + this.chBounds.X + ", " + this.chBounds.Y + ", " + this.chBounds.Width + ", " + this.chBounds.Height);
                this.log.println("Component rect: " + this.bounds.X + ", " + this.bounds.Y + ", " + this.bounds.Width + ", " + this.bounds.Height);
                bl &= bl2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getCharacterBounds()", bl);
    }

    public void _getCharacterCount() {
        this.chCount = this.oObj.getCharacterCount();
        this.log.println("Character count:" + this.chCount);
        boolean bl = this.chCount == this.text.length();
        this.tRes.tested("getCharacterCount()", bl);
    }

    public void _getIndexAtPoint() {
        boolean bl = true;
        this.log.print("getIndexAtPoint(-1, -1):");
        Point point = new Point(-1, -1);
        int n = this.oObj.getIndexAtPoint(point);
        this.log.println(n);
        bl &= n == -1;
        int n2 = this.chCount;
        if (this.LimitedBounds != null) {
            n2 = this.LimitedBounds instanceof Integer ? (Integer)this.LimitedBounds : this.chCount - 1;
            this.log.println(this.LimitedBounds);
        }
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = null;
            String string = "empty";
            try {
                rectangle = this.oObj.getCharacterBounds(i);
                string = this.oObj.getTextAtIndex((int)i, (short)1).SegmentText;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int n3 = rectangle.X + rectangle.Width / 2;
            int n4 = rectangle.Y + rectangle.Height / 2;
            Point point2 = new Point(n3, n4);
            int n5 = this.oObj.getIndexAtPoint(point2);
            n3 = rectangle.X;
            n4 = rectangle.Y + rectangle.Height / 2;
            point2 = new Point(n3, n4);
            int n6 = this.oObj.getIndexAtPoint(point2);
            int[] nArray = (int[])this.tEnv.getObjRelation("PreviousUsed");
            if (nArray != null) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (i != nArray[j]) continue;
                    ++n5;
                }
            }
            if (n5 == i || n6 == i) continue;
            this.log.println("## Method didn't work for Point (" + n3 + "," + n4 + ")");
            this.log.println("Expected Index " + i);
            this.log.println("Gained Index: " + n5);
            this.log.println("Left Border: " + n6);
            this.log.println("CharacterAtIndex: " + string);
            bl &= false;
        }
        this.tRes.tested("getIndexAtPoint()", bl);
    }

    public void _getSelectedText() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean bl = true;
        try {
            this.log.println("setSelection(0, 0)");
            this.oObj.setSelection(0, 0);
            this.log.print("getSelectedText():");
            String string = this.oObj.getSelectedText();
            this.log.println("'" + string + "'");
            bl &= string.length() == 0;
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            this.log.print("getSelectedText():");
            string = this.oObj.getSelectedText();
            this.log.println("'" + string + "'");
            bl &= string.equals(this.text);
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                this.log.print("getSelectedText():");
                string = this.oObj.getSelectedText();
                this.log.println("'" + string + "'");
                bl &= string.equals(this.text.substring(1, this.chCount - 1));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getSelectedText()", bl);
    }

    public void _getSelectionStart() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean bl = true;
        try {
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            int n = this.oObj.getSelectionStart();
            this.log.println("getSelectionStart():" + n);
            bl &= n == 0;
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                n = this.oObj.getSelectionStart();
                this.log.println("getSelectionStart():" + n);
                bl &= n == 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getSelectionStart()", bl);
    }

    public void _getSelectionEnd() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean bl = true;
        try {
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            int n = this.oObj.getSelectionEnd();
            this.log.println("getSelectionEnd():" + n);
            bl &= n == this.chCount;
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                n = this.oObj.getSelectionEnd();
                this.log.println("getSelectionEnd():" + n);
                bl &= n == this.chCount - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getSelectionEnd()", bl);
    }

    public void _setSelection() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        boolean bl2 = true;
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        try {
            this.log.print("setSelection(-1, chCount-1):");
            bl2 = this.oObj.setSelection(-1, this.chCount - 1);
            this.log.println(bl2 + " excepion was expected");
            bl &= !bl2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.print("setSelection(0, chCount+1):");
            bl2 = this.oObj.setSelection(0, this.chCount + 1);
            this.log.println(bl2 + " excepion was expected");
            bl &= !bl2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            if (this.chCount > 2) {
                this.log.print("setSelection(1, chCount-1):");
                bl2 = this.oObj.setSelection(1, this.chCount - 1);
                this.log.println(bl2);
                bl &= bl2;
                this.log.print("setSelection(chCount-1, 1):");
                bl2 = this.oObj.setSelection(this.chCount - 1, 1);
                this.log.println(bl2);
                bl &= bl2;
            }
            this.log.print("setSelection(0, chCount-1):");
            bl2 = this.oObj.setSelection(0, this.chCount - 1);
            this.log.println(bl2);
            bl &= bl2;
            this.log.print("setSelection(chCount-1, 0):");
            bl2 = this.oObj.setSelection(this.chCount - 1, 0);
            this.log.println(bl2);
            bl &= bl2;
            this.log.print("setSelection(0, 0):");
            bl2 = this.oObj.setSelection(0, 0);
            this.log.println(bl2);
            bl &= bl2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("setSelection()", bl);
    }

    public void _getText() {
        String string = this.oObj.getText();
        this.log.println("getText: " + string);
        boolean bl = string.equals(this.text);
        this.tRes.tested("getText()", bl);
    }

    public void _getTextRange() {
        this.requiredMethod("getCharacterCount()");
        boolean bl = true;
        boolean bl2 = true;
        String string = "";
        try {
            if (this.chCount > 3) {
                this.log.print("getTextRange(1, chCount - 2): ");
                string = this.oObj.getTextRange(1, this.chCount - 2);
                this.log.println(string);
                bl2 = string.equals(this.text.substring(1, this.chCount - 2));
                bl &= bl2;
                if (!bl2) {
                    this.log.println("Was expected: " + this.text.substring(1, this.chCount - 2));
                }
            }
            this.log.print("getTextRange(0, chCount-1): ");
            string = this.oObj.getTextRange(0, this.chCount - 1);
            this.log.println(string);
            bl2 = string.equals(this.text.substring(0, this.chCount - 1));
            bl &= bl2;
            if (!bl2) {
                this.log.println("Was expected: " + this.text.substring(0, this.chCount - 1));
            }
            this.log.print("getTextRange(chCount, 0): ");
            string = this.oObj.getTextRange(this.chCount, 0);
            this.log.println(string);
            bl &= string.equals(this.text);
            this.log.print("getTextRange(0, 0): ");
            string = this.oObj.getTextRange(0, 0);
            this.log.println(string);
            bl2 = string.equals("");
            bl &= bl2;
            if (!bl2) {
                this.log.println("Empty string was expected");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        try {
            this.log.print("getTextRange(-1, chCount - 1): ");
            string = this.oObj.getTextRange(-1, this.chCount - 1);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.print("getTextRange(0, chCount + 1): ");
            string = this.oObj.getTextRange(0, this.chCount + 1);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        try {
            this.log.print("getTextRange(chCount+1, -1): ");
            string = this.oObj.getTextRange(this.chCount + 1, -1);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        this.tRes.tested("getTextRange()", bl);
    }

    public void _getTextAtIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment textSegment = null;
        boolean bl = true;
        try {
            this.log.print("getTextAtIndex(-1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextAtIndex(-1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= false;
        }
        try {
            this.log.print("getTextAtIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextAtIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= false;
        }
        try {
            this.log.print("getTextAtIndex(chCount, AccessibleTextType.WORD):");
            textSegment = this.oObj.getTextAtIndex(this.chCount, (short)2);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= this.compareLength(0, textSegment.SegmentText);
            if (!this.tEnv.getTestCase().getObjectName().equals("SmGraphicAccessible")) {
                this.log.print("getTextAtIndex(1, AccessibleTextType.PARAGRAPH):");
                textSegment = this.oObj.getTextAtIndex(1, (short)4);
                this.log.println("'" + textSegment.SegmentText + "'");
                bl &= this.compareStrings(this.text, textSegment.SegmentText);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Unexpected exception");
            illegalArgumentException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getTextAtIndex()", bl);
    }

    public void _getTextBeforeIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment textSegment = null;
        boolean bl = true;
        try {
            this.log.print("getTextBeforeIndex(-1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBeforeIndex(-1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= false;
        }
        try {
            this.log.print("getTextBeforeIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBeforeIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= true;
        }
        try {
            if (!this.tEnv.getTestCase().getObjectName().equals("SmGraphicAccessible")) {
                this.log.print("getTextBeforeIndex(chCount, AccessibleTextType.WORD):");
                textSegment = this.oObj.getTextBeforeIndex(this.chCount, (short)2);
                this.log.println("'" + textSegment.SegmentText + "'");
                bl &= this.compareLength(this.chCount, textSegment.SegmentText);
            }
            this.log.print("getTextBeforeIndex(1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBeforeIndex(1, (short)4);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= this.compareLength(0, textSegment.SegmentText);
            this.log.print("getTextBeforeIndex(chCount-1, AccessibleTextType.CHARACTER):");
            textSegment = this.oObj.getTextBeforeIndex(this.chCount - 1, (short)1);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= this.compareStrings(this.text.substring(this.chCount - 2, this.chCount - 1), textSegment.SegmentText);
            if (this.chCount > 2) {
                this.log.print("getTextBeforeIndex(2, AccessibleTextType.CHARACTER):");
                textSegment = this.oObj.getTextBeforeIndex(2, (short)1);
                this.log.println("'" + textSegment.SegmentText + "'");
                bl &= this.compareStrings(this.text.substring(1, 2), textSegment.SegmentText);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Unexpected exception");
            illegalArgumentException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getTextBeforeIndex()", bl);
    }

    public void _getTextBehindIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment textSegment = null;
        boolean bl = true;
        try {
            this.log.print("getTextBehindIndex(-1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBehindIndex(-1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= true;
        }
        try {
            this.log.print("getTextBehindIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBehindIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected exception");
            bl &= true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("UnExpected exception");
            bl &= true;
        }
        try {
            this.log.print("getTextBehindIndex(chCount, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBehindIndex(this.chCount, (short)4);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= textSegment.SegmentText.length() == 0;
            this.log.print("getTextBehindIndex(chCount-1, AccessibleTextType.PARAGRAPH):");
            textSegment = this.oObj.getTextBehindIndex(this.chCount - 1, (short)4);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= textSegment.SegmentText.length() == 0;
            this.log.print("getTextBehindIndex(1, AccessibleTextType.CHARACTER):");
            textSegment = this.oObj.getTextBehindIndex(1, (short)1);
            this.log.println("'" + textSegment.SegmentText + "'");
            bl &= textSegment.SegmentText.equals(this.text.substring(2, 3));
            if (this.chCount > 2) {
                this.log.print("getTextBehindIndex(chCount-2, AccessibleTextType.CHARACTER):");
                textSegment = this.oObj.getTextBehindIndex(this.chCount - 2, (short)1);
                this.log.println("'" + textSegment.SegmentText + "'");
                bl &= textSegment.SegmentText.equals(this.text.substring(this.chCount - 1, this.chCount));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Unexpected exception");
            illegalArgumentException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getTextBehindIndex()", bl);
    }

    public void _copyText() {
        boolean bl;
        block11: {
            bl = true;
            boolean bl2 = true;
            if (this.editOnly != null) {
                this.log.println(this.editOnly);
                throw new StatusException(Status.skipped(true));
            }
            try {
                this.log.print("copyText(-1,chCount):");
                this.oObj.copyText(-1, this.chCount);
                this.log.println("Exception was expected");
                bl &= false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Expected exception");
                bl &= true;
            }
            try {
                this.log.print("copyText(0,chCount+1):");
                this.oObj.copyText(0, this.chCount + 1);
                this.log.println("Exception was expected");
                bl &= false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Expected exception");
                bl &= true;
            }
            try {
                this.log.print("copyText(0,chCount):");
                bl2 = this.oObj.copyText(0, this.chCount);
                this.log.println(bl2);
                bl &= bl2;
                String string = null;
                try {
                    string = SysUtils.getSysClipboardText((XMultiServiceFactory)this.tParam.getMSF());
                }
                catch (Exception exception) {
                    this.log.println("Couldn't access system clipboard :");
                    exception.printStackTrace(this.log);
                }
                this.log.println("Clipboard: '" + string + "'");
                bl &= this.text.equals(string);
                if (this.chCount <= 2) break block11;
                this.log.print("copyText(1,chCount-1):");
                bl2 = this.oObj.copyText(1, this.chCount - 1);
                this.log.println(bl2);
                bl &= bl2;
                try {
                    string = SysUtils.getSysClipboardText((XMultiServiceFactory)this.tParam.getMSF());
                }
                catch (Exception exception) {
                    this.log.println("Couldn't access system clipboard :");
                    exception.printStackTrace(this.log);
                }
                this.log.println("Clipboard: '" + string + "'");
                bl &= this.text.substring(1, this.chCount - 1).equals(string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl &= false;
            }
        }
        this.tRes.tested("copyText()", bl);
    }

    public boolean compareStrings(String string, String string2) {
        boolean bl = string.equals(string2);
        if (!bl) {
            this.log.println("## The result isn't the expected:");
            this.log.println("\tGetting: " + string2);
            this.log.println("\tExpected: " + string);
        }
        return bl;
    }

    public boolean compareLength(int n, String string) {
        boolean bl;
        boolean bl2 = bl = n == string.length();
        if (!bl) {
            this.log.println("## The result isn't the expected:");
            this.log.println("\tGetting: " + string.length());
            this.log.println("\tExpected: " + n);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

