/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class ContextTreeView
extends TreeView {
    static final long serialVersionUID = -8282594827988436813L;

    public ContextTreeView() {
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return true;
        }
        Node node = nodeArray[0].getParentNode();
        int n = 1;
        while (n < nodeArray.length) {
            if (nodeArray[n].getParentNode() != node) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        if (nodeArray.length > 0) {
            explorerManager.setExploredContext(nodeArray[0]);
        }
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected void showPath(TreePath treePath) {
        this.tree.makeVisible(treePath);
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
            this.tree.scrollRectToVisible(rectangle);
        }
        this.tree.setSelectionPath(treePath);
    }

    protected void showSelection(TreePath[] treePathArray) {
        if (treePathArray.length == 0) {
            this.tree.setSelectionPaths(new TreePath[0]);
        } else {
            this.tree.setSelectionPath(treePathArray[0].getParentPath());
        }
    }

    protected boolean useExploredContextMenu() {
        return true;
    }

    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }
}

