/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.Lookup;

public final class NbClassPath
implements Serializable {
    static final long serialVersionUID = -8458093409814321744L;
    private Object[] items;
    private String classpath;
    static /* synthetic */ Class class$org$openide$execution$ExecutionEngine;

    public NbClassPath(String[] stringArray) {
        this.items = stringArray;
    }

    public NbClassPath(File[] fileArray) {
        this.items = fileArray;
    }

    private NbClassPath(Object[] objectArray) {
        this.items = objectArray;
    }

    public NbClassPath(String string) {
        this.items = new Exception[0];
        this.classpath = string;
        if (string.indexOf(32) >= 0) {
            if (string.startsWith("\"")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            this.classpath = stringBuffer.toString();
        }
    }

    public static NbClassPath createRepositoryPath() {
        return NbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static NbClassPath createRepositoryPath(FileSystemCapability fileSystemCapability) {
        LinkedList<EnvironmentNotSupportedException> linkedList = new LinkedList<EnvironmentNotSupportedException>();
        final class Env
        extends FileSystem.Environment {
            private final /* synthetic */ LinkedList val$res;

            Env(LinkedList linkedList) {
                this.val$res = linkedList;
            }

            public void addClassPath(String string) {
                this.val$res.add(string);
            }
        }
        Env env = new Env(linkedList);
        Enumeration enumeration = fileSystemCapability.fileSystems();
        while (enumeration.hasMoreElements()) {
            try {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                fileSystem.prepareEnvironment(env);
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                linkedList.add(environmentNotSupportedException);
            }
        }
        return new NbClassPath(linkedList.toArray());
    }

    public static NbClassPath createLibraryPath() {
        ExecutionEngine executionEngine = (ExecutionEngine)Lookup.getDefault().lookup(class$org$openide$execution$ExecutionEngine == null ? (class$org$openide$execution$ExecutionEngine = NbClassPath.class$("org.openide.execution.ExecutionEngine")) : class$org$openide$execution$ExecutionEngine);
        if (executionEngine != null) {
            return executionEngine.createLibraryPath();
        }
        return new NbClassPath(new File[0]);
    }

    public static NbClassPath createClassPath() {
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return new NbClassPath("");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith("openide-compat.jar")) continue;
            if (bl) {
                stringBuffer.append(File.pathSeparatorChar);
            } else {
                bl = true;
            }
            stringBuffer.append(string2);
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static NbClassPath createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        String string2 = System.getProperty("java.ext.dirs");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                int n = 0;
                while (n < fileArray.length) {
                    String string3 = fileArray[n].getName().toLowerCase(Locale.US);
                    if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(File.pathSeparatorChar);
                        }
                        stringBuffer.append(fileArray[n].getPath());
                    }
                    ++n;
                }
            }
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static File toFile(FileObject fileObject) {
        String string = fileObject.getPackageNameExt(File.separatorChar, '.');
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String string) {
                this.val$pne = string;
            }

            public void addClassPath(String string) {
                if (this.found != null) {
                    return;
                }
                File file = new File(string);
                if (!file.isDirectory()) {
                    return;
                }
                File file2 = new File(file, this.val$pne);
                if (file2.exists()) {
                    this.found = file2;
                }
            }
        }
        Env env = new Env(string);
        try {
            fileObject.getFileSystem().prepareEnvironment(env);
            return env.found;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            NbClassPath nbClassPath = this;
            synchronized (nbClassPath) {
                this.getClassPath();
                int n = 0;
                int n2 = 0;
                while (n2 < this.items.length) {
                    if (this.items[n2] != null) {
                        this.items[n++] = this.items[n2];
                    }
                    ++n2;
                }
                Exception[] exceptionArray = new Exception[n];
                System.arraycopy(this.items, 0, exceptionArray, 0, n);
                this.items = exceptionArray;
                return exceptionArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        NbClassPath nbClassPath = this;
        synchronized (nbClassPath) {
            Object object;
            block13: {
                block12: {
                    if (this.classpath == null) break block12;
                    String string = this.classpath;
                    return string;
                }
                if (this.items.length != 0) break block13;
                this.classpath = "";
                String string = "";
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = 0;
            while (n < this.items.length) {
                object = this.items[n];
                if (object != null && (object instanceof String || object instanceof File)) {
                    if (bl) {
                        stringBuffer.append(File.pathSeparatorChar);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(object.toString());
                    this.items[n] = null;
                }
                ++n;
            }
            object = stringBuffer.toString();
            if (((String)object).indexOf(32) >= 0) {
                stringBuffer.insert(0, '\"');
                stringBuffer.append('\"');
                this.classpath = stringBuffer.toString();
            } else {
                this.classpath = object;
            }
            String string = this.classpath;
            return string;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NbClassPath)) {
            return false;
        }
        NbClassPath nbClassPath = (NbClassPath)object;
        return this.getClassPath().equals(nbClassPath.getClassPath());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

