/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerExecutor;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.IdSet;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExternalCompilerGroup
extends CompilerGroup {
    private static final String META_CHARACTERS = "\\[](){}^$.|?*+";
    private static final char ESCAPE_CHAR = '\\';
    private Set compilers = new IdSet();
    private boolean dirty;
    private RE clsPath;
    static /* synthetic */ Class class$org$openide$compiler$ExternalCompilerType;

    public void add(Compiler compiler) throws IllegalArgumentException {
        if (!(compiler instanceof ExternalCompiler)) {
            throw new IllegalArgumentException();
        }
        this.compilers.add(compiler);
    }

    protected Process createProcess(NbProcessDescriptor nbProcessDescriptor, String[] stringArray, Object object) throws IOException {
        return this.createProcess(nbProcessDescriptor, stringArray);
    }

    protected Process createProcess(NbProcessDescriptor nbProcessDescriptor, String[] stringArray) throws IOException {
        return nbProcessDescriptor.exec(new Format(stringArray));
    }

    protected Process createProcess(NbProcessDescriptor nbProcessDescriptor, String[] stringArray, File file) throws IOException {
        return nbProcessDescriptor.exec(new Format(stringArray), null, file);
    }

    protected String getStatusLineText() {
        FileObject fileObject;
        if (this.compilers.size() == 1 && (fileObject = this.getAllCompilers()[0].getFileObject()) != null) {
            String string = MessageFormat.format(ExternalCompilerGroup.getString("CTL_FMT_CompilingMessage"), fileObject.getPackageName('.'));
            return string;
        }
        return ExternalCompilerGroup.getString("FMT_GenericCompilingMessage");
    }

    protected final ExternalCompiler[] getAllCompilers() {
        return this.compilers.toArray(new ExternalCompiler[this.compilers.size()]);
    }

    void fireErrEvent(ErrorEvent errorEvent, boolean bl) {
        if (errorEvent.getFile() != null && !bl) {
            this.dirty = true;
        }
        this.fireErrorEvent(errorEvent);
    }

    protected Collection filterCompilers(Collection collection) {
        HashMap<ExternalCompiler, ExternalCompiler> hashMap = new HashMap<ExternalCompiler, ExternalCompiler>(collection.size() * 4 / 3);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ExternalCompiler externalCompiler = (ExternalCompiler)iterator.next();
            ExternalCompiler externalCompiler2 = hashMap.put(externalCompiler, externalCompiler);
            if (externalCompiler2 == null || externalCompiler == externalCompiler2 || externalCompiler2.isUpToDate() || !externalCompiler.isUpToDate()) continue;
            hashMap.put(externalCompiler, externalCompiler2);
        }
        return hashMap.values();
    }

    public boolean start() {
        Object object;
        Object object2;
        this.dirty = false;
        if (this.compilers.isEmpty()) {
            return true;
        }
        CompilerExecutor compilerExecutor = null;
        HashSet<Object> hashSet = new HashSet<Object>(7);
        Iterator iterator = this.filterCompilers(this.compilers).iterator();
        while (iterator.hasNext()) {
            ExternalCompiler externalCompiler = (ExternalCompiler)iterator.next();
            if (compilerExecutor == null) {
                compilerExecutor = new CompilerExecutor(this, externalCompiler.getCompilerDescriptor(), externalCompiler.getErrorExpression(), externalCompiler.compilerType());
            }
            if ((object2 = externalCompiler.getFileName()) != null && !"".equals(object2)) {
                compilerExecutor.addFile((String)object2);
            }
            if ((object = externalCompiler.getFileObject()) == null) continue;
            if (((FileObject)object).isData()) {
                object = ((FileObject)object).getParent();
            }
            hashSet.add(object);
        }
        try {
            int n = compilerExecutor.execute(new ExecInfo("ExternalCompilerGroup")).result();
            this.dirty |= n != 0;
            if (!this.dirty) {
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.refreshPackage((FileObject)iterator.next());
                }
            }
            if (n == 97943) {
                object2 = new ErrorEvent(this, null, -1, -1, ExternalCompilerGroup.getString("CTL_Interrupted"), "");
                this.fireErrorEvent((ErrorEvent)object2);
            }
        }
        catch (IOException iOException) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            iOException.printStackTrace((PrintWriter)object);
            this.fireErrorEvent(new ErrorEvent(this, null, 0, 0, ((StringWriter)object2).toString(), ""));
            this.dirty = true;
        }
        return !this.dirty;
    }

    private void refreshPackage(FileObject fileObject) {
        fileObject.refresh();
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject2 = fileObjectArray[n];
            if ("class".equals(fileObject2.getExt())) {
                fileObject2.refresh();
            }
            ++n;
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(class$org$openide$compiler$ExternalCompilerType == null ? (class$org$openide$compiler$ExternalCompilerType = ExternalCompilerGroup.class$("org.openide.compiler.ExternalCompilerType")) : class$org$openide$compiler$ExternalCompilerType, string);
    }

    protected void parseErrors(ExternalCompiler.ErrorExpression errorExpression, Reader reader) {
        RE rE = ExternalCompilerGroup.getErrorPattern(errorExpression);
        ReaderCharacterIterator readerCharacterIterator = new ReaderCharacterIterator(reader);
        int n = 0;
        while (rE.match((CharacterIterator)readerCharacterIterator, n)) {
            String string;
            int n2;
            int n3;
            if (errorExpression.getFilePos() < 0) {
                return;
            }
            int n4 = 0;
            int n5 = rE.getParenCount() - 1;
            String string2 = rE.getParen(errorExpression.getFilePos());
            if (errorExpression.getLinePos() < n4 || errorExpression.getLinePos() > n5) {
                n3 = 1;
            } else {
                try {
                    n3 = Integer.parseInt(rE.getParen(errorExpression.getLinePos()));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 1;
                }
            }
            if (errorExpression.getColumnPos() < n4 || errorExpression.getColumnPos() > n5) {
                n2 = 1;
            } else {
                try {
                    n2 = Integer.parseInt(rE.getParen(errorExpression.getColumnPos()));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 1;
                }
            }
            String string3 = errorExpression.getDescriptionPos() < n4 || errorExpression.getDescriptionPos() > n5 ? "" : ((string = rE.getParen(errorExpression.getDescriptionPos())) == null ? "" : string.trim());
            String string4 = "";
            string = readerCharacterIterator.substring(n, rE.getParenStart(0));
            if (!string.equals("")) {
                this.notifyError(null, -1, -1, ExternalCompilerGroup.trimString(string), null);
            }
            this.notifyError(string2 != null ? string2.trim() : null, n3, n2, string3, string4);
            n = rE.getParenEnd(0);
        }
        String string = readerCharacterIterator.substring(n);
        if (!string.equals("")) {
            this.notifyError(null, 0, 0, ExternalCompilerGroup.trimString(string), null);
        }
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    protected void notifyError(String string, int n, int n2, String string2, String string3) {
        Object[] objectArray;
        String string4 = ExternalCompilerGroup.getString("FMT_Warning");
        boolean bl = string2.toLowerCase().indexOf(string4) >= 0;
        FileObject fileObject = null;
        if (string != null) {
            fileObject = this.string2File(string);
            if (fileObject == null) {
                objectArray = new Object[]{string.replace(File.separatorChar, '/'), new Integer(n), new Integer(n2), string2};
                string2 = ExternalCompilerGroup.getUnknownFile().format(objectArray);
            }
        } else if (string2.equals("")) {
            return;
        }
        objectArray = new ErrorEvent(this, fileObject, n, n2, string2, string3);
        this.fireErrEvent((ErrorEvent)objectArray, bl);
    }

    private RE getClassPathEntries() {
        if (this.clsPath == null) {
            String string = NbClassPath.createRepositoryPath(FileSystemCapability.COMPILE).getClassPath();
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            try {
                RECompiler rECompiler = new RECompiler();
                REProgram rEProgram = rECompiler.compile(ExternalCompilerGroup.sortAndMakeOr(ExternalCompilerGroup.escapeMetaCharacters(string)));
                this.clsPath = new RE(rEProgram);
            }
            catch (RESyntaxException rESyntaxException) {
                ErrorManager.getDefault().notify(rESyntaxException);
            }
        }
        return this.clsPath;
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression errorExpression) {
        String string = errorExpression.getErrorExpression();
        try {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile(string);
            RE rE = new RE(rEProgram, 2);
            return rE;
        }
        catch (RESyntaxException rESyntaxException) {
            ErrorManager.getDefault().notify(rESyntaxException);
            return null;
        }
    }

    static String sortAndMakeOr(String string) {
        int n = string.length() - 1;
        while (string.charAt(n--) == File.pathSeparatorChar) {
        }
        string = string.substring(0, n + 2);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
            Arrays.sort(stringArray, new StringComparator());
            StringBuffer stringBuffer = new StringBuffer(300);
            int n2 = stringArray.length - 1;
            while (n2 > 0) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append('|');
                --n2;
            }
            stringBuffer.append(stringArray[0]);
            return stringBuffer.toString();
        }
        return string;
    }

    private static boolean isMetaCharacter(char c) {
        return META_CHARACTERS.indexOf(c) >= 0;
    }

    private static String escapeMetaCharacters(String string) {
        if (META_CHARACTERS.indexOf(File.pathSeparatorChar) != -1) {
            throw new IllegalStateException("org.openide.compiler.ErrorsParsingThread must be patched for this operating system");
        }
        StringBuffer stringBuffer = new StringBuffer(Math.max(1, string.length() * 2));
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (ExternalCompilerGroup.isMetaCharacter(c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private FileObject string2File(String string) {
        String string2 = string = string.replace('/', File.separatorChar);
        if (this.getClassPathEntries().match(string)) {
            String string3 = string.substring(this.getClassPathEntries().getParen(0).length());
            string3 = string3.replace('\\', '/');
            Enumeration enumeration = FileSystemCapability.COMPILE.findAllResources(string3);
            FileObject fileObject = null;
            String string4 = string.substring(0, this.getClassPathEntries().getParen(0).length());
            try {
                OneItemEnv oneItemEnv = new OneItemEnv();
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    fileObject2.getFileSystem().prepareEnvironment(oneItemEnv);
                    String string5 = oneItemEnv.getClassPathEntry();
                    if (string5.equals(string4)) {
                        return fileObject2;
                    }
                    if (fileObject != null) continue;
                    fileObject = fileObject2;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, fileStateInvalidException);
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                ErrorManager.getDefault().notify(4096, environmentNotSupportedException);
            }
            return fileObject;
        }
        return null;
    }

    private static MessageFormat getUnknownFile() {
        return new MessageFormat(ExternalCompiler.getLocalizedString("MSG_Unknown_file"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_FILES = "files";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = -8630048144603405233L;
        static final int DEFAULT_FILELIST_THRESHOLD = 2048;
        static final String SYSPROP_FILELIST_THRESHOLD = "org.openide.compilers.filelistThreshold";
        private static final String PREFIX = "compilerparams";
        private static final String SUFFIX = ".pms";

        public Format(String[] stringArray) {
            this(stringArray, NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath(FileSystemCapability.COMPILE), NbClassPath.createLibraryPath());
        }

        public Format(String[] stringArray, NbClassPath nbClassPath, NbClassPath nbClassPath2, NbClassPath nbClassPath3, NbClassPath nbClassPath4) {
            super(Format.createMap7());
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, nbClassPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, nbClassPath2.getClassPath());
            map.put(TAG_REPOSITORY, nbClassPath3.getClassPath());
            map.put(TAG_LIBRARY, nbClassPath4.getClassPath());
            map.put(TAG_FILES, Format.asParameterString(stringArray));
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
        }

        public static String asParameterString(String[] stringArray) {
            boolean bl = false;
            int n = Integer.getInteger(SYSPROP_FILELIST_THRESHOLD, 2048);
            String string = null;
            if (stringArray.length > 10 && Utilities.isWindows() || (bl = Utilities.getOperatingSystem() == 8192) || (string = Format.constructString(stringArray, n)) == null) {
                try {
                    boolean bl2;
                    File file = Format.constructFile(stringArray, !bl);
                    StringBuffer stringBuffer = new StringBuffer(50);
                    String string2 = file.toString();
                    boolean bl3 = bl2 = string2.indexOf(32) >= 0;
                    if (bl2) {
                        stringBuffer.append('\"');
                    }
                    stringBuffer.append('@');
                    stringBuffer.append(string2);
                    if (bl2) {
                        stringBuffer.append('\"');
                    }
                    return stringBuffer.toString();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, iOException);
                    return null;
                }
            }
            return string;
        }

        private static HashMap createMap7() {
            return new HashMap(7);
        }

        private static File constructFile(String[] stringArray, boolean bl) throws IOException {
            File file = File.createTempFile(PREFIX, SUFFIX);
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (bl && string.indexOf(32) > -1) {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('\"');
                    char[] cArray = string.toCharArray();
                    int n3 = 0;
                    while ((n2 = string.indexOf(92, n3)) > -1) {
                        stringBuffer.append(cArray, n3, n2 - n3 + 1);
                        stringBuffer.append('\\');
                        n3 = n2 + 1;
                    }
                    if (n3 < string.length()) {
                        stringBuffer.append(cArray, n3, string.length() - n3);
                    }
                    stringBuffer.append('\"');
                    string = stringBuffer.toString();
                }
                printWriter.println(string);
                ++n;
            }
            printWriter.close();
            return file;
        }

        private static String constructString(String[] stringArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(string);
                if (stringArray[n2].indexOf(32) >= 0) {
                    stringBuffer.append("\"");
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append(stringArray[n2]);
                }
                string = " ";
                if (stringBuffer.length() > n) {
                    return null;
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
    }

    static final class OneItemEnv
    extends FileSystem.Environment {
        String classPathEntry;

        OneItemEnv() {
        }

        public void addClassPath(String string) {
            this.classPathEntry = string;
        }

        public String getClassPathEntry() {
            return this.classPathEntry;
        }
    }

    static final class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().length() - object2.toString().length();
        }
    }
}

