/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComboBox;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.Main;

class UpdateContext
implements Runnable {
    Main db;
    ContextData contextData;

    UpdateContext(Main main, Context context) {
        this.db = main;
        this.contextData = ContextData.get(context);
    }

    public void run() {
        this.db.context.enable();
        JComboBox jComboBox = this.db.context.context;
        Vector vector = this.db.context.toolTips;
        this.db.context.disableUpdate();
        int n = this.contextData.getFrameCount();
        jComboBox.removeAllItems();
        jComboBox.setSelectedItem(null);
        vector.removeAllElements();
        for (int i = 0; i < n; ++i) {
            FrameHelper frameHelper = this.contextData.getFrame(i);
            String string = frameHelper.getUrl();
            int n2 = frameHelper.getLineNumber();
            String string2 = string;
            if (string.length() > 20) {
                string2 = "..." + string.substring(string.length() - 17);
            }
            String string3 = "\"" + string2 + "\", line " + n2;
            jComboBox.insertItemAt(string3, i);
            string3 = "\"" + string + "\", line " + n2;
            vector.addElement(string3);
        }
        this.db.context.enableUpdate();
        if (n != 0) {
            jComboBox.setSelectedIndex(0);
        }
        jComboBox.setMinimumSize(new Dimension(50, jComboBox.getMinimumSize().height));
    }
}

