/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Token;
import org.hsqldb.lib.StringConverter;

public class HsqlNameManager {
    private static HsqlNameManager staticManager = new HsqlNameManager();
    private int serialNumber = 1;
    private int sysNumber = 0;

    static HsqlName newHsqlSystemObjectName(String string) {
        return new HsqlName(staticManager, string);
    }

    HsqlName newHsqlName(String string, boolean bl) {
        return new HsqlName(this, string, bl);
    }

    HsqlName newHsqlName(String string, String string2, boolean bl) {
        return new HsqlName(this, string, string2, bl);
    }

    HsqlName newHsqlName(String string) {
        return new HsqlName(this, string);
    }

    HsqlName newAutoName(String string) {
        return this.newAutoName(string, null);
    }

    HsqlName newAutoName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            if (string.length() != 0) {
                stringBuffer.append("SYS_");
                stringBuffer.append(string);
                stringBuffer.append('_');
                if (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('_');
                }
                stringBuffer.append(++this.sysNumber);
            }
        } else {
            stringBuffer.append(string2);
        }
        return new HsqlName(this, stringBuffer.toString());
    }

    void resetNumbering() {
        this.sysNumber = 0;
        this.serialNumber = 0;
    }

    static {
        HsqlNameManager.staticManager.serialNumber = Integer.MIN_VALUE;
    }

    public static class HsqlName {
        HsqlNameManager manager;
        public String name;
        boolean isNameQuoted;
        public String statementName;
        public HsqlName schema;
        private final int hashCode;

        private HsqlName(HsqlNameManager hsqlNameManager) {
            this.manager = hsqlNameManager;
            this.hashCode = this.manager.serialNumber++;
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, boolean bl) {
            this(hsqlNameManager);
            this.rename(string, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, String string2, boolean bl) {
            this(hsqlNameManager);
            this.rename(string, string2, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string) {
            this(hsqlNameManager);
            this.name = this.statementName = string;
        }

        void rename(String string, boolean bl) {
            this.name = string;
            this.statementName = string;
            this.isNameQuoted = bl;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string, '\"', true);
            }
            if (string.startsWith("SYS_")) {
                int n = string.lastIndexOf(95) + 1;
                try {
                    int n2 = Integer.parseInt(string.substring(n));
                    if (n2 > this.manager.sysNumber) {
                        this.manager.sysNumber = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String string, String string2, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('_');
            stringBuffer.append(string2);
            this.rename(stringBuffer.toString(), bl);
        }

        public boolean equals(Object object) {
            if (object instanceof HsqlName) {
                return this.hashCode == ((HsqlName)object).hashCode;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static boolean isReservedIndexName(String string) {
            return string.startsWith("SYS_IDX_") || string.startsWith("SYS_PK_") || string.startsWith("SYS_REF_");
        }

        boolean isReservedIndexName() {
            return HsqlName.isReservedIndexName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object object) {
            return this.hashCode - object.hashCode();
        }

        static boolean isRegularIdentifier(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Token.isKeyword(string);
        }
    }
}

