/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SQLExecution {
    protected Connection mConnection = null;
    protected Statement mStatement = null;
    protected String mJdbcClass = null;
    protected String mDbURL = null;
    protected String mUser = null;
    protected String mPassword = null;
    protected boolean m_bConnectionOpen = false;
    protected boolean m_bDebug = false;

    public SQLExecution(String string, String string2, String string3, String string4) {
        this.mJdbcClass = string;
        this.mUser = string3;
        this.mPassword = string4;
        this.mDbURL = string2;
    }

    public SQLExecution(String string, String string2, String string3, String string4, boolean bl) {
        this.mJdbcClass = string;
        this.mUser = string3;
        this.mPassword = string4;
        this.mDbURL = string2;
        this.m_bDebug = bl;
    }

    public boolean openConnection() {
        if (this.m_bConnectionOpen) {
            return true;
        }
        try {
            Class.forName(this.mJdbcClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Couldn't find jdbc driver : " + classNotFoundException.getMessage());
            return false;
        }
        try {
            this.mConnection = DriverManager.getConnection(this.mDbURL, this.mUser, this.mPassword);
            this.mStatement = this.mConnection.createStatement();
        }
        catch (SQLException sQLException) {
            System.err.println("Couldn't establish a connection: " + sQLException.getMessage());
            return false;
        }
        this.m_bConnectionOpen = true;
        return true;
    }

    public boolean closeConnection() {
        if (!this.m_bConnectionOpen) {
            return true;
        }
        try {
            this.mStatement.close();
            this.mConnection.close();
        }
        catch (SQLException sQLException) {
            System.err.println("Couldn't close the connection: " + sQLException.getMessage());
            return false;
        }
        this.m_bConnectionOpen = false;
        return true;
    }

    public boolean executeSQLCommand(String string, Hashtable hashtable, Hashtable hashtable2) throws IllegalArgumentException {
        return this.executeSQLCommand(string, hashtable, hashtable2, false);
    }

    public boolean executeSQLCommand(String string, Hashtable hashtable, Hashtable hashtable2, boolean bl) throws IllegalArgumentException {
        Object object;
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            bl = true;
            if (hashtable == null) {
                System.out.println("sqlInput and sqlOutput are null: cannot return the results of the sql command.");
                return false;
            }
        }
        Vector<String> vector = new Vector<String>();
        vector.add("");
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(36);
            if (n != -1) {
                String string3 = "";
                string3 = string2.substring(0, n);
                object = string2.substring(n + 1);
                String string4 = "";
                while (object.endsWith(",") || object.endsWith("'") || object.endsWith(";") || object.endsWith(")") || object.endsWith("\"")) {
                    string4 = object.substring(object.length() - 1) + string4;
                    object = object.substring(0, object.length() - 1);
                }
                if (hashtable.containsKey(object)) {
                    int n2;
                    Object object2;
                    Object v = hashtable.get(object);
                    if (v instanceof String[]) {
                        object2 = (String[])v;
                        if (((String[])object2).length != vector.size() && vector.size() > 1) {
                            throw new IllegalArgumentException("The key '" + (String)object + "' in command \n'" + string + "'\n has not the same value count as the keys before.");
                        }
                        n2 = vector.size() == 1 ? 1 : 0;
                        for (int i = 0; i < ((String[])object2).length; ++i) {
                            String string5 = this.checkForQuotationMarks(object2[i]);
                            if (n2 != 0 && i != 0) {
                                vector.add(i, (String)vector.get(0) + " " + string3 + string5 + string4);
                                continue;
                            }
                            vector.set(i, (String)vector.get(i) + " " + string3 + string5 + string4);
                        }
                        continue;
                    }
                    object2 = this.checkForQuotationMarks((String)hashtable.get(object));
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        vector.set(n2, (String)vector.get(n2) + " " + string3 + (String)object2 + string4);
                    }
                    continue;
                }
                throw new IllegalArgumentException("The key '" + (String)object + "' in command \n'" + string + "'\n does not exist in the input values.");
            }
            for (int i = 0; i < vector.size(); ++i) {
                vector.set(i, (String)vector.get(i) + " " + string2);
            }
            if (!string2.equalsIgnoreCase("update") && !string2.equalsIgnoreCase("delete") && !string2.equalsIgnoreCase("insert")) continue;
            bl2 = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.execute((String)vector.get(i), hashtable2, bl2);
            if (bl2 || !bl) continue;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                object = (String[])hashtable2.get(string6);
                if (object == null || ((String[])object).length == 0) continue;
                if (((String[])object).length == 1) {
                    hashtable.put(string6, object[0]);
                    continue;
                }
                hashtable.put(string6, object);
            }
        }
        return bl2 || hashtable2 != null;
    }

    private void execute(String string, Hashtable hashtable, boolean bl) {
        if (this.m_bDebug) {
            System.out.println("Debug - SQLExecution - execute Command: " + string);
        }
        try {
            if (bl) {
                this.mStatement.executeUpdate(string);
            } else {
                ResultSet resultSet = this.mStatement.executeQuery(string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                String[] stringArray = new String[n];
                int n2 = 0;
                boolean bl2 = true;
                for (int i = 1; i <= n; ++i) {
                    String[] stringArray2;
                    stringArray[i - 1] = resultSetMetaData.getColumnName(i);
                    Vector<String[]> vector = new Vector<String[]>();
                    resultSet.beforeFirst();
                    while (resultSet.next()) {
                        stringArray2 = resultSet.getString(i);
                        vector.add(stringArray2);
                        if (!bl2) continue;
                        ++n2;
                    }
                    if (bl2) {
                        bl2 = false;
                    }
                    stringArray2 = new String[n2];
                    stringArray2 = vector.toArray(stringArray2);
                    hashtable.put(stringArray[i - 1], stringArray2);
                    if (!this.m_bDebug) continue;
                    if (i == 1) {
                        System.out.print("Debug - SQLExecution - Command returns: ");
                        System.out.print("row: " + stringArray[i - 1] + "   vals: ");
                    }
                    for (int j = 0; j < stringArray2.length; ++j) {
                        System.out.print(stringArray2[j] + " ");
                    }
                    if (i != n - 1) continue;
                    System.out.println();
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private String checkForQuotationMarks(String string) {
        String string2 = string;
        int n = 0;
        while ((n = string2.indexOf(34)) != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            string2 = string3 + "''" + string4;
        }
        return string2;
    }
}

