/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.util.Hashtable;
import share.LogWriter;
import stats.SimpleOutProducer;
import util.DynamicClassLoader;

public class OutProducerFactory {
    public static LogWriter createOutProducer(Hashtable hashtable) {
        LogWriter logWriter = null;
        boolean bl = OutProducerFactory.convertToBool(hashtable.get("DataBaseOut"));
        if (bl) {
            logWriter = OutProducerFactory.createDataBaseOutProducer(hashtable);
        }
        if (logWriter == null) {
            DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
            String string = (String)hashtable.get("OutProducer");
            if (string != null) {
                try {
                    logWriter = (LogWriter)dynamicClassLoader.getInstance(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
        if (logWriter == null) {
            logWriter = OutProducerFactory.createSimpleOutProducer();
        }
        return logWriter;
    }

    public static LogWriter createDataBaseOutProducer(Hashtable hashtable) {
        Object object;
        String string = (String)hashtable.get("DataBaseOutProducer");
        if (string == null) {
            object = (String)hashtable.get("TestBase");
            string = ((String)object).substring(((String)object).indexOf("_") + 1);
            string = "stats." + OutProducerFactory.makeFirstCharUpperCase(string) + "DataBaseOutProducer";
        }
        object = new DynamicClassLoader();
        LogWriter logWriter = null;
        try {
            logWriter = (LogWriter)((DynamicClassLoader)object).getInstance(string, new Class[]{new Hashtable().getClass()}, new Object[]{hashtable});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return logWriter;
    }

    public static LogWriter createSimpleOutProducer() {
        return new SimpleOutProducer();
    }

    private static boolean convertToBool(Object object) {
        if (object != null) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                    return true;
                }
            } else if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return false;
    }

    private static String makeFirstCharUpperCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

