/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.Filenamer;
import convwatch.StringHelper;
import helper.URLHelper;
import util.utils;

abstract class FilenameHelper_impl
implements Filenamer {
    String fs;
    String m_sPath;
    String m_sFilename;
    String m_sSuffix;
    int m_nNumber = 0;

    public String getNumber() {
        return StringHelper.createValueString(this.m_nNumber, 4);
    }

    public void setNumber(int n) {
        this.m_nNumber = n;
    }

    void initMember() {
        this.fs = System.getProperty("file.separator");
    }

    public FilenameHelper_impl() {
        this.initMember();
    }

    public void setCompleteFilename(String string) {
        if (string.startsWith("file:///")) {
            string = FileHelper.getSystemPathFromFileURL(string);
        }
        string = utils.replaceAll13(string, "\\\\", "/");
        String string2 = this.checkPath(FileHelper.getPath(string));
        String string3 = this.checkFilename(FileHelper.getBasename(string));
        String string4 = this.splitSuffix(string3);
        this.m_sPath = string2;
        this.m_sFilename = FileHelper.getNameNoSuffix(string3);
        this.m_sSuffix = string4;
    }

    public FilenameHelper_impl(String string, String string2, String string3) {
        this.initMember();
        string = utils.replaceAll13(string, "\\\\", "/");
        String string4 = this.checkPath(string);
        String string5 = this.checkFilename(string2);
        String string6 = this.checkSuffix(string3);
        this.m_sPath = string4;
        this.m_sFilename = string5;
        this.m_sSuffix = string6;
    }

    public String getFileURL() {
        String string = this.createAbsoluteFilename();
        String string2 = URLHelper.getFileURLFromSystemPath(string);
        return string2;
    }

    public String getAbsoluteSystemFilename() {
        String string = this.createAbsoluteFilename();
        string = utils.replaceAll13(string, "/", this.fs);
        return string;
    }

    public String getName() {
        return this.m_sFilename;
    }

    public void setName(String string) {
        this.m_sFilename = string;
    }

    public void setPath(String string) {
        this.m_sPath = string;
    }

    public abstract String buildName();

    public String getFilename() {
        return this.buildName() + "." + this.getSuffix();
    }

    public String getSystemPath() {
        String string = this.m_sPath;
        string = utils.replaceAll13(string, "/", this.fs);
        return string;
    }

    public boolean isDirectory() {
        return FileHelper.isDir(this.getSystemPath());
    }

    public boolean exists() {
        return FileHelper.exists(this.createAbsoluteFilename());
    }

    public String getSuffix() {
        return this.m_sSuffix;
    }

    String createAbsoluteFilename() {
        return this.m_sPath + this.fs + this.getFilename();
    }

    String checkPath(String string) {
        String string2 = string.endsWith("/") || string.endsWith("\\") ? string.substring(0, string.length() - 1) : string;
        return string2;
    }

    String checkFilename(String string) {
        String string2 = string.startsWith("/") || string.startsWith("\\") ? string.substring(1) : string;
        return string2;
    }

    String checkSuffix(String string) {
        String string2 = string.startsWith(".") ? string.substring(1) : string;
        return string2;
    }

    String splitSuffix(String string) {
        String string2 = FileHelper.getSuffix(string);
        return this.checkSuffix(string2);
    }

    public boolean equals(FilenameHelper_impl filenameHelper_impl) {
        String string;
        String string2 = this.createAbsoluteFilename();
        return string2.equals(string = filenameHelper_impl.createAbsoluteFilename());
    }
}

