/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Set;

public class StoredKeySet
extends StoredCollection
implements Set {
    public StoredKeySet(DataStore store, DataBinding keyBinding, boolean writeAllowed) {
        super(new DataView(store, null, keyBinding, null, null, writeAllowed));
    }

    public StoredKeySet(DataIndex index, DataBinding keyBinding, boolean writeAllowed) {
        super(new DataView(null, index, keyBinding, null, null, writeAllowed));
    }

    StoredKeySet(DataView keySetView) {
        super(keySetView);
    }

    public boolean add(Object key) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            int err = this.view.put(key, null, Db.DB_NOOVERWRITE, null);
            this.commitAutoCommit(doAutoCommit);
            return err == 0;
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean remove(Object key) {
        return this.removeKey(key, null);
    }

    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    boolean hasValues() {
        return false;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DbException, IOException {
        return cursor.getCurrentKey();
    }

    boolean iterateDuplicates() {
        return false;
    }
}

