/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.rendering.XAnimation;
import java.util.GregorianCalendar;

public class SpriteRunner
extends Thread {
    private CanvasSprite sprite;
    private XAnimation spriteAnimation;
    private JavaCanvas canvas;
    private double startTime;
    private double currentSpeed;
    private double currentT;
    private boolean animationActive;
    private boolean stayAlive;

    public SpriteRunner(CanvasSprite canvasSprite, XAnimation xAnimation, JavaCanvas javaCanvas) {
        CanvasUtils.printLog("SpriteRunner constructor called!");
        this.sprite = canvasSprite;
        this.spriteAnimation = xAnimation;
        this.canvas = javaCanvas;
        this.startTime = 0.0;
        this.currentSpeed = 0.0;
        this.currentT = 0.0;
        this.animationActive = false;
        this.stayAlive = true;
        this.setPriority(1);
    }

    public void run() {
        while (this.stayAlive) {
            while (this.animationActive) {
                double d = SpriteRunner.getCurrentTime() - this.startTime;
                this.currentT = d % this.currentSpeed / this.currentSpeed;
                this.canvas.renderAnimation(this.sprite, this.spriteAnimation, this.currentT);
                this.canvas.updateScreen(false);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
    }

    public synchronized void startAnimation(double d) {
        this.resetAnimation();
        this.currentSpeed = d;
        if (!this.isAlive()) {
            this.start();
        }
        this.animationActive = true;
        try {
            this.notify();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public synchronized void stopAnimation() {
        this.animationActive = false;
    }

    public synchronized void resetAnimation() {
        this.startTime = SpriteRunner.getCurrentTime();
    }

    public synchronized boolean isAnimationActive() {
        return this.animationActive;
    }

    public synchronized void quit() {
        this.stayAlive = false;
        this.stopAnimation();
    }

    public synchronized double getCurrentT() {
        return this.currentT;
    }

    static double getCurrentTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return (double)gregorianCalendar.getTimeInMillis() / 1000.0;
    }
}

