/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccessibleBrowseBox.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:55:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOX_HXX
#define _SVTOOLS_ACCESSIBLEBROWSEBOX_HXX

#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOXBASE_HXX
#include <svtools/AccessibleBrowseBoxBase.hxx>
#endif
#ifndef _CPPUHELPER_WEAKREF_HXX_
#include <cppuhelper/weakref.hxx>
#endif

#include <memory>

// ============================================================================

namespace svt {

	class AccessibleBrowseBoxImpl;
	class AccessibleBrowseBoxTable;

// ============================================================================

/** This class represents the complete accessible BrowseBox object. */
class AccessibleBrowseBox : public AccessibleBrowseBoxBase
{
    friend class AccessibleBrowseBoxAccess;

protected:
    AccessibleBrowseBox(
        const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxParent,
        const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxCreator,
        IAccessibleTableProvider& _rBrowseBox
    );

    virtual ~AccessibleBrowseBox();

    /** sets the XAccessible which created the context

        <p>To be called only once, and only if in the ctor NULL was passed.</p>
    */
    void    setCreator(
        const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxCreator
    );

    /** Cleans up members. */
    virtual void SAL_CALL disposing();

protected:
    // XAccessibleContext -----------------------------------------------------

    /** @return  The count of visible children. */
    virtual sal_Int32 SAL_CALL getAccessibleChildCount()
        throw ( ::com::sun::star::uno::RuntimeException );

    /** @return  The XAccessible interface of the specified child. */
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible > SAL_CALL
    getAccessibleChild( sal_Int32 nChildIndex )
        throw ( ::com::sun::star::lang::IndexOutOfBoundsException,
                ::com::sun::star::uno::RuntimeException );

    /** @return  The role of this object (a table). */
//    virtual sal_Int16 SAL_CALL getAccessibleRole()
//        throw ( ::com::sun::star::uno::RuntimeException );

    // XAccessibleComponent ---------------------------------------------------

    /** @return
			The accessible child rendered under the given point.
	*/
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible > SAL_CALL
    getAccessibleAtPoint( const ::com::sun::star::awt::Point& rPoint )
        throw ( ::com::sun::star::uno::RuntimeException );

    /** Grabs the focus to the BrowseBox. */
    virtual void SAL_CALL grabFocus()
        throw ( ::com::sun::star::uno::RuntimeException );

    /** @return  The key bindings associated with this object. */
    virtual ::com::sun::star::uno::Any SAL_CALL getAccessibleKeyBinding()
        throw ( ::com::sun::star::uno::RuntimeException );

    // XServiceInfo -----------------------------------------------------------

    /** @return
			The name of this class.
	*/
    virtual ::rtl::OUString SAL_CALL getImplementationName()
        throw ( ::com::sun::star::uno::RuntimeException );

public:
	// helper functions
	/** commitHeaderBarEvent commit the event at all listeners of the column/row header bar
		@param nEventId
			the event id
		@param rNewValue
			the new value
		@param rOldValue
			the old value
	*/
	void commitHeaderBarEvent(sal_Int16 nEventId,
            const ::com::sun::star::uno::Any& rNewValue,
            const ::com::sun::star::uno::Any& rOldValue,sal_Bool _bColumnHeaderBar = sal_True);

	// helper functions
	/** commitTableEvent commit the event at all listeners of the table
		@param nEventId
			the event id
		@param rNewValue
			the new value
		@param rOldValue
			the old value
	*/
	void commitTableEvent(sal_Int16 nEventId,
            const ::com::sun::star::uno::Any& rNewValue,
            const ::com::sun::star::uno::Any& rOldValue);

	/** returns the accessible object for the row or the column header bar
	*/
	inline ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible >
		getHeaderBar( AccessibleBrowseBoxObjType _eObjType )
		{
			return implGetHeaderBar(_eObjType);
		}

	/** returns the accessible object for the table representation
	*/
	inline ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible >
		getTable( )
		{
			return implGetTable();
		}

protected:
    // internal virtual methods -----------------------------------------------

    /** @attention  This method requires locked mutex's and a living object.
        @return  The bounding box (VCL rect.) relative to the parent window. */
    virtual Rectangle implGetBoundingBox();
    /** @attention  This method requires locked mutex's and a living object.
        @return  The bounding box (VCL rect.) in screen coordinates. */
    virtual Rectangle implGetBoundingBoxOnScreen();

    // internal helper methods ------------------------------------------------

    /** This method creates (once) and returns the accessible data table child.
        @attention  This method requires locked mutex's and a living object.
        @return  The XAccessible interface of the data table. */
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible > implGetTable();

    /** This method creates (once) and returns the specified header bar.
        @attention  This method requires locked mutex's and a living object.
        @return  The XAccessible interface of the header bar. */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible >
    implGetHeaderBar( AccessibleBrowseBoxObjType eObjType );

    /** This method returns one of the children that are always present:
        Data table, row and column header bar or corner control.
        @attention  This method requires locked mutex's and a living object.
        @return  The XAccessible interface of the specified child. */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible >
    implGetFixedChild( sal_Int32 nChildIndex );

    /** This method creates and returns an accessible table.
        @return  An AccessibleBrowseBoxTable. */
    virtual AccessibleBrowseBoxTable*	createAccessibleTable();

private:
    // members ----------------------------------------------------------------
	::std::auto_ptr< AccessibleBrowseBoxImpl > m_pImpl;
};

// ============================================================================
/** the XAccessible which creates/returns an AccessibleBrowseBox

    <p>The instance holds it's XAccessibleContext with a hard reference, while
    the contxt holds this instance weak.</p>
*/
typedef ::cppu::WeakImplHelper1	<	::com::sun::star::accessibility::XAccessible
							    >	AccessibleBrowseBoxAccess_Base;

class AccessibleBrowseBoxAccess : public AccessibleBrowseBoxAccess_Base
{
private:
    ::osl::Mutex                m_aMutex;
    ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >
                                m_xParent;
    IAccessibleTableProvider&   m_rBrowseBox;

    ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext >
                                m_xContext;
    AccessibleBrowseBox*        m_pContext;
                                    // note that this pointer is valid as long as m_xContext is valid!

public:
    AccessibleBrowseBoxAccess(
        const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& _rxParent,
        IAccessibleTableProvider& _rBrowseBox
    );

    void dispose();

    /// checks whether the accessible context is still alive
    bool                            isContextAlive() const;

    /// returns the AccessibleContext belonging to this Accessible
    inline AccessibleBrowseBox*            getContext()         { return m_pContext; }
    inline const AccessibleBrowseBox*      getContext() const   { return m_pContext; }

protected:
    virtual ~AccessibleBrowseBoxAccess();

    // XAccessible
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext >
        SAL_CALL getAccessibleContext() throw ( ::com::sun::star::uno::RuntimeException );

private:
	AccessibleBrowseBoxAccess();												// never implemented
	AccessibleBrowseBoxAccess( const AccessibleBrowseBoxAccess& );			    // never implemented
	AccessibleBrowseBoxAccess& operator=( const AccessibleBrowseBoxAccess& );	// never implemented
};

// ============================================================================
} // namespace svt

// ============================================================================

#endif

