/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: msgpool.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:06:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXMSGPOOL_HXX
#define _SFXMSGPOOL_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_SFX2_DLLAPI_H
#include "sfx2/dllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

#include <sfx2/msg.hxx>

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

class  SfxInterface;
class  SfxSlot;
class  SfxInterfaceArr_Impl;
class  SfxSlotGroupArr_Impl;
class  SfxSlotTypeArr_Impl;
class  IdPool;
class  SbxObject;
struct SfxSIDRegistration_Impl;
class  SvStream;
class SfxSlotArr_Impl;

//=========================================================================

class SFX2_DLLPUBLIC SfxSlotPool
{
	IdPool* 					_pIdPool;
	SfxSlotGroupArr_Impl*		_pGroups;
	SfxSlotTypeArr_Impl*		_pTypes;
	SfxSlotPool*				_pParentPool;
	ResMgr*						_pResMgr;
	SfxInterfaceArr_Impl*		_pInterfaces;
	USHORT						_nCurGroup;
	USHORT						_nCurInterface;
	USHORT						_nCurMsg;
	SfxSlotArr_Impl*			_pUnoSlots;

private:
	const SfxSlot* SeekSlot( USHORT nObject );

public:
						SfxSlotPool( SfxSlotPool* pParent=0, ResMgr* pMgr=0);
						~SfxSlotPool();

	void				RegisterInterface( SfxInterface& rFace );
	void				ReleaseInterface( SfxInterface& rFace );
	SfxInterface*       FirstInterface();
	SfxInterface*       NextInterface();

	IdPool& 			GetIdPool();
	void				StoreId( SvStream& rStream, USHORT nId );
	void				LoadId( SvStream& rStream, USHORT &rId );
	USHORT				RegisterSID( const String &rGroup, const String &rName );
	void  				ReleaseSID( const String &rGroup, const String &rName );

	USHORT				GetGroupCount();
	String				SeekGroup( USHORT nNo );
	const SfxSlot*		FirstSlot();
	const SfxSlot*		NextSlot();
	const SfxSlot*		GetSlot( USHORT nId );
	const SfxSlot*		GetUnoSlot( USHORT nId );
	const SfxSlot*		GetUnoSlot( const String& rUnoName );
    String				GetSlotName( USHORT nId,
									 String* pHelpText = NULL ) const;
	SAL_DLLPRIVATE String GetSlotName_Impl(USHORT nId,
									 String* pHelpText = NULL ) const
                        {
                            return GetSlotName( nId, pHelpText );
                        }
	SAL_DLLPRIVATE String GetSlotName_Impl(const SfxSlot &rSlot,
										 String *pHelpText = 0) const
						{
							return GetSlotName_Impl(rSlot.GetSlotId(), pHelpText);
						}
	SAL_DLLPRIVATE String GetSlotHelpText_Impl(USHORT nId) const;
	SAL_DLLPRIVATE String GetSlotHelpText_Impl(const SfxSlot &rSlot) const
						{
							return GetSlotHelpText_Impl(rSlot.GetSlotId());
						}

	TypeId				GetSlotType( USHORT nSlotId ) const;
	SbxObject*			GetSbxObject(USHORT nId) const;

#ifdef STARBASIC
	USHORT				RegisterMacro( sbToken aToken );
	void				ReleaseMacro( sbToken aToken );
#endif
};

//--------------------------------------------------------------------

// seeks to the first func in the current group

inline const SfxSlot* SfxSlotPool::FirstSlot()
{
	return SeekSlot(0);
}

#define SFX_SLOTPOOL() SFX_APP()->GetSlotPool()

#endif

