/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mailbrw.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:18:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _MAILBRW_HXX
#define _MAILBRW_HXX

// include ---------------------------------------------------------------

#include <goodies/mailsrv.hxx>

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SVX_BRWBOX_HXX //autogen
#include <svtools/brwbox.hxx>
#endif

// forward ---------------------------------------------------------------

class MailReadOnlyDialog;

// class MailBrowser -----------------------------------------------------

class MailBrowser : public BrowseBox
{
friend class MailBrowseDialog;

private:
	Link                aSelectHdlLink;
	Link                aDoubleClickHdlLink;

	AutoTimer			aTimer;
	MailServer*         pServer;    // aktueller Server
	Mail*               pMail;      // zuletzt hierher geseekt

#if 0 // _SOLAR__PRIVATE
	void				Init();

	DECL_LINK( TimeoutHdl, AutoTimer * );
#endif

protected:
						// software plug for database access
	virtual long        GetRowCount() const;
	virtual BOOL        SeekRow( long nRow );
	virtual void        PaintField( OutputDevice& rDev, const Rectangle& rRect,
							USHORT nColumnId ) const;

						// software plug for selections
	virtual void        Select();
	virtual void        DoubleClick();

public:
	MailBrowser( Window *pParent, const ResId& rResId );
	MailBrowser( Window *pParent, WinBits nBits = 0 );
	~MailBrowser();

	BOOL                Connect( MailServer& rServer );

	void                SetSelectHdl( const Link& rNewLink )
								{ aSelectHdlLink = rNewLink; }
	const Link&         GetSelectHdl() const { return aSelectHdlLink; }
	void                SetDoubleClickHdl( const Link& rNewLink )
								{ aDoubleClickHdlLink = rNewLink; }
	const Link&         GetDoubleClickHdl() const { return aDoubleClickHdlLink; }

	void				SetConfig( const String& rCfgStr );
	String				GetConfig() const;

	MailServer*         GetServer() const { return pServer; }
	IncomingMail*		GetCurMail( BOOL bAttach = TRUE ) const;
};

#ifdef _SALE_SOLAR
// diese Klasse brauchen wir f"ur eine Solar-Auslieferung,
// sonst ist sie als SfxMailInBox_Impl im sfx
// class MailBrowseDialog ------------------------------------------------

class MailBrowseDialog : public FloatingWindow
{
private:
	PushButton		 	aOpenButton;
	PushButton		 	aDeleteButton;
	PushButton		 	aCloseButton;

	MailBrowser			aMailBrowser;

	BOOL				bInbox;

#if 0 // _SOLAR__PRIVATE
	DECL_LINK( OpenHdl, Button * );
	DECL_LINK( DeleteHdl, Button * );
	DECL_LINK( CloseHdl, Button * );
	DECL_LINK( OpenAttachFileHdl, MailReadOnlyDialog * );
	DECL_LINK( SelectHdl, MailBrowser * );
	DECL_LINK( DoubleClickHdl, MailBrowser * );
#endif

protected:
	virtual	void		Open( Window* pParent, const String& rFile );
	virtual BOOL		Close();

public:
	MailBrowseDialog( Window* pParent, MailServer& rServ, BOOL bFlag = TRUE );

	void				SetConfig( const String& rCfgStr );
	String				GetConfig() const;

	virtual void		Resize();
	virtual void		Resizing( Size& rSize );
};

#endif // _SALE_SOLAR

#endif

