/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Protocol.java,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:01:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.star.lib.uno.environments.remote;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;


import com.sun.star.lib.uno.typeinfo.AttributeTypeInfo;
import com.sun.star.lib.uno.typeinfo.MemberTypeInfo;
import com.sun.star.lib.uno.typeinfo.MethodTypeInfo;
import com.sun.star.lib.uno.typeinfo.ParameterTypeInfo;
import com.sun.star.lib.uno.typeinfo.TypeInfo;

import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.XInterface;


/**
 * @version 	$Revision: 1.9 $ $ $Date: 2005/09/07 19:01:43 $
 * @author 	    Kay Ramme
 * @since       UDK1.0
 */
public abstract class Protocol implements IProtocol {
	/**
	 * When set to true, enables various debugging output.
	 */
	static public final boolean DEBUG = false;

	protected int               _requestsSend;
	protected int               _requestsRecieved;

	private Hashtable _pending_replys   = new Hashtable();
	private Hashtable _pending_requests = new Hashtable();

	protected final void putPendingReply(ThreadId threadId, Object object) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".putPendingReply:" + threadId + " " + object);

		Stack stack = (Stack)_pending_replys.get(threadId);

		if(stack == null) {
			stack = new Stack();

			_pending_replys.put(threadId, stack);
		}

		stack.push(object);
	}

	protected final Object removePendingReply(ThreadId threadId) {
		Stack stack = (Stack)_pending_replys.get(threadId);
		Object object = stack.pop();

		if(stack.empty())
			_pending_replys.remove(threadId);

		if(DEBUG) System.err.println("##### " + getClass().getName() + ".removePendingReply:" + threadId + " " + object);
		
		return object;
	}


	protected final void putPendingRequest(ThreadId threadId, Object object) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".putPendingRequest:" + threadId + " " + object);

		Stack stack = (Stack)_pending_requests.get(threadId);
		if(stack == null) {
			stack = new Stack();
			_pending_requests.put(threadId, stack);
		}

		stack.push(object);
	}

	protected final Object removePendingRequest(ThreadId threadId) {
		Stack stack = (Stack)_pending_requests.get(threadId);

		Object object = null;

		if(stack == null) 
			throw new com.sun.star.uno.RuntimeException("WARNING! received unexpected reply " + threadId + " !!!");
		else {
			object = stack.pop();
			
			if(stack.empty())
				_pending_requests.remove(threadId);
			
		}

		if(DEBUG) System.err.println("##### " + getClass().getName() + ".removePendingRequest:" + threadId + " " + object);

		return object;
	}

	public int getRequestsSendCount() {
		return _requestsSend;
	}

	public int getRequestsReceivedCount() {
		return _requestsRecieved;
	}
}

