/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: profile.h,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:31:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _OSL_PROFILE_H_
#define _OSL_PROFILE_H_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_H
#     include <rtl/ustring.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef sal_uInt32 oslProfileOption;

#define	osl_Profile_DEFAULT     0x0000    
#define	osl_Profile_SYSTEM      0x0001    /* use system depended functinality */
#define	osl_Profile_READLOCK    0x0002    /* lock file for reading            */
#define	osl_Profile_WRITELOCK   0x0004    /* lock file for writing            */
#define	osl_Profile_FLUSHWRITE  0x0010    /* writing only with flush          */


typedef void* oslProfile;

/** Deprecated API.
	Open or create a configuration profile.
	@return 0 if the profile could not be created, otherwise a handle to the profile.
	@deprecated
*/
oslProfile SAL_CALL osl_openProfile(rtl_uString *strProfileName, oslProfileOption Options);

/** Deprecated API.
	Close the opened profile an flush all data to the disk.
	@param Profile handle to a opened profile.
	@deprecated
*/
sal_Bool SAL_CALL osl_closeProfile(oslProfile Profile);


/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_flushProfile(oslProfile Profile);
/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_readProfileString(oslProfile Profile, 
                              const sal_Char* pszSection, const sal_Char* pszEntry, 
                              sal_Char* pszString, sal_uInt32 MaxLen, 
                              const sal_Char* pszDefault);
/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_readProfileBool(oslProfile Profile, 
                            const sal_Char* pszSection, const sal_Char* pszEntry, 
							sal_Bool Default);
/** Deprecated API.
    @deprecated
*/
sal_uInt32 SAL_CALL osl_readProfileIdent(oslProfile Profile, 
                              const sal_Char* pszSection, const sal_Char* pszEntry, 
							  sal_uInt32 FirstId, const sal_Char* Strings[],
							  sal_uInt32 Default);

/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_writeProfileString(oslProfile Profile,
                               const sal_Char* pszSection, const sal_Char* pszEntry, 
							   const sal_Char* pszString);								
/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_writeProfileBool(oslProfile Profile,
                             const sal_Char* pszSection, const sal_Char* pszEntry, 
							 sal_Bool Value);
/** Deprecated API.
    @deprecated
*/
sal_Bool SAL_CALL osl_writeProfileIdent(oslProfile Profile,
                              const sal_Char* pszSection, const sal_Char* pszEntry, 
							  sal_uInt32 FirstId, const sal_Char* Strings[], 
							  sal_uInt32 Value);

/** Deprecated API.
	Acquire the mutex, block if already acquired by another thread.
	@param Profile handle to a opened profile.
	@return False if section or entry could not be found.
	@deprecated
*/
sal_Bool SAL_CALL osl_removeProfileEntry(oslProfile Profile, 
                               const sal_Char *pszSection, const sal_Char *pszEntry);

/** Deprecated API.
	Get all entries belonging to the specified section.
	@param Profile handle to a opened profile.
	@return Pointer to a array of pointers.
	@deprecated
*/
sal_uInt32 SAL_CALL osl_getProfileSectionEntries(oslProfile Profile, const sal_Char *pszSection,
	    						    sal_Char* pszBuffer, sal_uInt32 MaxLen);

/** Deprecated API.
	Get all section entries
	@param Profile handle to a opened profile.
	@return Pointer to a array of pointers.
	@deprecated
*/
sal_uInt32 SAL_CALL osl_getProfileSections(oslProfile Profile, sal_Char* pszBuffer, sal_uInt32 MaxLen);

#ifdef __cplusplus
}
#endif

#endif	/* _OSL_PROFILE_H_ */

