/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class VariableNode {
    Scriptable scope;
    String name;
    int index;
    Object[] children;
    static final Object[] empty = new Object[0];

    public VariableNode(Scriptable scriptable, String string) {
        this.scope = scriptable;
        this.name = string;
    }

    public VariableNode(Scriptable scriptable, int n) {
        this.scope = scriptable;
        this.name = null;
        this.index = n;
    }

    public String toString() {
        return this.name != null ? this.name : "[" + this.index + "]";
    }

    public Object getObject() {
        try {
            if (this.scope == null) {
                return null;
            }
            if (this.name != null) {
                if (this.name.equals("this")) {
                    return this.scope;
                }
                Object object = Scriptable.NOT_FOUND;
                if (this.name.equals("__proto__")) {
                    object = this.scope.getPrototype();
                } else if (this.name.equals("__parent__")) {
                    object = this.scope.getParentScope();
                } else {
                    try {
                        object = ScriptableObject.getProperty(this.scope, this.name);
                    }
                    catch (RuntimeException runtimeException) {
                        object = runtimeException.getMessage();
                    }
                }
                if (object == Scriptable.NOT_FOUND) {
                    object = Undefined.instance;
                }
                return object;
            }
            Object object = ScriptableObject.getProperty(this.scope, this.index);
            if (object == Scriptable.NOT_FOUND) {
                object = Undefined.instance;
            }
            return object;
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        Context context = Context.enter();
        try {
            Object object = this.getObject();
            if (object == null) {
                this.children = empty;
                Object[] objectArray = empty;
                return objectArray;
            }
            if (object == Scriptable.NOT_FOUND || object == Undefined.instance) {
                this.children = empty;
                Object[] objectArray = empty;
                return objectArray;
            }
            if (object instanceof Scriptable) {
                Scriptable scriptable = (Scriptable)object;
                Scriptable scriptable2 = scriptable.getPrototype();
                Scriptable scriptable3 = scriptable.getParentScope();
                if (scriptable.has(0, scriptable)) {
                    int n = 0;
                    try {
                        Scriptable scriptable4;
                        Scriptable scriptable5 = scriptable4 = scriptable;
                        Object object2 = Undefined.instance;
                        while (!(scriptable5.has("length", scriptable4) && (object2 = scriptable5.get("length", scriptable4)) != Scriptable.NOT_FOUND || (scriptable5 = scriptable5.getPrototype()) == null)) {
                        }
                        if (object2 instanceof Number) {
                            n = ((Number)object2).intValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (scriptable3 != null) {
                        ++n;
                    }
                    if (scriptable2 != null) {
                        ++n;
                    }
                    this.children = new VariableNode[n];
                    int n2 = 0;
                    int n3 = 0;
                    if (scriptable3 != null) {
                        this.children[n2++] = new VariableNode(scriptable, "__parent__");
                        ++n3;
                    }
                    if (scriptable2 != null) {
                        this.children[n2++] = new VariableNode(scriptable, "__proto__");
                        ++n3;
                    }
                    while (n2 < n) {
                        this.children[n2] = new VariableNode(scriptable, n2 - n3);
                        ++n2;
                    }
                } else {
                    int n = 0;
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                    Object[] objectArray = scriptable instanceof ScriptableObject ? ((ScriptableObject)scriptable).getAllIds() : scriptable.getIds();
                    if (objectArray == null) {
                        objectArray = empty;
                    }
                    if (scriptable2 != null) {
                        hashtable.put("__proto__", "__proto__");
                    }
                    if (scriptable3 != null) {
                        hashtable.put("__parent__", "__parent__");
                    }
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            hashtable.put(objectArray[i], objectArray[i]);
                        }
                    }
                    objectArray = new Object[hashtable.size()];
                    Enumeration enumeration = hashtable.keys();
                    int n4 = 0;
                    while (enumeration.hasMoreElements()) {
                        objectArray[n4++] = enumeration.nextElement().toString();
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        Arrays.sort(objectArray, new Comparator(){

                            public int compare(Object object, Object object2) {
                                return object.toString().compareToIgnoreCase(object2.toString());
                            }
                        });
                        n = objectArray.length;
                    }
                    this.children = new VariableNode[n];
                    for (int i = 0; i < n; ++i) {
                        Object object3 = objectArray[i];
                        this.children[i] = new VariableNode(scriptable, object3.toString());
                    }
                }
            }
            context.exit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            context.exit();
        }
        return this.children;
    }
}

