/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.REMatchState;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_CLASS = 50;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_END = 53;
    private static final int OFFSET_LEN = 2;
    private static final int ARG_LEN = 2;
    private static final int INITIAL_STATESTACK = 20;
    private static final int INITIAL_BACKTRACK = 20;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_exec = 8;
    private static final int Id_test = 9;
    private static final int Id_prefix = 10;
    private static final int MAX_PROTOTYPE_ID = 10;
    private boolean prototypeFlag;
    private char[] source;
    private double lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    private int classCount;
    private RECharSet[] classList;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.prototypeFlag = true;
        nativeRegExp.setMaxId(10);
        nativeRegExp.setSealFunctionsFlag(bl);
        nativeRegExp.setFunctionParametrs(context);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(NativeRegExp.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        ScriptRuntime.setFunctionProtoAndParent(scriptable, nativeRegExpCtor);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        NativeRegExp.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    public NativeRegExp(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        this.setMaxId(5);
        this.init(context, scriptable, string, string2, bl);
    }

    public void init(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        int n;
        this.source = string.toCharArray();
        int n2 = string.length();
        this.flags = 0;
        if (string2 != null) {
            for (int i = 0; i < string2.length(); ++i) {
                n = string2.charAt(i);
                if (n == 103) {
                    this.flags = (byte)(this.flags | 1);
                    continue;
                }
                if (n == 105) {
                    this.flags = (byte)(this.flags | 2);
                    continue;
                }
                if (n == 109) {
                    this.flags = (byte)(this.flags | 4);
                    continue;
                }
                Object[] objectArray = new Object[]{new Character((char)n)};
                throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.invalid.re.flag", objectArray), scriptable);
            }
        }
        CompilerState compilerState = new CompilerState(this.source, n2, this.flags, context, scriptable);
        if (bl && n2 > 0) {
            compilerState.result = new RENode(21);
            compilerState.result.chr = compilerState.cpbegin[0];
            compilerState.result.length = n2;
            compilerState.result.flatIndex = 0;
            compilerState.progLength += 5;
        } else if (!this.parseDisjunction(compilerState)) {
            return;
        }
        this.program = new byte[compilerState.progLength + 1];
        if (compilerState.classCount != 0) {
            this.classList = new RECharSet[compilerState.classCount];
            for (n = 0; n < compilerState.classCount; ++n) {
                this.classList[n] = new RECharSet();
            }
            this.classCount = compilerState.classCount;
        }
        n = this.emitREBytecode(compilerState, this, 0, compilerState.result);
        this.program[n++] = 53;
        this.parenCount = compilerState.parenCount;
        this.flags = this.flags;
        this.lastIndex = 0.0;
        scriptable = NativeRegExp.getTopLevelScope(scriptable);
        this.setPrototype(NativeRegExp.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    public String getClassName() {
        return "RegExp";
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.call(context, scriptable, null, objectArray);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw NativeGlobal.constructError(context, "TypeError", "only one argument may be specified if the first argument is a RegExp object", scriptable);
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.source = nativeRegExp.source;
            this.lastIndex = nativeRegExp.lastIndex;
            this.parenCount = nativeRegExp.parenCount;
            this.flags = nativeRegExp.flags;
            this.program = nativeRegExp.program;
            return this;
        }
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.init(context, scriptable, string, string2, false);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        if (this.source != null) {
            stringBuffer.append(this.source);
        }
        stringBuffer.append('/');
        if ((this.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    NativeRegExp() {
        this.setMaxId(5);
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        Object object;
        double d;
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                Object[] objectArray2 = new Object[]{this.toString()};
                throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.no.re.input.for", objectArray2), scriptable);
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        double d2 = d = (this.flags & 1) != 0 ? this.lastIndex : 0.0;
        if (d < 0.0 || (double)string.length() < d) {
            this.lastIndex = 0.0;
            object = null;
        } else {
            int[] nArray = new int[]{(int)d};
            object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
            if ((this.flags & 1) != 0) {
                this.lastIndex = object == null || object == Undefined.instance ? 0.0 : (double)nArray[0];
            }
        }
        return object;
    }

    private Object exec(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    private Object test(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object = this.execSub(context, scriptable, objectArray, 0);
        if (object == null || !object.equals(Boolean.TRUE)) {
            object = Boolean.FALSE;
        }
        return object;
    }

    private Object prefix(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 2);
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private boolean isLineTerm(char c) {
        return TokenStream.isJSLineTerminator(c);
    }

    private boolean isREWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 8232 || n == 8233 || n == 12 || n == 11 || n == 160 || Character.getType((char)n) == 12;
    }

    private char canonicalize(char c) {
        char c2 = Character.toUpperCase(c);
        if (c >= '\u0080' && c2 < '\u0080') {
            return c;
        }
        return c2;
    }

    private static int toASCIIHexDigit(int n) {
        if (n < 48) {
            return -1;
        }
        if (n <= 57) {
            return n - 48;
        }
        if (97 <= (n |= 0x20) && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    private boolean parseDisjunction(CompilerState compilerState) {
        int n;
        if (!this.parseAlternative(compilerState)) {
            return false;
        }
        char[] cArray = compilerState.cpbegin;
        if ((n = compilerState.cp++) != cArray.length && cArray[n] == '|') {
            RENode rENode = new RENode(1);
            rENode.kid = compilerState.result;
            if (!this.parseDisjunction(compilerState)) {
                return false;
            }
            rENode.kid2 = compilerState.result;
            compilerState.result = rENode;
            compilerState.progLength += 9;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseAlternative(CompilerState var1_1) {
        var2_2 = null;
        var3_3 = null;
        var4_4 = var1_1.cpbegin;
        block0: while (true) {
            if (var1_1.cp == var1_1.cpend || var4_4[var1_1.cp] == ')' || var4_4[var1_1.cp] == '|') {
                var1_1.result = var2_2 == null ? new RENode(0) : var2_2;
                return true;
            }
            if (!this.parseTerm(var1_1)) {
                return false;
            }
            if (var2_2 == null) {
                var2_2 = var1_1.result;
                continue;
            }
            if (var3_3 == null) {
                var2_2.next = var1_1.result;
                var3_3 = var1_1.result;
                while (true) {
                    if (var3_3.next == null) continue block0;
                    var3_3 = var3_3.next;
                }
            }
            var3_3 = var3_3.next = var1_1.result;
            while (true) {
                if (var3_3.next != null) ** break;
                continue block0;
                var3_3 = var3_3.next;
            }
            break;
        }
    }

    private boolean calculateBitmapSize(CompilerState compilerState, RENode rENode, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        rENode.bmsize = 0;
        if (n == n2) {
            return true;
        }
        if (cArray[n] == '^') {
            ++n;
        }
        while (n != n2) {
            int n5;
            int n6 = 0;
            int n7 = 2;
            block0 : switch (cArray[n]) {
                case '\\': {
                    int n8 = ++n;
                    ++n;
                    n5 = cArray[n8];
                    switch (n5) {
                        case 98: {
                            n6 = 8;
                            break block0;
                        }
                        case 102: {
                            n6 = 12;
                            break block0;
                        }
                        case 110: {
                            n6 = 10;
                            break block0;
                        }
                        case 114: {
                            n6 = 13;
                            break block0;
                        }
                        case 116: {
                            n6 = 9;
                            break block0;
                        }
                        case 118: {
                            n6 = 11;
                            break block0;
                        }
                        case 99: {
                            if (n + 1 < n2 && Character.isLetter(cArray[n + 1])) {
                                n6 = (char)(cArray[n++] & 0x1F);
                                break block0;
                            }
                            n6 = 92;
                            break block0;
                        }
                        case 117: {
                            n7 += 2;
                        }
                        case 120: {
                            int n9;
                            int n10 = 0;
                            for (n9 = 0; n9 < n7 && n < n2; ++n9) {
                                if (!NativeRegExp.isHex((char)(n5 = cArray[n++]))) {
                                    n -= n9 + 1;
                                    n10 = 92;
                                    break;
                                }
                                n10 = n10 << 4 | NativeRegExp.unHex((char)n5);
                            }
                            n6 = n10;
                            break block0;
                        }
                        case 100: {
                            if (bl) {
                                this.reportError("msg.bad.range", "", compilerState);
                                return false;
                            }
                            n6 = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (bl) {
                                this.reportError("msg.bad.range", "", compilerState);
                                return false;
                            }
                            rENode.bmsize = 65535;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n9;
                            int n10 = n5 - 48;
                            n5 = cArray[n];
                            if (48 <= n5 && n5 <= 55) {
                                n10 = 8 * n10 + (n5 - 48);
                                if (48 <= (n5 = cArray[++n]) && n5 <= 55) {
                                    ++n;
                                    n9 = 8 * n10 + (n5 - 48);
                                    if (n9 <= 255) {
                                        n10 = n9;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            n6 = n10;
                            break block0;
                        }
                    }
                    n6 = n5;
                    break;
                }
                default: {
                    n6 = cArray[n++];
                }
            }
            if (bl) {
                if (n3 > n6) {
                    this.reportError("msg.bad.range", "", compilerState);
                    return false;
                }
                bl = false;
            } else if (n < n2 - 1 && cArray[n] == '-') {
                ++n;
                bl = true;
                n3 = (char)n6;
                continue;
            }
            if ((compilerState.flags & 2) != 0 && (n5 = (int)this.canonicalize((char)n6)) > n6) {
                n6 = n5;
            }
            if (n6 <= n4) continue;
            n4 = n6;
        }
        rENode.bmsize = n4;
        return true;
    }

    private void doFlat(CompilerState compilerState, char c) {
        compilerState.result = new RENode(21);
        compilerState.result.chr = c;
        compilerState.result.length = 1;
        compilerState.result.flatIndex = -1;
        compilerState.progLength += 3;
    }

    private int getDecimalValue(char c, CompilerState compilerState) {
        char[] cArray = compilerState.cpbegin;
        int n = c - 48;
        while (compilerState.cp < compilerState.cpend && NativeRegExp.isDigit(c = cArray[compilerState.cp])) {
            n = 10 * n + (c - 48);
            ++compilerState.cp;
        }
        return n;
    }

    private boolean parseTerm(CompilerState compilerState) {
        int n;
        char[] cArray = compilerState.cpbegin;
        char c = cArray[compilerState.cp++];
        int n2 = 2;
        int n3 = compilerState.parenCount;
        int n4 = compilerState.cp;
        block0 : switch (c) {
            case '^': {
                compilerState.result = new RENode(2);
                ++compilerState.progLength;
                return true;
            }
            case '$': {
                compilerState.result = new RENode(3);
                ++compilerState.progLength;
                return true;
            }
            case '\\': {
                if (compilerState.cp < compilerState.cpend) {
                    c = cArray[compilerState.cp++];
                    switch (c) {
                        case 'b': {
                            compilerState.result = new RENode(4);
                            ++compilerState.progLength;
                            return true;
                        }
                        case 'B': {
                            compilerState.result = new RENode(5);
                            ++compilerState.progLength;
                            return true;
                        }
                        case '0': {
                            int n5 = 0;
                            while (compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                ++compilerState.cp;
                                int n6 = 8 * n5 + (c - 48);
                                if (n6 > 255) break;
                                n5 = n6;
                            }
                            c = (char)n5;
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int n7 = compilerState.cp - 1;
                            int n8 = this.getDecimalValue(c, compilerState);
                            if (n8 > 9 && n8 > compilerState.parenCount) {
                                compilerState.cp = n7;
                                n8 = 0;
                                while (compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                    ++compilerState.cp;
                                    int n9 = 8 * n8 + (c - 48);
                                    if (n9 > 255) break;
                                    n8 = n9;
                                }
                                c = (char)n8;
                                this.doFlat(compilerState, c);
                                break block0;
                            }
                            compilerState.result = new RENode(20);
                            compilerState.result.parenIndex = n8 - 1;
                            compilerState.progLength += 3;
                            break block0;
                        }
                        case 'f': {
                            c = '\f';
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'n': {
                            c = '\n';
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'r': {
                            c = '\r';
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 't': {
                            c = '\t';
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'v': {
                            c = '\u000b';
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'c': {
                            if (compilerState.cp + 1 < compilerState.cpend && Character.isLetter(cArray[compilerState.cp + 1])) {
                                c = (char)(cArray[compilerState.cp++] & 0x1F);
                            } else {
                                --compilerState.cp;
                                c = '\\';
                            }
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'u': {
                            n2 += 2;
                        }
                        case 'x': {
                            int n10 = 0;
                            for (n = 0; n < n2 && compilerState.cp < compilerState.cpend; ++n) {
                                if (!NativeRegExp.isHex(c = cArray[compilerState.cp++])) {
                                    compilerState.cp -= n + 2;
                                    n10 = cArray[compilerState.cp++];
                                    break;
                                }
                                n10 = n10 << 4 | NativeRegExp.unHex(c);
                            }
                            c = (char)n10;
                            this.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'd': {
                            compilerState.result = new RENode(14);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'D': {
                            compilerState.result = new RENode(15);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 's': {
                            compilerState.result = new RENode(18);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'S': {
                            compilerState.result = new RENode(19);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'w': {
                            compilerState.result = new RENode(16);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'W': {
                            compilerState.result = new RENode(17);
                            ++compilerState.progLength;
                            break block0;
                        }
                    }
                    compilerState.result = new RENode(21);
                    compilerState.result.chr = c;
                    compilerState.result.length = 1;
                    compilerState.result.flatIndex = compilerState.cp - 1;
                    compilerState.progLength += 3;
                    break;
                }
                this.reportError("msg.trail.backslash", "", compilerState);
                return false;
            }
            case '(': {
                RENode rENode = null;
                int n11 = compilerState.cp;
                if (compilerState.cp < compilerState.cpend && cArray[compilerState.cp] == '?' && (cArray[compilerState.cp + 1] == '=' || cArray[compilerState.cp + 1] == '!' || cArray[compilerState.cp + 1] == ':')) {
                    ++compilerState.cp;
                    switch (cArray[compilerState.cp++]) {
                        case '=': {
                            rENode = new RENode(41);
                            compilerState.progLength += 4;
                            break;
                        }
                        case '!': {
                            rENode = new RENode(42);
                            compilerState.progLength += 4;
                        }
                    }
                } else {
                    rENode = new RENode(10);
                    compilerState.progLength += 6;
                    rENode.parenIndex = compilerState.parenCount++;
                }
                if (!this.parseDisjunction(compilerState)) {
                    return false;
                }
                if (compilerState.cp == compilerState.cpend || cArray[compilerState.cp] != ')') {
                    this.reportError("msg.unterm.paren", "", compilerState);
                    return false;
                }
                ++compilerState.cp;
                if (rENode == null) break;
                rENode.kid = compilerState.result;
                compilerState.result = rENode;
                break;
            }
            case '[': {
                int n12;
                compilerState.result = new RENode(50);
                compilerState.result.startIndex = n12 = compilerState.cp;
                while (true) {
                    if (compilerState.cp == compilerState.cpend) {
                        this.reportError("msg.unterm.class", "", compilerState);
                        return false;
                    }
                    if (cArray[compilerState.cp] == '\\') {
                        ++compilerState.cp;
                    } else if (cArray[compilerState.cp] == ']') break;
                    ++compilerState.cp;
                }
                compilerState.result.kidlen = compilerState.cp - n12;
                compilerState.result.index = compilerState.classCount++;
                if (!this.calculateBitmapSize(compilerState, compilerState.result, cArray, n12, compilerState.cp++)) {
                    return false;
                }
                compilerState.progLength += 3;
                break;
            }
            case '.': {
                compilerState.result = new RENode(12);
                ++compilerState.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': 
            case '}': {
                this.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.cp - 1]), compilerState);
                return false;
            }
            default: {
                compilerState.result = new RENode(21);
                compilerState.result.chr = c;
                compilerState.result.length = 1;
                compilerState.result.flatIndex = compilerState.cp - 1;
                compilerState.progLength += 3;
            }
        }
        RENode rENode = compilerState.result;
        boolean bl = false;
        if (compilerState.cp < compilerState.cpend) {
            switch (cArray[compilerState.cp]) {
                case '+': {
                    compilerState.result = new RENode(6);
                    compilerState.result.min = 1;
                    compilerState.result.max = -1;
                    compilerState.progLength += 8;
                    bl = true;
                    break;
                }
                case '*': {
                    compilerState.result = new RENode(6);
                    compilerState.result.min = 0;
                    compilerState.result.max = -1;
                    compilerState.progLength += 8;
                    bl = true;
                    break;
                }
                case '?': {
                    compilerState.result = new RENode(6);
                    compilerState.result.min = 0;
                    compilerState.result.max = 1;
                    compilerState.progLength += 8;
                    bl = true;
                    break;
                }
                case '{': {
                    n = 0;
                    int n13 = -1;
                    int n14 = compilerState.cp++;
                    compilerState.result = new RENode(6);
                    c = cArray[compilerState.cp];
                    if (NativeRegExp.isDigit(c)) {
                        ++compilerState.cp;
                    } else {
                        this.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.cp]), compilerState);
                        return false;
                    }
                    n = this.getDecimalValue(c, compilerState);
                    c = cArray[compilerState.cp];
                    if (n >> 16 != 0) {
                        this.reportError("msg.overlarge.max", String.valueOf(cArray[compilerState.cp]), compilerState);
                        return false;
                    }
                    if (c == ',') {
                        if (NativeRegExp.isDigit(c = cArray[++compilerState.cp])) {
                            ++compilerState.cp;
                            n13 = this.getDecimalValue(c, compilerState);
                            c = cArray[compilerState.cp];
                            if (n13 >> 16 != 0) {
                                this.reportError("msg.overlarge.max", String.valueOf(cArray[compilerState.cp]), compilerState);
                                return false;
                            }
                            if (n > n13) {
                                this.reportError("msg.max.lt.min", String.valueOf(cArray[compilerState.cp]), compilerState);
                                return false;
                            }
                        }
                        if (n13 == 0) {
                            this.reportError("msg.zero.quant", String.valueOf(cArray[compilerState.cp]), compilerState);
                            return false;
                        }
                    } else {
                        n13 = n;
                        if (n13 == 0) {
                            this.reportError("msg.zero.quant", String.valueOf(cArray[compilerState.cp]), compilerState);
                            return false;
                        }
                    }
                    compilerState.result.min = n;
                    compilerState.result.max = n13;
                    compilerState.progLength += 12;
                    if (c == '}') {
                        bl = true;
                        break;
                    }
                    this.reportError("msg.unterm.quant", String.valueOf(cArray[compilerState.cp]), compilerState);
                    return false;
                }
            }
        }
        if (!bl) {
            return true;
        }
        ++compilerState.cp;
        compilerState.result.kid = rENode;
        compilerState.result.parenIndex = n3;
        compilerState.result.parenCount = compilerState.parenCount - n3;
        if (compilerState.cp < compilerState.cpend && cArray[compilerState.cp] == '?') {
            ++compilerState.cp;
            compilerState.result.greedy = false;
        } else {
            compilerState.result.greedy = true;
        }
        return true;
    }

    private void CHECK_OFFSET(int n) {
        if ((short)n != n) {
            throw new RuntimeException();
        }
    }

    private void SET_OFFSET(int n, int n2) {
        this.program[n] = (byte)(n2 >> 8);
        this.program[n + 1] = (byte)n2;
    }

    private int GET_OFFSET(int n) {
        return (this.program[n] & 0xFF) << 8 | this.program[n + 1] & 0xFF;
    }

    private int GET_ARG(int n) {
        return this.GET_OFFSET(n);
    }

    private void SET_ARG(int n, int n2) {
        this.SET_OFFSET(n, n2);
    }

    private int emitREBytecode(CompilerState compilerState, NativeRegExp nativeRegExp, int n, RENode rENode) {
        while (rENode != null) {
            this.program[n++] = rENode.op;
            switch (rENode.op) {
                case 0: {
                    --n;
                    break;
                }
                case 1: {
                    RENode rENode2 = rENode.kid2;
                    int n2 = n;
                    n += 2;
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode.kid);
                    this.program[n++] = 23;
                    int n3 = n;
                    int n4 = (n += 2) - n2;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n2, n4);
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode2);
                    this.program[n++] = 23;
                    n2 = n;
                    n4 = (n += 2) - n3;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n3, n4);
                    n4 = n - n2;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n2, n4);
                    break;
                }
                case 21: {
                    if (rENode.flatIndex != -1) {
                        while (rENode.next != null && rENode.next.op == 21 && rENode.flatIndex + rENode.length == rENode.next.flatIndex) {
                            rENode.length += rENode.next.length;
                            rENode.next = rENode.next.next;
                        }
                    }
                    if (rENode.flatIndex != -1 && rENode.length > 1) {
                        this.program[n - 1] = (compilerState.flags & 2) != 0 ? 32 : 21;
                        this.SET_ARG(n, rENode.flatIndex);
                        this.SET_ARG(n += 2, rENode.length);
                        n += 2;
                        break;
                    }
                    if (rENode.chr < '\u0100') {
                        this.program[n - 1] = (compilerState.flags & 2) != 0 ? 33 : 22;
                        this.program[n++] = (byte)rENode.chr;
                        break;
                    }
                    this.program[n - 1] = (compilerState.flags & 2) != 0 ? 35 : 28;
                    this.SET_ARG(n, rENode.chr);
                    n += 2;
                    break;
                }
                case 10: {
                    this.SET_ARG(n, rENode.parenIndex);
                    n += 2;
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode.kid);
                    this.program[n++] = 11;
                    this.SET_ARG(n, rENode.parenIndex);
                    n += 2;
                    break;
                }
                case 20: {
                    this.SET_ARG(n, rENode.parenIndex);
                    n += 2;
                    break;
                }
                case 41: {
                    int n3 = n;
                    n += 2;
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode.kid);
                    this.program[n++] = 43;
                    int n4 = n - n3;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n3, n4);
                    break;
                }
                case 42: {
                    int n3 = n;
                    n += 2;
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode.kid);
                    this.program[n++] = 44;
                    int n4 = n - n3;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n3, n4);
                    break;
                }
                case 6: {
                    if (rENode.min == 0 && rENode.max == -1) {
                        this.program[n - 1] = rENode.greedy ? 7 : 45;
                    } else if (rENode.min == 0 && rENode.max == 1) {
                        this.program[n - 1] = rENode.greedy ? 9 : 47;
                    } else if (rENode.min == 1 && rENode.max == -1) {
                        this.program[n - 1] = rENode.greedy ? 8 : 46;
                    } else {
                        if (!rENode.greedy) {
                            this.program[n - 1] = 48;
                        }
                        this.SET_ARG(n, rENode.min);
                        this.SET_ARG(n += 2, rENode.max);
                        n += 2;
                    }
                    this.SET_ARG(n, rENode.parenCount);
                    this.SET_ARG(n += 2, rENode.parenIndex);
                    int n3 = n += 2;
                    n += 2;
                    n = this.emitREBytecode(compilerState, nativeRegExp, n, rENode.kid);
                    this.program[n++] = 49;
                    int n4 = n - n3;
                    this.CHECK_OFFSET(n4);
                    this.SET_OFFSET(n3, n4);
                    break;
                }
                case 50: {
                    this.SET_ARG(n, rENode.index);
                    n += 2;
                    RECharSet rECharSet = nativeRegExp.classList[rENode.index];
                    rECharSet.converted = false;
                    rECharSet.length = rENode.bmsize;
                    rECharSet.startIndex = rENode.startIndex;
                    rECharSet.strlength = rENode.kidlen;
                    break;
                }
            }
            rENode = rENode.next;
        }
        return n;
    }

    private REBackTrackData pushBackTrackState(REGlobalData rEGlobalData, byte by, int n, REMatchState rEMatchState) {
        if (rEGlobalData.backTrackStackTop == rEGlobalData.maxBackTrack) {
            int n2;
            rEGlobalData.maxBackTrack <<= 1;
            REBackTrackData[] rEBackTrackDataArray = new REBackTrackData[rEGlobalData.maxBackTrack];
            for (n2 = 0; n2 < rEGlobalData.backTrackStackTop; ++n2) {
                rEBackTrackDataArray[n2] = rEGlobalData.backTrackStack[n2];
            }
            for (n2 = rEGlobalData.backTrackStackTop; n2 < rEGlobalData.maxBackTrack; ++n2) {
                rEBackTrackDataArray[n2] = new REBackTrackData(rEMatchState);
            }
            rEGlobalData.backTrackStack = rEBackTrackDataArray;
        }
        REBackTrackData rEBackTrackData = new REBackTrackData(rEMatchState);
        rEGlobalData.backTrackStack[rEGlobalData.backTrackStackTop++] = rEBackTrackData;
        rEBackTrackData.continuation_op = by;
        rEBackTrackData.continuation_pc = n;
        rEBackTrackData.lastParen = rEGlobalData.lastParen;
        rEBackTrackData.currentState = new REProgState(rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1]);
        if (rEGlobalData.stateStackTop > 1) {
            rEBackTrackData.precedingStateTop = rEGlobalData.stateStackTop - 1;
            rEBackTrackData.precedingState = new REProgState[rEBackTrackData.precedingStateTop];
            for (int i = 0; i < rEBackTrackData.precedingStateTop; ++i) {
                rEBackTrackData.precedingState[i] = new REProgState(rEGlobalData.stateStack[i]);
            }
        } else {
            rEBackTrackData.precedingStateTop = 0;
            rEBackTrackData.precedingState = null;
        }
        return rEBackTrackData;
    }

    private REMatchState flatMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, char c) {
        if (rEMatchState.cp == rEGlobalData.cpend) {
            return null;
        }
        if (rEGlobalData.cpbegin[rEMatchState.cp] != c) {
            return null;
        }
        ++rEMatchState.cp;
        return rEMatchState;
    }

    private REMatchState flatIMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, char c) {
        if (rEMatchState.cp == rEGlobalData.cpend) {
            return null;
        }
        if (this.canonicalize(rEGlobalData.cpbegin[rEMatchState.cp]) != this.canonicalize(c)) {
            return null;
        }
        ++rEMatchState.cp;
        return rEMatchState;
    }

    private REMatchState flatNMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n, int n2) {
        if (rEMatchState.cp + n2 > rEGlobalData.cpend) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            if (rEGlobalData.regexp.source[n + i] == rEGlobalData.cpbegin[rEMatchState.cp + i]) continue;
            return null;
        }
        rEMatchState.cp += n2;
        return rEMatchState;
    }

    private REMatchState flatNIMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n, int n2) {
        if (rEMatchState.cp + n2 > rEGlobalData.cpend) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.canonicalize(rEGlobalData.regexp.source[n + i]) == this.canonicalize(rEGlobalData.cpbegin[rEMatchState.cp + i])) continue;
            return null;
        }
        rEMatchState.cp += n2;
        return rEMatchState;
    }

    private REMatchState backrefMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n) {
        int n2 = rEMatchState.parens_index(n);
        if (n2 == -1) {
            return rEMatchState;
        }
        int n3 = rEMatchState.parens_length(n);
        if (rEMatchState.cp + n3 > rEGlobalData.cpend) {
            return null;
        }
        if ((rEGlobalData.regexp.flags & 2) != 0) {
            for (int i = 0; i < n3; ++i) {
                if (this.canonicalize(rEGlobalData.cpbegin[n2 + i]) == this.canonicalize(rEGlobalData.cpbegin[rEMatchState.cp + i])) continue;
                return null;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (rEGlobalData.cpbegin[n2 + i] == rEGlobalData.cpbegin[rEMatchState.cp + i]) continue;
                return null;
            }
        }
        rEMatchState.cp += n3;
        return rEMatchState;
    }

    private void addCharacterToCharSet(RECharSet rECharSet, char c) {
        int n = c / 8;
        if (c > rECharSet.length) {
            throw new RuntimeException();
        }
        int n2 = n;
        rECharSet.bits[n2] = (byte)(rECharSet.bits[n2] | 1 << (c & 7));
    }

    private void addCharacterRangeToCharSet(RECharSet rECharSet, char c, char c2) {
        int n = c / 8;
        int n2 = c2 / 8;
        if (c2 > rECharSet.length || c > c2) {
            throw new RuntimeException();
        }
        c = (char)(c & 7);
        c2 = (char)(c2 & 7);
        if (n == n2) {
            int n3 = n;
            rECharSet.bits[n3] = (byte)(rECharSet.bits[n3] | 255 >> 7 - (c2 - c) << c);
        } else {
            int n4 = n;
            rECharSet.bits[n4] = (byte)(rECharSet.bits[n4] | 255 << c);
            for (int i = n + 1; i < n2; ++i) {
                rECharSet.bits[i] = -1;
            }
            int n5 = n2;
            rECharSet.bits[n5] = (byte)(rECharSet.bits[n5] | 255 >> 7 - c2);
        }
    }

    private boolean processCharSet(REGlobalData rEGlobalData, RECharSet rECharSet) {
        int n = rECharSet.startIndex;
        int n2 = n + rECharSet.strlength;
        char c = '\u0000';
        boolean bl = false;
        rECharSet.sense = true;
        int n3 = rECharSet.length / 8 + 1;
        rECharSet.bits = new byte[n3];
        if (n == n2) {
            return true;
        }
        if (rEGlobalData.regexp.source[n] == '^') {
            rECharSet.sense = false;
            ++n;
        }
        block21: while (n != n2) {
            char c2;
            char c3;
            int n4 = 2;
            block0 : switch (rEGlobalData.regexp.source[n]) {
                case '\\': {
                    int n5 = ++n;
                    ++n;
                    char c4 = rEGlobalData.regexp.source[n5];
                    switch (c4) {
                        case 'b': {
                            c3 = '\b';
                            break block0;
                        }
                        case 'f': {
                            c3 = '\f';
                            break block0;
                        }
                        case 'n': {
                            c3 = '\n';
                            break block0;
                        }
                        case 'r': {
                            c3 = '\r';
                            break block0;
                        }
                        case 't': {
                            c3 = '\t';
                            break block0;
                        }
                        case 'v': {
                            c3 = '\u000b';
                            break block0;
                        }
                        case 'c': {
                            if (n + 1 < n2 && NativeRegExp.isWord(rEGlobalData.regexp.source[n + 1])) {
                                c3 = (char)(rEGlobalData.regexp.source[n++] & 0x1F);
                                break block0;
                            }
                            --n;
                            c3 = '\\';
                            break block0;
                        }
                        case 'u': {
                            n4 += 2;
                        }
                        case 'x': {
                            int n6;
                            int n7 = 0;
                            for (n6 = 0; n6 < n4 && n < n2; ++n6) {
                                if ((c2 = NativeRegExp.toASCIIHexDigit(c4 = rEGlobalData.regexp.source[n++])) < '\u0000') {
                                    n -= n6 + 1;
                                    n7 = 92;
                                    break;
                                }
                                n7 = n7 << 4 | c2;
                            }
                            c3 = (char)n7;
                            break block0;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int n6;
                            int n7 = c4 - 48;
                            c4 = rEGlobalData.regexp.source[n];
                            if ('0' <= c4 && c4 <= '7') {
                                n7 = 8 * n7 + (c4 - 48);
                                if ('0' <= (c4 = rEGlobalData.regexp.source[++n]) && c4 <= '7') {
                                    ++n;
                                    n6 = 8 * n7 + (c4 - 48);
                                    if (n6 <= 255) {
                                        n7 = n6;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            c3 = (char)n7;
                            break block0;
                        }
                        case 'd': {
                            this.addCharacterRangeToCharSet(rECharSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            this.addCharacterRangeToCharSet(rECharSet, '\u0000', '/');
                            this.addCharacterRangeToCharSet(rECharSet, ':', (char)rECharSet.length);
                            continue block21;
                        }
                        case 's': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (!this.isREWhiteSpace(n6)) continue;
                                this.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'S': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (this.isREWhiteSpace(n6)) continue;
                                this.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'w': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (!NativeRegExp.isWord((char)n6)) continue;
                                this.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'W': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (NativeRegExp.isWord((char)n6)) continue;
                                this.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                    }
                    c3 = c4;
                    break;
                }
                default: {
                    c3 = rEGlobalData.regexp.source[n++];
                }
            }
            if (bl) {
                if ((rEGlobalData.regexp.flags & 2) != 0) {
                    c2 = '\uffff';
                    char c5 = '\u0000';
                    if (c < c2) {
                        c2 = c;
                    }
                    if (c3 < c2) {
                        c2 = c3;
                    }
                    if (this.canonicalize(c) < c2) {
                        c2 = this.canonicalize(c);
                    }
                    if (this.canonicalize(c3) < c2) {
                        c2 = this.canonicalize(c3);
                    }
                    if (c > c5) {
                        c5 = c;
                    }
                    if (c3 > c5) {
                        c5 = c3;
                    }
                    if (this.canonicalize(c) > c5) {
                        c5 = this.canonicalize(c);
                    }
                    if (this.canonicalize(c3) > c5) {
                        c5 = this.canonicalize(c3);
                    }
                    this.addCharacterRangeToCharSet(rECharSet, c2, c5);
                } else {
                    this.addCharacterRangeToCharSet(rECharSet, c, c3);
                }
                bl = false;
                continue;
            }
            if ((rEGlobalData.regexp.flags & 2) != 0) {
                this.addCharacterToCharSet(rECharSet, this.canonicalize(c3));
            }
            this.addCharacterToCharSet(rECharSet, c3);
            if (n >= n2 - 1 || rEGlobalData.regexp.source[n] != '-') continue;
            ++n;
            bl = true;
            c = c3;
        }
        return true;
    }

    private REMatchState classMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n) {
        RECharSet rECharSet = rEGlobalData.regexp.classList[n];
        if (rEMatchState.cp == rEGlobalData.cpend) {
            return null;
        }
        if (!rECharSet.converted) {
            if (!this.processCharSet(rEGlobalData, rECharSet)) {
                return null;
            }
            rECharSet.converted = true;
        }
        char c = rEGlobalData.cpbegin[rEMatchState.cp];
        int n2 = c / 8;
        if (rECharSet.sense ? rECharSet.length == 0 || c > rECharSet.length || (rECharSet.bits[n2] & 1 << (c & 7)) == 0 : rECharSet.length != 0 && c <= rECharSet.length && (rECharSet.bits[n2] & 1 << (c & 7)) != 0) {
            return null;
        }
        ++rEMatchState.cp;
        return rEMatchState;
    }

    private REMatchState executeREBytecode(REGlobalData rEGlobalData, REMatchState rEMatchState) {
        char c;
        int n;
        int n2 = 0;
        byte[] byArray = rEGlobalData.regexp.program;
        int n3 = byArray[n2++];
        REMatchState rEMatchState2 = null;
        boolean bl = false;
        char c2 = '\u0000';
        char[] cArray = rEGlobalData.regexp.source;
        int n4 = 0;
        int n5 = 53;
        switch (n3) {
            case 28: 
            case 35: {
                c2 = (char)this.GET_ARG(n2);
                bl = true;
                break;
            }
            case 22: 
            case 33: {
                c2 = (char)(byArray[n2] & 0xFF);
                bl = true;
                break;
            }
            case 21: 
            case 32: {
                n = this.GET_ARG(n2);
                c2 = cArray[n];
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = false;
            while (rEMatchState.cp < rEGlobalData.cpend) {
                c = rEGlobalData.cpbegin[rEMatchState.cp];
                if (c == c2 || (rEGlobalData.regexp.flags & 2) != 0 && this.canonicalize(c) == this.canonicalize(c2)) {
                    bl = true;
                    break;
                }
                ++rEGlobalData.skipped;
                ++rEMatchState.cp;
            }
            if (!bl) {
                return null;
            }
        }
        block48: while (true) {
            switch (n3) {
                case 0: {
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 2: {
                    RegExpImpl regExpImpl;
                    if (rEMatchState.cp != 0) {
                        regExpImpl = NativeRegExp.getImpl(rEGlobalData.cx);
                        if (regExpImpl.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!this.isLineTerm(rEGlobalData.cpbegin[rEMatchState.cp - 1])) {
                                rEMatchState2 = null;
                                break;
                            }
                        } else {
                            rEMatchState2 = null;
                            break;
                        }
                    }
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 3: {
                    RegExpImpl regExpImpl;
                    if (rEMatchState.cp != rEGlobalData.cpend) {
                        regExpImpl = NativeRegExp.getImpl(rEGlobalData.cx);
                        if (regExpImpl.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!this.isLineTerm(rEGlobalData.cpbegin[rEMatchState.cp])) {
                                rEMatchState2 = null;
                                break;
                            }
                        } else {
                            rEMatchState2 = null;
                            break;
                        }
                    }
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 4: {
                    if ((rEMatchState.cp == 0 || !NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp - 1])) ^ (rEMatchState.cp >= rEGlobalData.cpend || !NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp]))) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 5: {
                    if ((rEMatchState.cp == 0 || !NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp - 1])) ^ (rEMatchState.cp < rEGlobalData.cpend && NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp]))) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 12: {
                    if (rEMatchState.cp != rEGlobalData.cpend && !this.isLineTerm(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 14: {
                    if (rEMatchState.cp != rEGlobalData.cpend && NativeRegExp.isDigit(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 15: {
                    if (rEMatchState.cp != rEGlobalData.cpend && !NativeRegExp.isDigit(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 18: {
                    if (rEMatchState.cp != rEGlobalData.cpend && this.isREWhiteSpace(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 19: {
                    if (rEMatchState.cp != rEGlobalData.cpend && !this.isREWhiteSpace(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 16: {
                    if (rEMatchState.cp != rEGlobalData.cpend && NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 17: {
                    if (rEMatchState.cp != rEGlobalData.cpend && !NativeRegExp.isWord(rEGlobalData.cpbegin[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 21: {
                    int n6 = this.GET_ARG(n2);
                    int n7 = this.GET_ARG(n2 += 2);
                    n2 += 2;
                    rEMatchState2 = this.flatNMatcher(rEGlobalData, rEMatchState, n6, n7);
                    break;
                }
                case 32: {
                    int n6 = this.GET_ARG(n2);
                    int n7 = this.GET_ARG(n2 += 2);
                    n2 += 2;
                    rEMatchState2 = this.flatNIMatcher(rEGlobalData, rEMatchState, n6, n7);
                    break;
                }
                case 22: {
                    c = (char)(byArray[n2++] & 0xFF);
                    rEMatchState2 = this.flatMatcher(rEGlobalData, rEMatchState, c);
                    break;
                }
                case 33: {
                    c = (char)(byArray[n2++] & 0xFF);
                    rEMatchState2 = this.flatIMatcher(rEGlobalData, rEMatchState, c);
                    break;
                }
                case 28: {
                    c = (char)this.GET_ARG(n2);
                    n2 += 2;
                    rEMatchState2 = this.flatMatcher(rEGlobalData, rEMatchState, c);
                    break;
                }
                case 35: {
                    c = (char)this.GET_ARG(n2);
                    n2 += 2;
                    rEMatchState2 = this.flatIMatcher(rEGlobalData, rEMatchState, c);
                    break;
                }
                case 1: {
                    int n8 = n2 + this.GET_OFFSET(n2);
                    byte by = byArray[n8++];
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_pc = n4;
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    this.pushBackTrackState(rEGlobalData, by, n8, rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 23: {
                    --rEGlobalData.stateStackTop;
                    n4 = rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_pc;
                    n5 = rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_op;
                    int n6 = this.GET_OFFSET(n2);
                    n2 += n6;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 10: {
                    int n9 = this.GET_ARG(n2);
                    n2 += 2;
                    rEMatchState.set_parens(n9, rEMatchState.cp, 0);
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 11: {
                    int n9 = this.GET_ARG(n2);
                    n2 += 2;
                    int n10 = rEMatchState.parens_index(n9);
                    rEMatchState.set_parens(n9, n10, rEMatchState.cp - n10);
                    if (n9 > rEGlobalData.lastParen) {
                        rEGlobalData.lastParen = n9;
                    }
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 20: {
                    int n9 = this.GET_ARG(n2);
                    n2 += 2;
                    rEMatchState2 = this.backrefMatcher(rEGlobalData, rEMatchState, n9);
                    break;
                }
                case 41: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    rEProgState.max = rEGlobalData.backTrackStackTop;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    this.pushBackTrackState(rEGlobalData, (byte)43, n2 + this.GET_OFFSET(n2), rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 42: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    rEProgState.max = rEGlobalData.backTrackStackTop;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    this.pushBackTrackState(rEGlobalData, (byte)44, n2 + this.GET_OFFSET(n2), rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 43: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEMatchState.cp = rEProgState.index;
                    rEGlobalData.backTrackStackTop = rEProgState.max;
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    if (rEMatchState2 == null) break;
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 44: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEMatchState.cp = rEProgState.index;
                    rEGlobalData.backTrackStackTop = rEProgState.max;
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    if (rEMatchState2 == null) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 50: {
                    int n11 = this.GET_ARG(n2);
                    n2 += 2;
                    rEMatchState2 = this.classMatcher(rEGlobalData, rEMatchState, n11);
                    if (rEGlobalData.ok) break;
                    return null;
                }
                case 53: {
                    if (rEMatchState == null) break;
                    return rEMatchState;
                }
                case 7: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    this.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 8: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 1;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    this.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 9: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = 1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    this.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 6: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = this.GET_ARG(n2);
                    rEProgState.max = this.GET_ARG(n2 += 2);
                    n2 += 2;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    this.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 49: {
                    n2 = n4;
                    n3 = n5;
                    continue block48;
                }
                case 51: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    if (rEMatchState2 == null) {
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        if (rEProgState.min == 0) {
                            rEMatchState2 = rEMatchState;
                        }
                        n2 += 4;
                        n2 += this.GET_OFFSET(n2);
                        break;
                    }
                    if (rEProgState.min == 0 && rEMatchState.cp == rEProgState.index) {
                        rEMatchState2 = null;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += this.GET_OFFSET(n2);
                        break;
                    }
                    if (rEProgState.min != 0) {
                        --rEProgState.min;
                    }
                    if (rEProgState.max != -1) {
                        --rEProgState.max;
                    }
                    if (rEProgState.max == 0) {
                        rEMatchState2 = rEMatchState;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += this.GET_OFFSET(n2);
                        break;
                    }
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    this.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    int n12 = this.GET_ARG(n2);
                    int n9 = this.GET_ARG(n2 += 2);
                    n2 += 4;
                    n3 = byArray[n2++];
                    n = 0;
                    while (true) {
                        if (n >= n12) continue block48;
                        rEMatchState.set_parens(n9 + n, -1, 0);
                        ++n;
                    }
                }
                case 45: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block48;
                    }
                    this.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += this.GET_OFFSET(n2);
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 46: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 1;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block48;
                    }
                    this.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += this.GET_OFFSET(n2);
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 47: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = 1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block48;
                    }
                    this.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += this.GET_OFFSET(n2);
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 48: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = this.GET_ARG(n2);
                    rEProgState.max = this.GET_ARG(n2 += 2);
                    n2 += 2;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block48;
                    }
                    this.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += this.GET_OFFSET(n2);
                    n3 = byArray[n2++];
                    continue block48;
                }
                case 52: {
                    int n12;
                    int n9;
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    if (rEMatchState2 == null) {
                        if (rEProgState.max == -1 || rEProgState.max > 0) {
                            rEProgState.index = rEMatchState.cp;
                            n5 = 52;
                            n4 = n2;
                            n12 = this.GET_ARG(n2);
                            n9 = this.GET_ARG(n2 += 2);
                            n2 += 4;
                            for (n = 0; n < n12; ++n) {
                                rEMatchState.set_parens(n9 + n, -1, 0);
                            }
                            ++rEGlobalData.stateStackTop;
                            n3 = byArray[n2++];
                            continue block48;
                        }
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        break;
                    }
                    if (rEProgState.min == 0 && rEMatchState.cp == rEProgState.index) {
                        rEMatchState2 = null;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        break;
                    }
                    if (rEProgState.min != 0) {
                        --rEProgState.min;
                    }
                    if (rEProgState.max != -1) {
                        --rEProgState.max;
                    }
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n12 = this.GET_ARG(n2);
                        n9 = this.GET_ARG(n2 += 2);
                        n2 += 4;
                        for (n = 0; n < n12; ++n) {
                            rEMatchState.set_parens(n9 + n, -1, 0);
                        }
                        rEProgState.index = rEMatchState.cp;
                        ++rEGlobalData.stateStackTop;
                        n3 = byArray[n2++];
                        continue block48;
                    }
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    this.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += this.GET_OFFSET(n2);
                    n3 = byArray[n2++];
                    continue block48;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (rEMatchState2 == null) {
                if (rEGlobalData.backTrackStackTop > 0) {
                    --rEGlobalData.backTrackStackTop;
                    REBackTrackData rEBackTrackData = rEGlobalData.backTrackStack[rEGlobalData.backTrackStackTop];
                    rEGlobalData.lastParen = rEBackTrackData.lastParen;
                    rEMatchState = new REMatchState(rEBackTrackData.state);
                    for (n = 0; n < rEBackTrackData.precedingStateTop; ++n) {
                        rEGlobalData.stateStack[n] = rEBackTrackData.precedingState[n];
                    }
                    rEGlobalData.stateStackTop = rEBackTrackData.precedingStateTop + 1;
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1] = rEBackTrackData.currentState;
                    n5 = rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1].continuation_op;
                    n4 = rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1].continuation_pc;
                    n2 = rEBackTrackData.continuation_pc;
                    n3 = rEBackTrackData.continuation_op;
                    continue;
                }
                return null;
            }
            rEMatchState = rEMatchState2;
            if ((n3 = byArray[n2++]) != 49) continue;
            n2 = n4;
            n3 = n5;
        }
    }

    private REMatchState MatchRegExp(REGlobalData rEGlobalData, REMatchState rEMatchState) {
        int n;
        REMatchState rEMatchState2 = null;
        for (int i = n = rEMatchState.cp; i <= rEGlobalData.cpend; ++i) {
            rEGlobalData.skipped = i - n;
            rEMatchState.cp = i;
            for (int j = 0; j < rEMatchState.parenCount; ++j) {
                rEMatchState.set_parens(j, -1, 0);
            }
            rEMatchState2 = this.executeREBytecode(rEGlobalData, rEMatchState);
            rEGlobalData.backTrackStackTop = 0;
            rEGlobalData.stateStackTop = 0;
            if (!rEGlobalData.ok) {
                rEMatchState2 = null;
                return rEMatchState2;
            }
            if (rEMatchState2 == null) continue;
            return rEMatchState2;
        }
        return rEMatchState2;
    }

    private REMatchState initMatch(Context context, REGlobalData rEGlobalData, NativeRegExp nativeRegExp) {
        int n;
        REMatchState rEMatchState = new REMatchState(nativeRegExp.parenCount);
        rEGlobalData.maxBackTrack = 20;
        rEGlobalData.backTrackStack = new REBackTrackData[20];
        for (n = 0; n < 20; ++n) {
            rEGlobalData.backTrackStack[n] = new REBackTrackData(rEMatchState);
        }
        rEGlobalData.backTrackStackTop = 0;
        rEGlobalData.maxStateStack = 20;
        rEGlobalData.stateStack = new REProgState[20];
        for (n = 0; n < 20; ++n) {
            rEGlobalData.stateStack[n] = new REProgState();
        }
        rEGlobalData.stateStackTop = 0;
        rEGlobalData.cx = context;
        rEGlobalData.regexp = nativeRegExp;
        rEGlobalData.ok = true;
        rEGlobalData.lastParen = 0;
        return rEMatchState;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        int n3;
        REGlobalData rEGlobalData = new REGlobalData();
        NativeRegExp nativeRegExp = this;
        int n4 = nArray[0];
        char[] cArray = string.toCharArray();
        int n5 = cArray.length;
        if (n4 > n5) {
            n4 = n5;
        }
        int n6 = 0;
        rEGlobalData.cpbegin = cArray;
        rEGlobalData.cpend = n6 + n5;
        rEGlobalData.start = n4;
        rEGlobalData.skipped = 0;
        REMatchState rEMatchState = this.initMatch(context, rEGlobalData, nativeRegExp);
        rEMatchState.cp = n6 += n4;
        REMatchState rEMatchState2 = this.MatchRegExp(rEGlobalData, rEMatchState);
        if (rEMatchState2 == null) {
            if (n != 2) {
                return null;
            }
            return Undefined.instance;
        }
        nArray[0] = n3 = (n2 = rEMatchState2.cp);
        int n7 = n3 - (n4 + rEGlobalData.skipped);
        int n8 = n2;
        n2 -= n7;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = NativeRegExp.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n2, n7);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (rEMatchState2.parenCount > nativeRegExp.parenCount) {
            throw new RuntimeException();
        }
        if (rEMatchState2.parenCount == 0) {
            regExpImpl.parens.clear();
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens.setSize(nativeRegExp.parenCount);
            for (int i = 0; i < nativeRegExp.parenCount; ++i) {
                int n9 = rEMatchState2.parens_index(i);
                if (n9 != -1) {
                    int n10 = rEMatchState2.parens_length(i);
                    object = new SubString(rEGlobalData.cpbegin, n9, n10);
                    regExpImpl.parens.set(i, object);
                    if (n == 0) continue;
                    String string3 = ((SubString)object).toString();
                    scriptable2.put(i + 1, scriptable2, (Object)string3);
                    continue;
                }
                if (n == 0) continue;
                scriptable2.put(i + 1, scriptable2, (Object)Undefined.instance);
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n4 + rEGlobalData.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n2;
        regExpImpl.lastMatch.length = n7;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n4;
            regExpImpl.leftContext.length = rEGlobalData.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n4 + rEGlobalData.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n8;
        regExpImpl.rightContext.length = rEGlobalData.cpend - n8;
        return object2;
    }

    public byte getFlags() {
        return this.flags;
    }

    private void reportError(String string, String string2, CompilerState compilerState) {
        Object[] objectArray = new Object[]{string2};
        throw NativeGlobal.constructError(compilerState.cx, "SyntaxError", ScriptRuntime.getMessage(string, objectArray), compilerState.scope);
    }

    protected int getIdDefaultAttributes(int n) {
        switch (n) {
            case 1: {
                return 6;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 7;
            }
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.wrap_double(this.lastIndex);
            }
            case 2: {
                return new String(this.source);
            }
            case 3: {
                return this.wrap_boolean((this.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.flags & 4) != 0);
            }
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.setLastIndex(ScriptRuntime.toNumber(object));
            return;
        }
        super.setIdValue(n, object);
    }

    void setLastIndex(double d) {
        this.lastIndex = d;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return this.realThis(scriptable2, idFunction, false).compile(context, scriptable, objectArray);
                }
                case 7: {
                    return this.realThis(scriptable2, idFunction, true).toString();
                }
                case 8: {
                    return this.realThis(scriptable2, idFunction, false).exec(context, scriptable, objectArray);
                }
                case 9: {
                    return this.realThis(scriptable2, idFunction, false).test(context, scriptable, objectArray);
                }
                case 10: {
                    return this.realThis(scriptable2, idFunction, false).prefix(context, scriptable, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeRegExp realThis(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeRegExp)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeRegExp)scriptable;
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "exec";
                }
                case 9: {
                    return "test";
                }
                case 10: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        char c;
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n = 3;
            } else if (c == 's') {
                string2 = "source";
                n = 2;
            }
        } else if (n2 == 9) {
            c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n = 5;
            }
        } else if (n2 == 10) {
            string2 = "ignoreCase";
            n = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        switch (string.length()) {
            case 4: {
                c = string.charAt(0);
                if (c == 'e') {
                    string2 = "exec";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string2 = "test";
                n = 9;
                break;
            }
            case 6: {
                string2 = "prefix";
                n = 10;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 6;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 7;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

