/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.TokenStream;

class Parser {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private int functionNumber;
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final int TOP_LEVEL_SCRIPT_OR_FUNCTION = 0;
    private static final int CONSTRUCTED_FUNCTION = 1;
    private static final int NESTED_FUNCTION = 2;
    private static final boolean printSource = false;

    public Parser(IRFactory iRFactory) {
        this.nf = iRFactory;
    }

    private void mustMatchToken(TokenStream tokenStream, int n, String string) throws IOException, JavaScriptException {
        int n2 = tokenStream.getToken();
        if (n2 != n) {
            this.reportError(tokenStream, string);
            tokenStream.ungetToken(n2);
        }
    }

    private void reportError(TokenStream tokenStream, String string) throws JavaScriptException {
        this.ok = false;
        tokenStream.reportSyntaxError(string, null);
        throw new JavaScriptException((Object)string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parse(TokenStream tokenStream) throws IOException {
        this.ok = true;
        this.sourceTop = 0;
        this.functionNumber = 0;
        int n = tokenStream.getLineno();
        Object object = this.nf.createLeaf(133);
        this.sourceAdd('\u0092');
        while (true) {
            tokenStream.flags |= 0x10;
            int n2 = tokenStream.getToken();
            tokenStream.flags &= ~16;
            if (n2 <= 0) break;
            if (n2 == 110) {
                try {
                    this.nf.addChildToBack(object, this.function(tokenStream, false));
                    continue;
                }
                catch (JavaScriptException javaScriptException) {
                    this.ok = false;
                    break;
                }
            }
            tokenStream.ungetToken(n2);
            this.nf.addChildToBack(object, this.statement(tokenStream));
        }
        if (!this.ok) {
            return null;
        }
        String string = this.sourceToString(0);
        this.sourceBuffer = null;
        return this.nf.createScript(object, tokenStream.getSourceName(), n, tokenStream.getLineno(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseFunctionBody(TokenStream tokenStream) throws IOException {
        int n = tokenStream.flags;
        tokenStream.flags &= 0xFFFFFFF3;
        tokenStream.flags |= 2;
        Object object = this.nf.createBlock(tokenStream.getLineno());
        try {
            while (true) {
                int n2 = tokenStream.peekToken();
                if (n2 > 0) {
                    if (n2 != 93) {
                        if (n2 == 110) {
                            tokenStream.getToken();
                            this.nf.addChildToBack(object, this.function(tokenStream, false));
                            continue;
                        }
                        this.nf.addChildToBack(object, this.statement(tokenStream));
                        continue;
                    }
                }
                break;
            }
        }
        catch (JavaScriptException javaScriptException) {
            this.ok = false;
        }
        finally {
            tokenStream.flags = n;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object function(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        String string;
        Object object;
        Object object2;
        String string2;
        int n = tokenStream.getLineno();
        Object object3 = null;
        if (tokenStream.matchToken(44)) {
            string2 = tokenStream.getString();
            if (!tokenStream.matchToken(94)) {
                if (Context.getContext().hasFeature(2)) {
                    this.sourceAddString(44, string2);
                    Object object4 = this.nf.createName(string2);
                    string2 = null;
                    object3 = this.memberExprTail(tokenStream, false, object4);
                }
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.parms");
            }
        } else if (tokenStream.matchToken(94)) {
            string2 = null;
        } else {
            string2 = null;
            if (Context.getContext().hasFeature(2)) {
                object3 = this.memberExpr(tokenStream, false);
            }
            this.mustMatchToken(tokenStream, 94, "msg.no.paren.parms");
        }
        if (object3 != null) {
            this.sourceAdd('a');
            this.sourceAdd('\u0080');
        }
        this.sourceAdd('n');
        this.sourceAdd((char)this.functionNumber);
        ++this.functionNumber;
        int n2 = this.sourceTop;
        int n3 = this.functionNumber;
        try {
            this.functionNumber = 0;
            this.sourceAdd('n');
            if (string2 != null) {
                this.sourceAddString(44, string2);
            }
            this.sourceAdd('^');
            object2 = this.nf.createLeaf(94);
            if (!tokenStream.matchToken(95)) {
                boolean bl2 = true;
                do {
                    if (!bl2) {
                        this.sourceAdd('`');
                    }
                    bl2 = false;
                    this.mustMatchToken(tokenStream, 44, "msg.no.parm");
                    String string3 = tokenStream.getString();
                    this.nf.addChildToBack(object2, this.nf.createName(string3));
                    this.sourceAddString(44, string3);
                } while (tokenStream.matchToken(96));
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.parms");
            }
            this.sourceAdd('_');
            this.mustMatchToken(tokenStream, 92, "msg.no.brace.body");
            this.sourceAdd('\\');
            this.sourceAdd('\u0001');
            object = this.parseFunctionBody(tokenStream);
            this.mustMatchToken(tokenStream, 93, "msg.no.brace.after.body");
            this.sourceAdd(']');
            string = this.sourceToString(n2);
        }
        finally {
            this.sourceTop = n2;
            this.functionNumber = n3;
        }
        Object object5 = this.nf.createFunction(string2, object2, object, tokenStream.getSourceName(), n, tokenStream.getLineno(), string, bl || object3 != null);
        if (object3 != null) {
            object5 = this.nf.createBinary(97, 128, object3, object5);
        }
        if (!bl) {
            if (object3 != null) {
                this.sourceAdd('Y');
            }
            this.sourceAdd('\u0001');
            this.wellTerminated(tokenStream, 110);
        }
        return object5;
    }

    private Object statements(TokenStream tokenStream) throws IOException {
        Object object = this.nf.createBlock(tokenStream.getLineno());
        while (true) {
            int n = tokenStream.peekToken();
            if (n <= 0) break;
            if (n == 93) break;
            this.nf.addChildToBack(object, this.statement(tokenStream));
        }
        return object;
    }

    private Object condition(TokenStream tokenStream) throws IOException, JavaScriptException {
        this.mustMatchToken(tokenStream, 94, "msg.no.paren.cond");
        this.sourceAdd('^');
        Object object = this.expr(tokenStream, false);
        this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.cond");
        this.sourceAdd('_');
        return object;
    }

    private boolean wellTerminated(TokenStream tokenStream, int n) throws IOException, JavaScriptException {
        block5: {
            block7: {
                int n2;
                block6: {
                    int n3 = tokenStream.peekTokenSameLine();
                    if (n3 == -1) {
                        return false;
                    }
                    if (n3 == 0) break block5;
                    if (n3 == 1) break block5;
                    if (n3 == 89) break block5;
                    if (n3 == 93) break block5;
                    n2 = Context.getContext().getLanguageVersion();
                    if (n3 == 110) break block6;
                    if (n != 110) break block7;
                }
                if (n2 < 120) {
                    return true;
                }
            }
            this.reportError(tokenStream, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n = tokenStream.getLineno();
        String string = null;
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == 44) {
            tokenStream.getToken();
            string = tokenStream.getString();
        }
        if (n == tokenStream.getLineno()) {
            this.wellTerminated(tokenStream, -1);
        }
        return string;
    }

    private Object statement(TokenStream tokenStream) throws IOException {
        try {
            return this.statementHelper(tokenStream);
        }
        catch (JavaScriptException javaScriptException) {
            int n;
            int n2 = tokenStream.getLineno();
            while ((n = tokenStream.getToken()) != 89 && n != 1 && n != 0 && n != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object statementHelper(TokenStream var1_1) throws IOException, JavaScriptException {
        var2_2 = null;
        var3_3 = false;
        var5_4 = 0;
        var4_5 = var1_1.getToken();
        switch (var4_5) {
            case 113: {
                var3_3 = true;
                this.sourceAdd('q');
                var6_6 = var1_1.getLineno();
                var7_19 = this.condition(var1_1);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var8_30 = this.statement(var1_1);
                var9_37 = null;
                if (var1_1.matchToken(114)) {
                    this.sourceAdd(']');
                    this.sourceAdd('r');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    var9_37 = this.statement(var1_1);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                var2_2 = this.nf.createIf(var7_19, var8_30, var9_37, var6_6);
                break;
            }
            case 115: {
                var3_3 = true;
                this.sourceAdd('s');
                var2_2 = this.nf.createSwitch(var1_1.getLineno());
                var6_7 = null;
                this.mustMatchToken(var1_1, 94, "msg.no.paren.switch");
                this.sourceAdd('^');
                this.nf.addChildToBack(var2_2, this.expr(var1_1, false));
                this.mustMatchToken(var1_1, 95, "msg.no.paren.after.switch");
                this.sourceAdd('_');
                this.mustMatchToken(var1_1, 92, "msg.no.brace.switch");
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                while (true) {
                    var4_5 = var1_1.getToken();
                    if (var4_5 == 93) break;
                    if (var4_5 == 0) break;
                    switch (var4_5) {
                        case 116: {
                            this.sourceAdd('t');
                            var6_7 = this.nf.createUnary(116, this.expr(var1_1, false));
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        case 117: {
                            var6_7 = this.nf.createLeaf(117);
                            this.sourceAdd('u');
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        default: {
                            this.reportError(var1_1, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(var1_1, 99, "msg.no.colon.case");
                    var7_20 = this.nf.createLeaf(133);
                    while (true) {
                        var4_5 = var1_1.peekToken();
                        if (var4_5 == 93) break;
                        if (var4_5 == 116) break;
                        if (var4_5 == 117) break;
                        if (var4_5 == 0) break;
                        this.nf.addChildToBack(var7_20, this.statement(var1_1));
                    }
                    this.nf.addChildToBack(var6_7, var7_20);
                    this.nf.addChildToBack(var2_2, var6_7);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                break;
            }
            case 118: {
                var3_3 = true;
                this.sourceAdd('v');
                var6_8 = var1_1.getLineno();
                var7_21 = this.condition(var1_1);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var8_31 = this.statement(var1_1);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                var2_2 = this.nf.createWhile(var7_21, var8_31, var6_8);
                break;
            }
            case 119: {
                this.sourceAdd('w');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var6_9 = var1_1.getLineno();
                var7_22 = this.statement(var1_1);
                this.sourceAdd(']');
                this.mustMatchToken(var1_1, 118, "msg.no.while.do");
                this.sourceAdd('v');
                var8_32 = this.condition(var1_1);
                var2_2 = this.nf.createDoWhile(var7_22, var8_32, var6_9);
                break;
            }
            case 120: {
                var3_3 = true;
                this.sourceAdd('x');
                var6_10 = var1_1.getLineno();
                var9_38 = null;
                this.mustMatchToken(var1_1, 94, "msg.no.paren.for");
                this.sourceAdd('^');
                var4_5 = var1_1.peekToken();
                if (var4_5 == 89) {
                    var7_23 = this.nf.createLeaf(132);
                } else if (var4_5 == 123) {
                    var1_1.getToken();
                    var7_23 = this.variables(var1_1, true);
                } else {
                    var7_23 = this.expr(var1_1, true);
                }
                var4_5 = var1_1.peekToken();
                if (var4_5 != 103) ** GOTO lbl-1000
                if (var1_1.getOp() == 63) {
                    var1_1.matchToken(103);
                    this.sourceAdd('?');
                    var8_33 = this.expr(var1_1, false);
                } else lbl-1000:
                // 2 sources

                {
                    this.mustMatchToken(var1_1, 89, "msg.no.semi.for");
                    this.sourceAdd('Y');
                    var8_33 = var1_1.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(var1_1, false);
                    this.mustMatchToken(var1_1, 89, "msg.no.semi.for.cond");
                    this.sourceAdd('Y');
                    var9_38 = var1_1.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(var1_1, false);
                }
                this.mustMatchToken(var1_1, 95, "msg.no.paren.for.ctrl");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var10_40 = this.statement(var1_1);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                if (var9_38 == null) {
                    var2_2 = this.nf.createForIn(var7_23, var8_33, var10_40, var6_10);
                    break;
                }
                var2_2 = this.nf.createFor(var7_23, var8_33, var9_38, var10_40, var6_10);
                break;
            }
            case 75: {
                var6_11 = var1_1.getLineno();
                var8_34 = null;
                var9_39 = null;
                var3_3 = true;
                this.sourceAdd('K');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var7_24 = this.statement(var1_1);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                var8_34 = this.nf.createLeaf(133);
                var10_41 = false;
                var11_42 = var1_1.peekToken();
                if (var11_42 == 125) {
                    while (true) {
                        if (var1_1.matchToken(125)) {
                            if (var10_41) {
                                this.reportError(var1_1, "msg.catch.unreachable");
                            }
                            this.sourceAdd('}');
                            this.mustMatchToken(var1_1, 94, "msg.no.paren.catch");
                            this.sourceAdd('^');
                            this.mustMatchToken(var1_1, 44, "msg.bad.catchcond");
                            var12_43 = var1_1.getString();
                            this.sourceAddString(44, var12_43);
                            var13_44 = null;
                            if (var1_1.matchToken(113)) {
                                this.sourceAdd('q');
                                var13_44 = this.expr(var1_1, false);
                            } else {
                                var10_41 = true;
                            }
                            this.mustMatchToken(var1_1, 95, "msg.bad.catchcond");
                            this.sourceAdd('_');
                            this.mustMatchToken(var1_1, 92, "msg.no.brace.catchblock");
                            this.sourceAdd('\\');
                            this.sourceAdd('\u0001');
                            this.nf.addChildToBack(var8_34, this.nf.createCatch(var12_43, var13_44, this.statements(var1_1), var1_1.getLineno()));
                            this.mustMatchToken(var1_1, 93, "msg.no.brace.after.body");
                            this.sourceAdd(']');
                            this.sourceAdd('\u0001');
                            continue;
                        }
                        break;
                    }
                } else if (var11_42 != 126) {
                    this.mustMatchToken(var1_1, 126, "msg.try.no.catchfinally");
                }
                if (var1_1.matchToken(126)) {
                    this.sourceAdd('~');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    var9_39 = this.statement(var1_1);
                    this.sourceAdd(']');
                    this.sourceAdd('\u0001');
                }
                var2_2 = this.nf.createTryCatchFinally(var7_24, var8_34, var9_39, var6_11);
                break;
            }
            case 62: {
                var6_12 = var1_1.getLineno();
                this.sourceAdd('>');
                var2_2 = this.nf.createThrow(this.expr(var1_1, false), var6_12);
                if (var6_12 != var1_1.getLineno()) break;
                this.wellTerminated(var1_1, -1);
                break;
            }
            case 121: {
                var6_13 = var1_1.getLineno();
                this.sourceAdd('y');
                var7_25 = this.matchLabel(var1_1);
                if (var7_25 != null) {
                    this.sourceAddString(44, var7_25);
                }
                var2_2 = this.nf.createBreak(var7_25, var6_13);
                break;
            }
            case 122: {
                var6_14 = var1_1.getLineno();
                this.sourceAdd('z');
                var7_26 = this.matchLabel(var1_1);
                if (var7_26 != null) {
                    this.sourceAddString(44, var7_26);
                }
                var2_2 = this.nf.createContinue(var7_26, var6_14);
                break;
            }
            case 124: {
                var3_3 = true;
                this.sourceAdd('|');
                var6_15 = var1_1.getLineno();
                this.mustMatchToken(var1_1, 94, "msg.no.paren.with");
                this.sourceAdd('^');
                var7_27 = this.expr(var1_1, false);
                this.mustMatchToken(var1_1, 95, "msg.no.paren.after.with");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                var8_35 = this.statement(var1_1);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                var2_2 = this.nf.createWith(var7_27, var8_35, var6_15);
                break;
            }
            case 123: {
                var6_16 = var1_1.getLineno();
                var2_2 = this.variables(var1_1, false);
                if (var1_1.getLineno() != var6_16) break;
                this.wellTerminated(var1_1, -1);
                break;
            }
            case 5: {
                var6_17 = null;
                this.sourceAdd('\u0005');
                if ((var1_1.flags & 2) == 0) {
                    this.reportError(var1_1, "msg.bad.return");
                }
                var1_1.flags |= 16;
                var4_5 = var1_1.peekTokenSameLine();
                var1_1.flags &= ~16;
                var7_28 = var1_1.getLineno();
                if (var4_5 == 0) ** GOTO lbl-1000
                if (var4_5 == 1) ** GOTO lbl-1000
                if (var4_5 == 89) ** GOTO lbl-1000
                if (var4_5 != 93) {
                    var6_17 = this.expr(var1_1, false);
                    if (var1_1.getLineno() == var7_28) {
                        this.wellTerminated(var1_1, -1);
                    }
                    var1_1.flags |= 4;
                } else lbl-1000:
                // 4 sources

                {
                    var1_1.flags |= 8;
                }
                var2_2 = this.nf.createReturn(var6_17, var7_28);
                break;
            }
            case 92: {
                var3_3 = true;
                var2_2 = this.statements(var1_1);
                this.mustMatchToken(var1_1, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                var2_2 = this.nf.createLeaf(132);
                var3_3 = true;
                break;
            }
            default: {
                var5_4 = var4_5;
                var6_18 = var1_1.getTokenno();
                var1_1.ungetToken(var4_5);
                var7_29 = var1_1.getLineno();
                var2_2 = this.expr(var1_1, false);
                if (var1_1.peekToken() == 99) {
                    if (var5_4 != 44 || var1_1.getTokenno() != var6_18) {
                        this.reportError(var1_1, "msg.bad.label");
                    }
                    var1_1.getToken();
                    var8_36 = var1_1.getString();
                    var2_2 = this.nf.createLabel(var8_36, var7_29);
                    this.sourceAdd('c');
                    this.sourceAdd('\u0001');
                    return var2_2;
                }
                if (var5_4 == 110) {
                    if (this.nf.getLeafType(var2_2) != 110) {
                        this.reportError(var1_1, "msg.syntax");
                    }
                    this.nf.setFunctionExpressionStatement(var2_2);
                }
                var2_2 = this.nf.createExprStatement(var2_2, var7_29);
                if (var1_1.getLineno() != var7_29) {
                    if (var5_4 != 110 || var1_1.getLineno() != this.lastExprEndLine) break;
                }
                this.wellTerminated(var1_1, var5_4);
            }
        }
        var1_1.matchToken(89);
        if (!var3_3) {
            this.sourceAdd('Y');
            this.sourceAdd('\u0001');
        }
        return var2_2;
    }

    private Object variables(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.nf.createVariables(tokenStream.getLineno());
        boolean bl2 = true;
        this.sourceAdd('{');
        do {
            this.mustMatchToken(tokenStream, 44, "msg.bad.var");
            String string = tokenStream.getString();
            if (!bl2) {
                this.sourceAdd('`');
            }
            bl2 = false;
            this.sourceAddString(44, string);
            Object object2 = this.nf.createName(string);
            if (tokenStream.matchToken(97)) {
                if (tokenStream.getOp() != 128) {
                    this.reportError(tokenStream, "msg.bad.var.init");
                }
                this.sourceAdd('a');
                this.sourceAdd('\u0080');
                Object object3 = this.assignExpr(tokenStream, bl);
                this.nf.addChildToBack(object2, object3);
            }
            this.nf.addChildToBack(object, object2);
        } while (tokenStream.matchToken(96));
        return object;
    }

    private Object expr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.assignExpr(tokenStream, bl);
        while (true) {
            if (!tokenStream.matchToken(96)) break;
            this.sourceAdd('`');
            object = this.nf.createBinary(96, object, this.assignExpr(tokenStream, bl));
        }
        return object;
    }

    private Object assignExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.condExpr(tokenStream, bl);
        if (tokenStream.matchToken(97)) {
            this.sourceAdd('a');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(97, tokenStream.getOp(), object, this.assignExpr(tokenStream, bl));
        }
        return object;
    }

    private Object condExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.orExpr(tokenStream, bl);
        if (tokenStream.matchToken(98)) {
            this.sourceAdd('b');
            Object object2 = this.assignExpr(tokenStream, false);
            this.mustMatchToken(tokenStream, 99, "msg.no.colon.cond");
            this.sourceAdd('c');
            Object object3 = this.assignExpr(tokenStream, bl);
            return this.nf.createTernary(object, object2, object3);
        }
        return object;
    }

    private Object orExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.andExpr(tokenStream, bl);
        if (tokenStream.matchToken(100)) {
            this.sourceAdd('d');
            object = this.nf.createBinary(100, object, this.orExpr(tokenStream, bl));
        }
        return object;
    }

    private Object andExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitOrExpr(tokenStream, bl);
        if (tokenStream.matchToken(101)) {
            this.sourceAdd('e');
            object = this.nf.createBinary(101, object, this.andExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitOrExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitXorExpr(tokenStream, bl);
        while (true) {
            if (!tokenStream.matchToken(11)) break;
            this.sourceAdd('\u000b');
            object = this.nf.createBinary(11, object, this.bitXorExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitXorExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitAndExpr(tokenStream, bl);
        while (true) {
            if (!tokenStream.matchToken(12)) break;
            this.sourceAdd('\f');
            object = this.nf.createBinary(12, object, this.bitAndExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitAndExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.eqExpr(tokenStream, bl);
        while (true) {
            if (!tokenStream.matchToken(13)) break;
            this.sourceAdd('\r');
            object = this.nf.createBinary(13, object, this.eqExpr(tokenStream, bl));
        }
        return object;
    }

    private Object eqExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.relExpr(tokenStream, bl);
        while (true) {
            if (!tokenStream.matchToken(102)) break;
            this.sourceAdd('f');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(102, tokenStream.getOp(), object, this.relExpr(tokenStream, bl));
        }
        return object;
    }

    private Object relExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.shiftExpr(tokenStream);
        while (true) {
            if (!tokenStream.matchToken(103)) break;
            int n = tokenStream.getOp();
            if (bl) {
                if (n == 63) {
                    tokenStream.ungetToken(103);
                    break;
                }
            }
            this.sourceAdd('g');
            this.sourceAdd((char)n);
            object = this.nf.createBinary(103, n, object, this.shiftExpr(tokenStream));
        }
        return object;
    }

    private Object shiftExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        Object object = this.addExpr(tokenStream);
        while (true) {
            if (!tokenStream.matchToken(104)) break;
            this.sourceAdd('h');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(tokenStream.getOp(), object, this.addExpr(tokenStream));
        }
        return object;
    }

    private Object addExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n;
        Object object = this.mulExpr(tokenStream);
        while (true) {
            n = tokenStream.getToken();
            if (n != 23) {
                if (n != 24) break;
            }
            this.sourceAdd((char)n);
            object = this.nf.createBinary(n, object, this.mulExpr(tokenStream));
        }
        tokenStream.ungetToken(n);
        return object;
    }

    private Object mulExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        Object object = this.unaryExpr(tokenStream);
        while (true) {
            int n = tokenStream.peekToken();
            if (n != 25) {
                if (n != 26) {
                    if (n != 27) break;
                }
            }
            n = tokenStream.getToken();
            this.sourceAdd((char)n);
            object = this.nf.createBinary(n, object, this.unaryExpr(tokenStream));
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object unaryExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= ~16;
        switch (n) {
            case 105: {
                this.sourceAdd('i');
                this.sourceAdd((char)tokenStream.getOp());
                return this.nf.createUnary(105, tokenStream.getOp(), this.unaryExpr(tokenStream));
            }
            case 23: 
            case 24: {
                this.sourceAdd('i');
                this.sourceAdd((char)n);
                return this.nf.createUnary(105, n, this.unaryExpr(tokenStream));
            }
            case 106: 
            case 107: {
                this.sourceAdd((char)n);
                return this.nf.createUnary(n, 130, this.memberExpr(tokenStream, true));
            }
            case 31: {
                this.sourceAdd('\u001f');
                return this.nf.createUnary(31, this.unaryExpr(tokenStream));
            }
            case -1: {
                return this.nf.createName("err");
            }
            default: {
                tokenStream.ungetToken(n);
                int n2 = tokenStream.getLineno();
                Object object = this.memberExpr(tokenStream, true);
                int n3 = tokenStream.peekToken();
                if (n3 != 106) {
                    if (n3 != 107) return object;
                }
                if (tokenStream.getLineno() != n2) return object;
                int n4 = tokenStream.getToken();
                this.sourceAdd((char)n4);
                return this.nf.createUnary(n4, 131, object);
            }
        }
    }

    private Object argumentList(TokenStream tokenStream, Object object) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        boolean bl = tokenStream.matchToken(95);
        tokenStream.flags &= ~16;
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.sourceAdd('`');
                }
                bl2 = false;
                this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
            } while (tokenStream.matchToken(96));
            this.mustMatchToken(tokenStream, 95, "msg.no.paren.arg");
        }
        this.sourceAdd('_');
        return object;
    }

    private Object memberExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object;
        tokenStream.flags |= 0x10;
        int n = tokenStream.peekToken();
        tokenStream.flags &= ~16;
        if (n == 30) {
            tokenStream.getToken();
            this.sourceAdd('\u001e');
            object = this.nf.createLeaf(30);
            this.nf.addChildToBack(object, this.memberExpr(tokenStream, false));
            if (tokenStream.matchToken(94)) {
                this.sourceAdd('^');
                object = this.argumentList(tokenStream, object);
            }
            n = tokenStream.peekToken();
            if (n == 92) {
                this.nf.addChildToBack(object, this.primaryExpr(tokenStream));
            }
        } else {
            object = this.primaryExpr(tokenStream);
        }
        return this.memberExprTail(tokenStream, bl, object);
    }

    private Object memberExprTail(TokenStream tokenStream, boolean bl, Object object) throws IOException, JavaScriptException {
        block3: {
            int n;
            this.lastExprEndLine = tokenStream.getLineno();
            while (true) {
                n = tokenStream.getToken();
                if (n <= 0) break block3;
                if (n == 108) {
                    this.sourceAdd('l');
                    this.mustMatchToken(tokenStream, 44, "msg.no.name.after.dot");
                    String string = tokenStream.getString();
                    this.sourceAddString(44, string);
                    object = this.nf.createBinary(108, object, this.nf.createName(tokenStream.getString()));
                    this.lastExprEndLine = tokenStream.getLineno();
                    continue;
                }
                if (n == 90) {
                    this.sourceAdd('Z');
                    object = this.nf.createBinary(90, object, this.expr(tokenStream, false));
                    this.mustMatchToken(tokenStream, 91, "msg.no.bracket.index");
                    this.sourceAdd('[');
                    this.lastExprEndLine = tokenStream.getLineno();
                    continue;
                }
                if (!bl) break;
                if (n != 94) break;
                object = this.nf.createUnary(43, object);
                this.sourceAdd('^');
                object = this.argumentList(tokenStream, object);
                this.lastExprEndLine = tokenStream.getLineno();
            }
            tokenStream.ungetToken(n);
        }
        return object;
    }

    private Object primaryExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= ~16;
        switch (n) {
            case 110: {
                return this.function(tokenStream, true);
            }
            case 90: {
                this.sourceAdd('Z');
                Object object = this.nf.createLeaf(134);
                tokenStream.flags |= 0x10;
                boolean bl = tokenStream.matchToken(91);
                tokenStream.flags &= ~16;
                if (!bl) {
                    boolean bl2 = true;
                    do {
                        tokenStream.flags |= 0x10;
                        n = tokenStream.peekToken();
                        tokenStream.flags &= ~16;
                        if (!bl2) {
                            this.sourceAdd('`');
                        } else {
                            bl2 = false;
                        }
                        if (n == 91) break;
                        if (n == 96) {
                            this.nf.addChildToBack(object, this.nf.createLeaf(109, 74));
                        } else {
                            this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
                        }
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 91, "msg.no.bracket.arg");
                }
                this.sourceAdd('[');
                return this.nf.createArrayLiteral(object);
            }
            case 92: {
                Object object = this.nf.createLeaf(135);
                this.sourceAdd('\\');
                if (!tokenStream.matchToken(93)) {
                    boolean bl = true;
                    block19: do {
                        Object object2;
                        if (!bl) {
                            this.sourceAdd('`');
                        } else {
                            bl = false;
                        }
                        n = tokenStream.getToken();
                        switch (n) {
                            case 44: 
                            case 46: {
                                String string = tokenStream.getString();
                                this.sourceAddString(44, string);
                                object2 = this.nf.createString(tokenStream.getString());
                                break;
                            }
                            case 45: {
                                double d = tokenStream.getNumber();
                                this.sourceAddNumber(d);
                                object2 = this.nf.createNumber(d);
                                break;
                            }
                            case 93: {
                                tokenStream.ungetToken(n);
                                break block19;
                            }
                            default: {
                                this.reportError(tokenStream, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(tokenStream, 99, "msg.no.colon.prop");
                        this.sourceAdd('\u0087');
                        this.nf.addChildToBack(object, object2);
                        this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 93, "msg.no.brace.prop");
                }
                this.sourceAdd(']');
                return this.nf.createObjectLiteral(object);
            }
            case 94: {
                this.sourceAdd('^');
                Object object = this.expr(tokenStream, false);
                this.sourceAdd('_');
                this.mustMatchToken(tokenStream, 95, "msg.no.paren");
                return object;
            }
            case 44: {
                String string = tokenStream.getString();
                this.sourceAddString(44, string);
                return this.nf.createName(string);
            }
            case 45: {
                double d = tokenStream.getNumber();
                this.sourceAddNumber(d);
                return this.nf.createNumber(d);
            }
            case 46: {
                String string = tokenStream.getString();
                this.sourceAddString(46, string);
                return this.nf.createString(string);
            }
            case 56: {
                String string = tokenStream.regExpFlags;
                tokenStream.regExpFlags = null;
                String string2 = tokenStream.getString();
                this.sourceAddString(56, '/' + string2 + '/' + string);
                return this.nf.createRegExp(string2, string);
            }
            case 109: {
                this.sourceAdd('m');
                this.sourceAdd((char)tokenStream.getOp());
                return this.nf.createLeaf(109, tokenStream.getOp());
            }
            case 127: {
                this.reportError(tokenStream, "msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(tokenStream, "msg.syntax");
            }
        }
        return null;
    }

    private void sourceAdd(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void sourceAddString(int n, String string) {
        this.sourceAdd((char)n);
        this.sourceAddString(string);
    }

    private void sourceAddString(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        if (n2 >= 32768) {
            n3 = 2;
        }
        if ((n = this.sourceTop + n3 + n2) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(n);
        }
        if (n2 >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | n2 >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)n2;
        ++this.sourceTop;
        string.getChars(0, n2, this.sourceBuffer, this.sourceTop);
        this.sourceTop = n;
    }

    private void sourceAddNumber(double d) {
        this.sourceAdd('-');
        long l = (long)d;
        if ((double)l != d) {
            l = Double.doubleToLongBits(d);
            this.sourceAdd('D');
            this.sourceAdd((char)(l >> 48));
            this.sourceAdd((char)(l >> 32));
            this.sourceAdd((char)(l >> 16));
            this.sourceAdd((char)l);
        } else {
            if (l < 0L) {
                Context.codeBug();
            }
            if (l <= 65535L) {
                this.sourceAdd('S');
                this.sourceAdd((char)l);
            } else {
                this.sourceAdd('J');
                this.sourceAdd((char)(l >> 48));
                this.sourceAdd((char)(l >> 32));
                this.sourceAdd((char)(l >> 16));
                this.sourceAdd((char)l);
            }
        }
    }

    private void increaseSourceCapacity(int n) {
        int n2;
        if (n <= this.sourceBuffer.length) {
            Context.codeBug();
        }
        if ((n2 = this.sourceBuffer.length * 2) < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceTop);
        this.sourceBuffer = cArray;
    }

    private String sourceToString(int n) {
        if (n < 0 || this.sourceTop < n) {
            Context.codeBug();
        }
        return new String(this.sourceBuffer, n, this.sourceTop - n);
    }

    static String decompile(Object object, boolean bl, int n, int n2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[1];
        int n3 = bl ? 1 : 0;
        Parser.decompile_r(object, n, n2, n3, bl2, objectArray, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void decompile_r(Object object, int n, int n2, int n3, boolean bl, Object[] objectArray, StringBuffer stringBuffer) {
        int n4;
        int n5;
        String string;
        Object[] objectArray2;
        block141: {
            char c;
            block140: {
                block139: {
                    objectArray2 = null;
                    if (object == null) {
                        return;
                    }
                    if (object instanceof String) {
                        string = (String)object;
                    } else {
                        objectArray2 = (Object[])object;
                        string = (String)objectArray2[0];
                    }
                    if (string == null) {
                        return;
                    }
                    n5 = string.length();
                    if (n5 == 0) {
                        return;
                    }
                    if (n3 != 2) {
                        if (!bl) {
                            stringBuffer.append('\n');
                        }
                        for (n4 = 0; n4 < n2; ++n4) {
                            stringBuffer.append(' ');
                        }
                    }
                    n4 = 0;
                    c = string.charAt(n4);
                    ++n4;
                    if (c != 'n') break block139;
                    if (bl) break block140;
                    stringBuffer.append("function ");
                    if (string.charAt(n4) == '^' && n != 120 && n3 == 1) {
                        stringBuffer.append("anonymous");
                    }
                    break block141;
                }
                if (c != '\u0092') {
                    throw new RuntimeException();
                }
                break block141;
            }
            block112: while (true) {
                c = string.charAt(n4);
                ++n4;
                switch (c) {
                    case '\u0001': {
                        break block112;
                    }
                    case ',': {
                        n4 = Parser.getSourceString(string, n4, null);
                        continue block112;
                    }
                    case '^': 
                    case '_': 
                    case '`': {
                        continue block112;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                break;
            }
        }
        block113: while (n4 < n5) {
            switch (string.charAt(n4)) {
                case ',': 
                case '8': {
                    n4 = Parser.getSourceString(string, n4 + 1, objectArray);
                    stringBuffer.append((String)objectArray[0]);
                    continue block113;
                }
                case '-': {
                    n4 = Parser.getSourceNumber(string, n4 + 1, objectArray);
                    double d = ((Number)objectArray[0]).doubleValue();
                    stringBuffer.append(ScriptRuntime.numberToString(d, 10));
                    continue block113;
                }
                case '.': {
                    n4 = Parser.getSourceString(string, n4 + 1, objectArray);
                    stringBuffer.append('\"');
                    stringBuffer.append(ScriptRuntime.escapeString((String)objectArray[0]));
                    stringBuffer.append('\"');
                    continue block113;
                }
                case 'm': {
                    switch (string.charAt(++n4)) {
                        case '4': {
                            stringBuffer.append("true");
                            break;
                        }
                        case '3': {
                            stringBuffer.append("false");
                            break;
                        }
                        case '1': {
                            stringBuffer.append("null");
                            break;
                        }
                        case '2': {
                            stringBuffer.append("this");
                            break;
                        }
                        case ' ': {
                            stringBuffer.append("typeof");
                            break;
                        }
                        case '\u0084': {
                            stringBuffer.append("void");
                            break;
                        }
                        case 'J': {
                            stringBuffer.append("undefined");
                            break;
                        }
                    }
                    break;
                }
                case 'n': {
                    char c = string.charAt(++n4);
                    if (objectArray2 == null) throw Context.reportRuntimeError(Context.getMessage1("msg.no.function.ref.found", new Integer(c)));
                    if (c + '\u0001' > objectArray2.length) {
                        throw Context.reportRuntimeError(Context.getMessage1("msg.no.function.ref.found", new Integer(c)));
                    }
                    Parser.decompile_r(objectArray2[c + '\u0001'], n, n2, 2, false, objectArray, stringBuffer);
                    break;
                }
                case '`': {
                    stringBuffer.append(", ");
                    break;
                }
                case '\\': {
                    if (Parser.nextIs(string, n5, n4, 1)) {
                        n2 += 4;
                    }
                    stringBuffer.append('{');
                    break;
                }
                case ']': {
                    if (bl && n3 != 2 && n4 + 1 == n5) break;
                    if (Parser.nextIs(string, n5, n4, 1)) {
                        n2 -= 4;
                    }
                    if (Parser.nextIs(string, n5, n4, 118) || Parser.nextIs(string, n5, n4, 114)) {
                        n2 -= 4;
                        stringBuffer.append("} ");
                        break;
                    }
                    stringBuffer.append('}');
                    break;
                }
                case '^': {
                    stringBuffer.append('(');
                    break;
                }
                case '_': {
                    if (Parser.nextIs(string, n5, n4, 92)) {
                        stringBuffer.append(") ");
                        break;
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 'Z': {
                    stringBuffer.append('[');
                    break;
                }
                case '[': {
                    stringBuffer.append(']');
                    break;
                }
                case '\u0001': {
                    int n6;
                    stringBuffer.append('\n');
                    if (n4 + 1 >= n5) break;
                    int n7 = 0;
                    char c = string.charAt(n4 + 1);
                    if (c == 't' || c == 'u') {
                        n7 = 2;
                    } else if (c == ']') {
                        n7 = 4;
                    } else if (c == ',' && string.charAt(n6 = Parser.getSourceString(string, n4 + 2, null)) == 'c') {
                        n7 = 4;
                    }
                    while (n7 < n2) {
                        stringBuffer.append(' ');
                        ++n7;
                    }
                    break;
                }
                case 'l': {
                    stringBuffer.append('.');
                    break;
                }
                case '\u001e': {
                    stringBuffer.append("new ");
                    break;
                }
                case '\u001f': {
                    stringBuffer.append("delete ");
                    break;
                }
                case 'q': {
                    stringBuffer.append("if ");
                    break;
                }
                case 'r': {
                    stringBuffer.append("else ");
                    break;
                }
                case 'x': {
                    stringBuffer.append("for ");
                    break;
                }
                case '?': {
                    stringBuffer.append(" in ");
                    break;
                }
                case '|': {
                    stringBuffer.append("with ");
                    break;
                }
                case 'v': {
                    stringBuffer.append("while ");
                    break;
                }
                case 'w': {
                    stringBuffer.append("do ");
                    break;
                }
                case 'K': {
                    stringBuffer.append("try ");
                    break;
                }
                case '}': {
                    stringBuffer.append("catch ");
                    break;
                }
                case '~': {
                    stringBuffer.append("finally ");
                    break;
                }
                case '>': {
                    stringBuffer.append("throw ");
                    break;
                }
                case 's': {
                    stringBuffer.append("switch ");
                    break;
                }
                case 'y': {
                    if (Parser.nextIs(string, n5, n4, 44)) {
                        stringBuffer.append("break ");
                        break;
                    }
                    stringBuffer.append("break");
                    break;
                }
                case 'z': {
                    if (Parser.nextIs(string, n5, n4, 44)) {
                        stringBuffer.append("continue ");
                        break;
                    }
                    stringBuffer.append("continue");
                    break;
                }
                case 't': {
                    stringBuffer.append("case ");
                    break;
                }
                case 'u': {
                    stringBuffer.append("default");
                    break;
                }
                case '\u0005': {
                    if (Parser.nextIs(string, n5, n4, 89)) {
                        stringBuffer.append("return");
                        break;
                    }
                    stringBuffer.append("return ");
                    break;
                }
                case '{': {
                    stringBuffer.append("var ");
                    break;
                }
                case 'Y': {
                    if (Parser.nextIs(string, n5, n4, 1)) {
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append("; ");
                    break;
                }
                case 'a': {
                    switch (string.charAt(++n4)) {
                        case '\u0080': {
                            stringBuffer.append(" = ");
                            break;
                        }
                        case '\u0017': {
                            stringBuffer.append(" += ");
                            break;
                        }
                        case '\u0018': {
                            stringBuffer.append(" -= ");
                            break;
                        }
                        case '\u0019': {
                            stringBuffer.append(" *= ");
                            break;
                        }
                        case '\u001a': {
                            stringBuffer.append(" /= ");
                            break;
                        }
                        case '\u001b': {
                            stringBuffer.append(" %= ");
                            break;
                        }
                        case '\u000b': {
                            stringBuffer.append(" |= ");
                            break;
                        }
                        case '\f': {
                            stringBuffer.append(" ^= ");
                            break;
                        }
                        case '\r': {
                            stringBuffer.append(" &= ");
                            break;
                        }
                        case '\u0014': {
                            stringBuffer.append(" <<= ");
                            break;
                        }
                        case '\u0015': {
                            stringBuffer.append(" >>= ");
                            break;
                        }
                        case '\u0016': {
                            stringBuffer.append(" >>>= ");
                            break;
                        }
                    }
                    break;
                }
                case 'b': {
                    stringBuffer.append(" ? ");
                    break;
                }
                case '\u0087': {
                    stringBuffer.append(':');
                    break;
                }
                case 'c': {
                    if (Parser.nextIs(string, n5, n4, 1)) {
                        stringBuffer.append(':');
                        break;
                    }
                    stringBuffer.append(" : ");
                    break;
                }
                case 'd': {
                    stringBuffer.append(" || ");
                    break;
                }
                case 'e': {
                    stringBuffer.append(" && ");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append(" | ");
                    break;
                }
                case '\f': {
                    stringBuffer.append(" ^ ");
                    break;
                }
                case '\r': {
                    stringBuffer.append(" & ");
                    break;
                }
                case 'f': {
                    switch (string.charAt(++n4)) {
                        case '5': {
                            stringBuffer.append(n == 120 ? " == " : " === ");
                            break;
                        }
                        case '6': {
                            stringBuffer.append(n == 120 ? " != " : " !== ");
                            break;
                        }
                        case '\u000e': {
                            stringBuffer.append(" == ");
                            break;
                        }
                        case '\u000f': {
                            stringBuffer.append(" != ");
                            break;
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (string.charAt(++n4)) {
                        case '\u0011': {
                            stringBuffer.append(" <= ");
                            break;
                        }
                        case '\u0010': {
                            stringBuffer.append(" < ");
                            break;
                        }
                        case '\u0013': {
                            stringBuffer.append(" >= ");
                            break;
                        }
                        case '\u0012': {
                            stringBuffer.append(" > ");
                            break;
                        }
                        case '@': {
                            stringBuffer.append(" instanceof ");
                            break;
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (string.charAt(++n4)) {
                        case '\u0014': {
                            stringBuffer.append(" << ");
                            break;
                        }
                        case '\u0015': {
                            stringBuffer.append(" >> ");
                            break;
                        }
                        case '\u0016': {
                            stringBuffer.append(" >>> ");
                            break;
                        }
                    }
                    break;
                }
                case 'i': {
                    switch (string.charAt(++n4)) {
                        case ' ': {
                            stringBuffer.append("typeof ");
                            break;
                        }
                        case '\u0084': {
                            stringBuffer.append("void ");
                            break;
                        }
                        case '\u0081': {
                            stringBuffer.append('!');
                            break;
                        }
                        case '\u001c': {
                            stringBuffer.append('~');
                            break;
                        }
                        case '\u0017': {
                            stringBuffer.append('+');
                            break;
                        }
                        case '\u0018': {
                            stringBuffer.append('-');
                            break;
                        }
                    }
                    break;
                }
                case 'j': {
                    stringBuffer.append("++");
                    break;
                }
                case 'k': {
                    stringBuffer.append("--");
                    break;
                }
                case '\u0017': {
                    stringBuffer.append(" + ");
                    break;
                }
                case '\u0018': {
                    stringBuffer.append(" - ");
                    break;
                }
                case '\u0019': {
                    stringBuffer.append(" * ");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append(" / ");
                    break;
                }
                case '\u001b': {
                    stringBuffer.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++n4;
        }
        if (n3 == 2) return;
        if (bl) return;
        stringBuffer.append('\n');
    }

    private static boolean nextIs(String string, int n, int n2, int n3) {
        return n2 + 1 < n ? string.charAt(n2 + 1) == n3 : false;
    }

    private static int getSourceString(String string, int n, Object[] objectArray) {
        int n2 = string.charAt(n);
        ++n;
        if ((0x8000 & n2) != 0) {
            n2 = (Short.MAX_VALUE & n2) << 16 | string.charAt(n);
            ++n;
        }
        if (objectArray != null) {
            objectArray[0] = string.substring(n, n + n2);
        }
        return n + n2;
    }

    private static int getSourceNumber(String string, int n, Object[] objectArray) {
        char c = string.charAt(n);
        ++n;
        if (c == 'S') {
            if (objectArray != null) {
                char c2 = string.charAt(n);
                objectArray[0] = new Integer(c2);
            }
            ++n;
        } else if (c == 'J' || c == 'D') {
            if (objectArray != null) {
                long l = (long)string.charAt(n) << 48;
                l |= (long)string.charAt(n + 1) << 32;
                l |= (long)string.charAt(n + 2) << 16;
                double d = c == 'J' ? (double)l : Double.longBitsToDouble(l |= (long)string.charAt(n + 3));
                objectArray[0] = new Double(d);
            }
            n += 4;
        } else {
            throw new RuntimeException();
        }
        return n;
    }
}

