/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

public class LabelTable {
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private long[] itsFixupTable;
    private int itsFixupTableTop;

    public int acquireLabel() {
        int n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        return n;
    }

    public int getLabelPC(int n) {
        if (n > this.itsLabelTableTop) {
            throw new RuntimeException();
        }
        return this.itsLabelTable[n];
    }

    public void markLabel(int n, int n2) {
        if (n > this.itsLabelTableTop || n2 < 0) {
            throw new RuntimeException();
        }
        if (this.itsLabelTable[n] != -1) {
            throw new RuntimeException();
        }
        this.itsLabelTable[n] = n2;
    }

    public void addLabelFixup(int n, int n2) {
        if (n > this.itsLabelTableTop || n2 < 0) {
            throw new RuntimeException();
        }
        int n3 = this.itsFixupTableTop;
        if (this.itsFixupTable == null || n3 == this.itsFixupTable.length) {
            if (this.itsFixupTable == null) {
                this.itsFixupTable = new long[40];
            } else {
                long[] lArray = new long[this.itsFixupTable.length * 2];
                System.arraycopy(this.itsFixupTable, 0, lArray, 0, n3);
                this.itsFixupTable = lArray;
            }
        }
        this.itsFixupTableTop = n3 + 1;
        this.itsFixupTable[n3] = (long)n << 32 | (long)n2;
    }

    public void fixLabelGotos(byte[] byArray) {
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw new RuntimeException();
            }
            int n4 = n3 - (n2 - 1);
            if ((short)n4 != n4) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            byArray[n2] = (byte)(n4 >> 8);
            byArray[n2 + 1] = (byte)n4;
        }
        this.itsFixupTableTop = 0;
    }

    public void clearLabels() {
        this.itsLabelTableTop = 0;
        this.itsFixupTableTop = 0;
    }
}

