/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XFocusListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XMouseMotionListener;
import com.sun.star.awt.XPaintListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowListener;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.geometry.IntegerPoint2D;
import com.sun.star.geometry.IntegerRectangle2D;
import com.sun.star.geometry.IntegerSize2D;
import com.sun.star.geometry.RealRectangle2D;
import com.sun.star.geometry.RealSize2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.rendering.IntegerBitmapLayout;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.VolatileContentDestroyedException;
import com.sun.star.rendering.XAnimatedSprite;
import com.sun.star.rendering.XAnimation;
import com.sun.star.rendering.XBitmap;
import com.sun.star.rendering.XBitmapCanvas;
import com.sun.star.rendering.XBitmapPalette;
import com.sun.star.rendering.XCustomSprite;
import com.sun.star.rendering.XIntegerBitmap;
import com.sun.star.rendering.XSprite;
import com.sun.star.rendering.XSpriteCanvas;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.XComponentContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferStrategy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JavaCanvas
extends CanvasBase
implements XWindow,
XSpriteCanvas,
XIntegerBitmap,
XServiceInfo,
XInitialization {
    private WindowAdapter dummyFrame;
    public BackBuffer backBuffer;
    private BufferStrategy bufferStrategy;
    private Font fpsFont;
    private long lastTime;
    private Rectangle boundRect;
    private HashMap activeSprites;
    private static final String s_implName = "XCanvas.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.JavaCanvas";
    static /* synthetic */ Class class$JavaCanvas;

    public Graphics2D getGraphics() {
        return this.backBuffer.getGraphics();
    }

    public void initialize(Object[] objectArray) {
        CanvasUtils.printLog("JavaCanvas.initialize called!");
        String string = System.getProperty("os.name");
        CanvasUtils.printLog("System detected: " + string);
        try {
            this.boundRect = (Rectangle)objectArray[2];
            boolean bl = true;
            this.dummyFrame = new WindowAdapter(AnyConverter.toInt((Object)objectArray[1]), bl);
            if (bl) {
                Dimension dimension = this.dummyFrame.frame.getToolkit().getScreenSize();
                this.boundRect.X = 0;
                this.boundRect.Y = 0;
                this.boundRect.Width = dimension.width - 1;
                this.boundRect.Height = dimension.height - 1;
            }
            this.dummyFrame.setPosSize(this.boundRect.X, this.boundRect.Y, this.boundRect.Width, this.boundRect.Height, (short)0);
            CanvasUtils.printLog("Window size: " + this.boundRect.Width + ", " + this.boundRect.Height);
            this.backBuffer = new BackBuffer((Graphics2D)this.dummyFrame.frame.getGraphics(), Math.max(1, this.boundRect.Width), Math.max(1, this.boundRect.Height));
            this.dummyFrame.frame.createBufferStrategy(2);
            this.bufferStrategy = this.dummyFrame.frame.getBufferStrategy();
            if (this.bufferStrategy.getCapabilities().isPageFlipping()) {
                CanvasUtils.printLog("JavaCanvas.initialize double buffering is using page flipping!");
            } else {
                CanvasUtils.printLog("JavaCanvas.initialize double buffering is using blitting!");
            }
            this.lastTime = System.currentTimeMillis();
            this.fpsFont = new Font("Times", 0, 20);
            CanvasUtils.printLog("JavaCanvas.initialize finished!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CanvasUtils.printLog("Cannot create EmbeddedFrame within VCL window hierarchy!");
        }
    }

    public void dispose() {
        CanvasUtils.printLog("JavaCanvas: disposed!");
        Set set = this.activeSprites.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null) continue;
            ((SpriteRep)entry.getValue()).dispose();
        }
        if (this.bufferStrategy != null) {
            this.bufferStrategy.getDrawGraphics().dispose();
        }
        if (this.dummyFrame != null) {
            this.dummyFrame.dispose();
        }
        if (this.backBuffer != null) {
            this.backBuffer.dispose();
        }
        this.bufferStrategy = null;
        this.dummyFrame = null;
        this.backBuffer = null;
        super.dispose();
    }

    public JavaCanvas(XComponentContext xComponentContext) {
        CanvasUtils.printLog("JavaCanvas constructor called!");
        this.activeSprites = new HashMap(33);
    }

    public synchronized void setPosSize(int n, int n2, int n3, int n4, short s) {
        if (this.dummyFrame != null) {
            this.dummyFrame.setPosSize(n, n2, n3, n4, s);
            n3 = Math.max(1, n3);
            n4 = Math.max(1, n4);
            CanvasUtils.printLog("JavaCanvas graphics set to " + n3 + "," + n4);
            this.backBuffer.setSize(n3, n4);
        }
    }

    public synchronized Rectangle getPosSize() {
        if (this.dummyFrame != null) {
            return this.dummyFrame.getPosSize();
        }
        return new Rectangle();
    }

    public synchronized void setVisible(boolean bl) {
        if (this.dummyFrame != null) {
            this.dummyFrame.setVisible(bl);
        }
    }

    public synchronized void setEnable(boolean bl) {
        if (this.dummyFrame != null) {
            this.dummyFrame.setEnable(bl);
        }
    }

    public synchronized void setFocus() {
        if (this.dummyFrame != null) {
            this.dummyFrame.setFocus();
        }
    }

    public synchronized void addWindowListener(XWindowListener xWindowListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addWindowListener(xWindowListener);
        }
    }

    public synchronized void removeWindowListener(XWindowListener xWindowListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removeWindowListener(xWindowListener);
        }
    }

    public synchronized void addFocusListener(XFocusListener xFocusListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addFocusListener(xFocusListener);
        }
    }

    public synchronized void removeFocusListener(XFocusListener xFocusListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removeFocusListener(xFocusListener);
        }
    }

    public synchronized void addKeyListener(XKeyListener xKeyListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addKeyListener(xKeyListener);
        }
    }

    public synchronized void removeKeyListener(XKeyListener xKeyListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removeKeyListener(xKeyListener);
        }
    }

    public synchronized void addMouseListener(XMouseListener xMouseListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addMouseListener(xMouseListener);
        }
    }

    public synchronized void removeMouseListener(XMouseListener xMouseListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removeMouseListener(xMouseListener);
        }
    }

    public synchronized void addMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addMouseMotionListener(xMouseMotionListener);
        }
    }

    public synchronized void removeMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removeMouseMotionListener(xMouseMotionListener);
        }
    }

    public synchronized void addPaintListener(XPaintListener xPaintListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.addPaintListener(xPaintListener);
        }
    }

    public synchronized void removePaintListener(XPaintListener xPaintListener) {
        if (this.dummyFrame != null) {
            this.dummyFrame.removePaintListener(xPaintListener);
        }
    }

    public synchronized void copyRect(XBitmapCanvas xBitmapCanvas, RealRectangle2D realRectangle2D, ViewState viewState, RenderState renderState, RealRectangle2D realRectangle2D2, ViewState viewState2, RenderState renderState2) {
        CanvasUtils.printLog("JavaCanvas.copyRect() called");
        if (xBitmapCanvas == this) {
            this.getGraphics().copyArea((int)realRectangle2D.X1, (int)realRectangle2D.Y1, (int)(realRectangle2D.X2 - realRectangle2D.X1), (int)(realRectangle2D.Y2 - realRectangle2D.Y1), (int)(realRectangle2D2.X1 - realRectangle2D.X1), (int)(realRectangle2D2.Y1 - realRectangle2D.Y1));
        } else if (xBitmapCanvas instanceof JavaCanvas) {
            CanvasUtils.setupGraphicsState(this.getGraphics(), viewState2, renderState2, (byte)0);
            Image image = ((JavaCanvas)xBitmapCanvas).backBuffer.getBackBuffer();
            this.getGraphics().drawImage(image, 0, 0, null);
            CanvasUtils.postRenderImageTreatment(image);
        }
    }

    public synchronized XAnimatedSprite createSpriteFromAnimation(XAnimation xAnimation) {
        CanvasUtils.printLog("JavaCanvas.createSpriteFromAnimation called");
        return new CanvasSprite(xAnimation, this, (Graphics2D)this.dummyFrame.frame.getGraphics());
    }

    public synchronized XAnimatedSprite createSpriteFromBitmaps(XBitmap[] xBitmapArray, byte by) {
        return null;
    }

    public synchronized XCustomSprite createCustomSprite(RealSize2D realSize2D) {
        CanvasUtils.printLog("JavaCanvas.createCustomSprite called");
        return new CanvasCustomSprite(realSize2D, this, (Graphics2D)this.dummyFrame.frame.getGraphics());
    }

    public synchronized XSprite createClonedSprite(XSprite xSprite) {
        return new CanvasClonedSprite(this, xSprite);
    }

    public synchronized boolean updateScreen(boolean bl) {
        this.redrawAllLayers();
        return true;
    }

    public synchronized IntegerSize2D getSize() {
        return new IntegerSize2D(this.boundRect.Width, this.boundRect.Height);
    }

    public synchronized XBitmapCanvas queryBitmapCanvas() {
        return this;
    }

    public synchronized XBitmap getScaledBitmap(RealSize2D realSize2D, boolean bl) throws IllegalArgumentException, VolatileContentDestroyedException {
        return null;
    }

    public synchronized byte[] getData(IntegerRectangle2D integerRectangle2D) {
        return null;
    }

    public synchronized void setData(byte[] byArray, IntegerBitmapLayout integerBitmapLayout, IntegerRectangle2D integerRectangle2D) {
    }

    public synchronized void setPixel(byte[] byArray, IntegerBitmapLayout integerBitmapLayout, IntegerPoint2D integerPoint2D) {
    }

    public synchronized byte[] getPixel(IntegerPoint2D integerPoint2D) {
        return null;
    }

    public synchronized XBitmapPalette getPalette() {
        return null;
    }

    public synchronized IntegerBitmapLayout getMemoryLayout() {
        IntegerBitmapLayout integerBitmapLayout = new IntegerBitmapLayout();
        integerBitmapLayout.ScanLines = this.boundRect.Width;
        integerBitmapLayout.ScanLineStride = integerBitmapLayout.ScanLineBytes = this.boundRect.Width * 4;
        integerBitmapLayout.Format = 0;
        integerBitmapLayout.NumComponents = 4;
        integerBitmapLayout.ComponentMasks = null;
        integerBitmapLayout.Endianness = 0;
        integerBitmapLayout.IsPseudoColor = false;
        return integerBitmapLayout;
    }

    public synchronized void renderAnimation(CanvasSprite canvasSprite, XAnimation xAnimation, double d) {
        SpriteRep spriteRep = (SpriteRep)this.activeSprites.get(canvasSprite);
        if (spriteRep != null) {
            spriteRep.renderAnimation(xAnimation, canvasSprite.getViewState(), d);
        } else {
            CanvasUtils.printLog("JavaCanvas.renderAnimation sprite not active!");
        }
    }

    public synchronized void showSprite(SpriteBase spriteBase) {
        CanvasUtils.printLog("JavaCanvas.showSprite() called");
        SpriteRep spriteRep = (SpriteRep)this.activeSprites.get(spriteBase);
        if (spriteRep != null) {
            CanvasUtils.printLog("JavaCanvas.showSprite sprite already active!");
        } else {
            spriteRep = spriteBase.getSpriteRep();
            this.activeSprites.put(spriteBase, spriteRep);
        }
    }

    public synchronized void hideSprite(SpriteBase spriteBase) {
        CanvasUtils.printLog("JavaCanvas.hideSprite() called");
        SpriteRep spriteRep = (SpriteRep)this.activeSprites.get(spriteBase);
        if (spriteRep != null) {
            this.activeSprites.put(spriteBase, null);
            this.redrawAllLayers();
        } else {
            CanvasUtils.printLog("JavaCanvas.hideSprite sprite not active!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawAllLayers() {
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)this.bufferStrategy.getDrawGraphics();
            GraphicsDevice graphicsDevice = graphics2D.getDeviceConfiguration().getDevice();
            CanvasUtils.printLog("Available vram: " + graphicsDevice.getAvailableAcceleratedMemory());
            this.backBuffer.redraw(graphics2D);
            Set set = this.activeSprites.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() == null) continue;
                ((SpriteRep)entry.getValue()).redraw(graphics2D);
            }
            long l = System.currentTimeMillis();
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            graphics2D.setFont(this.fpsFont);
            graphics2D.setColor(Color.black);
            try {
                String string = new String(String.valueOf(1000.0 / (double)(l - this.lastTime)));
                graphics2D.drawString(string.substring(0, 5) + " fps", 0, 20);
                CanvasUtils.printLog(string.substring(0, 5) + " fps");
            }
            catch (Exception exception) {
                graphics2D.drawString("0 fps", 0, 20);
            }
            this.lastTime = l;
        }
        catch (Exception exception) {
            CanvasUtils.printLog("Exception thrown in redrawAllLayers");
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        this.bufferStrategy.show();
    }

    public synchronized String getImplementationName() {
        return s_implName;
    }

    public synchronized String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public synchronized boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        if (string.equals(s_implName)) {
            return FactoryHelper.getServiceFactory((Class)(class$JavaCanvas == null ? (class$JavaCanvas = JavaCanvas.class$("JavaCanvas")) : class$JavaCanvas), (String)s_serviceName, (XMultiServiceFactory)xMultiServiceFactory, (XRegistryKey)xRegistryKey);
        }
        return null;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return FactoryHelper.writeRegistryServiceInfo((String)s_implName, (String)s_serviceName, (XRegistryKey)xRegistryKey);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

