/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.util;

public final class ConceptLocation {
    public int _concept;
    public int _begin;
    public int _end;
    private static ConceptLocationSorter _cComp;
    private static ConceptLocationSorter _pComp;

    private ConceptLocation() {
        _cComp = new ConceptSorter();
        _pComp = new PositionSorter();
    }

    public ConceptLocation(int n, int n2, int n3) {
        this._concept = n;
        this._begin = n2;
        this._end = n3;
    }

    public boolean equals(ConceptLocation conceptLocation) {
        return this._concept == conceptLocation._concept && this._begin == conceptLocation._begin && this._end == conceptLocation._end;
    }

    public void setConcept(int n) {
        this._concept = n;
    }

    public int getConcept() {
        return this._concept;
    }

    public int getBegin() {
        return this._begin;
    }

    public int getEnd() {
        return this._end;
    }

    public int getLength() {
        return this._end - this._begin;
    }

    public static void sortByConcept(ConceptLocation[] conceptLocationArray, int n, int n2) {
        _cComp.quicksort(conceptLocationArray, n, n2 - 1);
    }

    public static void sortByPosition(ConceptLocation[] conceptLocationArray, int n, int n2) {
        _pComp.quicksort(conceptLocationArray, n, n2 - 1);
    }

    public void print() {
        System.out.println(this._concept + "\t" + this._begin + "\t" + this._end);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 30;
        ConceptLocation[] conceptLocationArray = new ConceptLocation[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = (int)(Math.random() * 1000.0);
            conceptLocationArray[n] = new ConceptLocation((int)(Math.random() * 1000.0), n3, n3 + (int)(Math.random() * 10.0));
        }
        for (n = 0; n < n2; ++n) {
            conceptLocationArray[n].print();
        }
        ConceptLocation.sortByConcept(conceptLocationArray, 0, n2);
        System.out.println("----------------------------------");
        for (n = 0; n < n2; ++n) {
            conceptLocationArray[n].print();
        }
        ConceptLocation.sortByPosition(conceptLocationArray, 0, n2);
        System.out.println("----------------------------------");
        for (n = 0; n < n2; ++n) {
            conceptLocationArray[n].print();
        }
    }

    static {
        new ConceptLocation();
    }

    private class PositionSorter
    extends ConceptLocationSorter {
        private PositionSorter() {
        }

        public boolean smallerThan(ConceptLocation conceptLocation, ConceptLocation conceptLocation2) {
            return conceptLocation._begin < conceptLocation2._begin || conceptLocation._begin == conceptLocation2._begin && conceptLocation._end < conceptLocation2._end;
        }
    }

    private class ConceptSorter
    extends ConceptLocationSorter {
        private ConceptSorter() {
        }

        public boolean smallerThan(ConceptLocation conceptLocation, ConceptLocation conceptLocation2) {
            return conceptLocation._concept < conceptLocation2._concept;
        }
    }

    private abstract class ConceptLocationSorter {
        private ConceptLocationSorter() {
        }

        public abstract boolean smallerThan(ConceptLocation var1, ConceptLocation var2);

        private int partition(ConceptLocation[] conceptLocationArray, int n, int n2) {
            ConceptLocation conceptLocation = conceptLocationArray[(n + n2) / 2];
            int n3 = n - 1;
            int n4 = n2 + 1;
            while (true) {
                if (this.smallerThan(conceptLocation, conceptLocationArray[--n4])) {
                    continue;
                }
                while (this.smallerThan(conceptLocationArray[++n3], conceptLocation)) {
                }
                if (n3 >= n4) break;
                ConceptLocation conceptLocation2 = conceptLocationArray[n3];
                conceptLocationArray[n3] = conceptLocationArray[n4];
                conceptLocationArray[n4] = conceptLocation2;
            }
            return n4;
        }

        public void quicksort(ConceptLocation[] conceptLocationArray, int n, int n2) {
            while (n < n2) {
                int n3 = this.partition(conceptLocationArray, n, n2);
                this.quicksort(conceptLocationArray, n, n3);
                n = n3 + 1;
            }
        }
    }
}

