/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.qe.HitStore;
import com.sun.xmlsearch.qe.QueryHit;
import com.sun.xmlsearch.qe.SearchEnvironment;
import com.sun.xmlsearch.util.Location;
import java.io.PrintStream;

public class Query {
    private double _currentStandard;
    private final int _nColumns;
    private double[] _missingPenalty;
    private double[] _upperboundTemplate;
    private double[] _penalties;
    private final SearchEnvironment _env;
    private int _hitCounter;
    private boolean _vote;
    private HitStore _store;

    public Query(SearchEnvironment searchEnvironment, int n, double[] dArray) {
        this._env = searchEnvironment;
        this._nColumns = n;
        this._missingPenalty = new double[n];
        this._upperboundTemplate = new double[n];
        this._penalties = dArray;
        this._hitCounter = 0;
        this._vote = false;
        this._currentStandard = (double)(n - 1) * 10.0 + 9.9999;
        this._store = new HitStore(this._currentStandard);
        for (int i = 0; i < this._nColumns; ++i) {
            this._missingPenalty[i] = dArray != null ? dArray[i] : 10.0;
        }
        this.makePenaltiesTable();
    }

    public double lookupPenalty(int n) {
        return this._penalties[n];
    }

    public double getOutOufOrderPenalty() {
        return 0.25;
    }

    public double getGapPenalty() {
        return 0.005;
    }

    public int getNColumns() {
        return this._nColumns;
    }

    public boolean goodEnough(double d) {
        return d <= this._currentStandard;
    }

    public int[] getConceptArrayOfNewHit(double d, Location location) {
        QueryHit queryHit = new QueryHit(location, d, this._nColumns);
        this._store.addQueryHit(queryHit);
        ++this._hitCounter;
        return queryHit.getArray();
    }

    public void resetForNextDocument() {
        this._currentStandard = this._store.getCurrentStandard();
        for (int i = 0; i < this._nColumns; ++i) {
            this._upperboundTemplate[i] = this._missingPenalty[i];
        }
        this._vote = false;
    }

    public boolean vote() {
        double d = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            d += this._upperboundTemplate[i];
        }
        this._vote = d <= this._currentStandard;
        return this._vote;
    }

    public void updateEstimate(int n, double d) {
        if (d < this._upperboundTemplate[n]) {
            this._upperboundTemplate[n] = d;
        }
    }

    public void printHits(PrintStream printStream, int n) {
        if (n > 0) {
            int n2 = n;
            QueryHit queryHit = this._store.firstBestQueryHit();
            n = n2;
            while (queryHit != null) {
                try {
                    printStream.println(this._env.hitToString(queryHit));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println(exception + "hit not translated");
                }
                queryHit = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
    }

    private void makePenaltiesTable() {
        int n = 1 << this._nColumns;
        this._penalties = new double[n];
        for (int i = 0; i < n; ++i) {
            this._penalties[i] = this.computePenalty(i);
        }
    }

    private double computePenalty(int n) {
        double d = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            if ((n & 1 << i) != 0) continue;
            d += this._missingPenalty[i];
        }
        return d;
    }
}

