/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

public class CloneableNodeIteratorImpl
implements CloneableNodeIterator {
    private final NodeList list;
    private int i;

    private CloneableNodeIteratorImpl(NodeList nodeList, int n) {
        this.list = nodeList;
        this.i = n;
    }

    public CloneableNodeIteratorImpl(NodeIterator nodeIterator) {
        this.list = new NodeList(nodeIterator);
        this.i = 0;
    }

    public void bind() throws XSLException {
        int n = 0;
        while (this.list.nodeAt(n) != null) {
            ++n;
        }
    }

    public Object clone() {
        return new CloneableNodeIteratorImpl(this.list, this.i);
    }

    public Node next() throws XSLException {
        Node node = this.list.nodeAt(this.i);
        if (node != null) {
            ++this.i;
        }
        return node;
    }

    static class NodeList {
        final NodeIterator iter;
        Node[] nodes = null;
        int len = 0;

        NodeList(NodeIterator nodeIterator) {
            this.iter = nodeIterator;
        }

        Node nodeAt(int n) throws XSLException {
            if (n >= this.len) {
                if (this.nodes == null) {
                    this.nodes = new Node[n + 4];
                } else if (n >= this.nodes.length) {
                    Node[] nodeArray = this.nodes;
                    this.nodes = new Node[nodeArray.length * 2];
                    System.arraycopy(nodeArray, 0, this.nodes, 0, nodeArray.length);
                }
                while (this.len <= n) {
                    this.nodes[this.len] = this.iter.next();
                    if (this.nodes[this.len] == null) {
                        return null;
                    }
                    ++this.len;
                }
            }
            return this.nodes[n];
        }
    }
}

