/*
 * Decompiled with CFR 0.152.
 */
package util.compare;

import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.FileHelper;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import lib.TestParameters;
import util.compare.DocComparator;

class GraphicalComparator
implements DocComparator {
    GraphicalTestArguments m_aArguments;

    protected GraphicalComparator(TestParameters testParameters) {
        this.m_aArguments = new GraphicalTestArguments(testParameters);
    }

    static DocComparator getInstance(TestParameters testParameters) {
        GraphicalComparator graphicalComparator = new GraphicalComparator(testParameters);
        return graphicalComparator;
    }

    FileFilter getTrueIfPRNFile_FileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".prn");
            }
        };
        return fileFilter;
    }

    protected String createSpecialFile(String string, String string2, String string3, String string4) {
        String string5 = System.getProperty("file.separator");
        String string6 = "";
        if (string2.length() > 0) {
            string6 = FileHelper.removeFirstDirectorysAndBasenameFrom(string, string2);
        }
        String string7 = FileHelper.getNameNoSuffix(FileHelper.getBasename(string));
        String string8 = string6.length() > 0 ? string3 + string5 + string6 : string3;
        string8 = string8 + string5 + string7 + string4;
        return string8;
    }

    boolean isReferenceOrDiffExistent(String string) {
        boolean bl = false;
        String string2 = this.m_aArguments.getInputPath();
        if (FileHelper.isDir(string2)) {
            Object[] objectArray = DirectoryHelper.traverse(string2, this.m_aArguments.getFileFilter(), this.m_aArguments.includeSubDirectories());
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                String string4 = this.createSpecialFile(string3, string2, this.m_aArguments.getReferencePath(), string);
                if (!FileHelper.exists(string4)) continue;
                bl = true;
            }
        } else {
            String string5 = this.createSpecialFile(string2, "", this.m_aArguments.getReferencePath(), string);
            if (FileHelper.exists(string5)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isReferenceExistent() {
        return this.isReferenceOrDiffExistent(".prn");
    }

    public void createReference() throws IOException {
        try {
            String string = null;
            if (this.m_aArguments.getReferenceInputPath() == null) {
                GraphicalDifferenceCheck.createReferences(this.m_aArguments.getInputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments);
            } else {
                string = this.m_aArguments.getReferenceInputPath();
                GraphicalDifferenceCheck.createReferences(string, this.m_aArguments.getReferencePath(), this.m_aArguments);
            }
        }
        catch (ConvWatchException convWatchException) {
            throw new IOException(convWatchException.getMessage());
        }
    }

    public boolean compare() throws IOException {
        try {
            if (FileHelper.isDebugEnabled()) {
                System.err.println("    Inputpath: '" + this.m_aArguments.getInputPath() + "'");
                System.err.println("   Outputpath: '" + this.m_aArguments.getOutputPath() + "'");
                System.err.println("Referencepath: '" + this.m_aArguments.getReferencePath() + "'");
            }
            return GraphicalDifferenceCheck.check(this.m_aArguments.getInputPath(), this.m_aArguments.getOutputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments);
        }
        catch (ConvWatchException convWatchException) {
            if (FileHelper.isDebugEnabled()) {
                System.err.println("Exception caught");
                System.err.println("    Inputpath: '" + this.m_aArguments.getInputPath() + "'");
                System.err.println("   Outputpath: '" + this.m_aArguments.getOutputPath() + "'");
                System.err.println("Referencepath: '" + this.m_aArguments.getReferencePath() + "'");
            }
            throw new IOException(convWatchException.getMessage());
        }
    }

    public boolean isDiffReferenceExistent() throws IOException {
        return this.isReferenceOrDiffExistent(".prn.diff0001.jpg");
    }

    public void createDiffReference() throws IOException {
        this.compareDiff();
    }

    public boolean compareDiff() throws IOException {
        try {
            return GraphicalDifferenceCheck.check(this.m_aArguments.getInputPath(), this.m_aArguments.getOutputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments.getDiffPath(), this.m_aArguments);
        }
        catch (ConvWatchException convWatchException) {
            throw new IOException(convWatchException.getMessage());
        }
    }
}

