/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import stats.Summarizer;

public class MultiMethodTest {
    protected TestEnvironment tEnv;
    protected TestParameters tParam;
    protected DescEntry entry;
    protected PrintWriter log;
    protected TestResult tRes;
    private Vector methCalled = new Vector(10);

    public void disposeEnvironment(TestEnvironment testEnvironment) {
        this.disposeEnvironment();
    }

    public void disposeEnvironment() {
        this.tEnv.dispose();
        TestCase testCase = this.tEnv.getTestCase();
        testCase.disposeTestEnvironment(this.tEnv, this.tParam);
    }

    public TestResult run(DescEntry descEntry, TestEnvironment testEnvironment, TestParameters testParameters) {
        Class<?> clazz;
        this.log = (PrintWriter)((Object)descEntry.Logger);
        this.tEnv = testEnvironment;
        this.tParam = testParameters;
        this.log = this.log;
        this.entry = descEntry;
        this.tRes = new TestResult();
        String string = this.getInterfaceName();
        System.out.println("checking : " + string);
        String string2 = this.getTestedClassName();
        if (descEntry.EntryType.equals("service")) {
            string2 = "com.sun.star.beans.XPropertySet";
        }
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(this.log);
            this.log.println("could not find a class : " + this.getTestedClassName());
            return null;
        }
        XInterface xInterface = testEnvironment.getTestObject();
        Object object = UnoRuntime.queryInterface(clazz, (Object)testEnvironment.getTestObject());
        if (object == null) {
            if (descEntry.isOptional) {
                Summarizer.summarizeDown(descEntry, "Not supported but optional.OK");
            } else {
                Summarizer.summarizeDown(descEntry, "queryInterface returned null.FAILED");
                descEntry.ErrorMsg = "queryInterface returned null";
                descEntry.hasErrorMsg = true;
            }
            return null;
        }
        this.setField("oObj", object);
        try {
            this.before();
        }
        catch (Exception exception) {
            this.setSubStates(exception.toString());
            return this.tRes;
        }
        for (int i = 0; i < descEntry.SubEntryCount; ++i) {
            try {
                this.executeMethod(descEntry.SubEntries[i].entryName);
                continue;
            }
            catch (Exception exception) {
                this.log.println("Exception while checking: " + descEntry.SubEntries[i].entryName + " : " + exception.getMessage());
            }
        }
        try {
            this.after();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.tRes;
    }

    protected void before() {
    }

    protected void after() {
    }

    protected String getTestedClassName() {
        String string = this.getClass().getName();
        int n = string.indexOf(".");
        int n2 = string.lastIndexOf(".");
        String string2 = "com.sun.star.";
        if (this.entry.longName.indexOf("::drafts::com::") > -1) {
            string2 = "drafts.com.sun.star.";
        }
        return string2 + string.substring(n + 1, n2 + 1) + string.substring(n2 + 2);
    }

    protected void setStatus(String string, Status status) {
        this.tRes.tested(string, status);
    }

    protected void setSubStates(String string) {
        for (int i = 0; i < this.entry.SubEntryCount; ++i) {
            this.entry.SubEntries[i].hasErrorMsg = true;
            this.entry.SubEntries[i].ErrorMsg = string;
            if (!this.entry.SubEntries[i].State.equals("UNKNOWN")) continue;
            this.entry.SubEntries[i].State = string;
        }
    }

    protected boolean isOptional(String string) {
        for (int i = 0; i < this.entry.SubEntryCount; ++i) {
            if (!this.entry.SubEntries[i].entryName.equals(string)) continue;
            return this.entry.SubEntries[i].isOptional;
        }
        return false;
    }

    protected boolean isCalled(String string) {
        return this.methCalled.contains(string);
    }

    protected void requiredMethod(String string) {
        this.log.println("starting required method: " + string);
        this.executeMethod(string);
        Status status = this.tRes.getStatusFor(string);
        if (status != null && (!status.isPassed() || status.isFailed())) {
            this.log.println("! Required method " + string + " failed");
            throw new StatusException(status);
        }
    }

    protected void executeMethod(String string) {
        if (!this.isCalled(string)) {
            this.log.println("Execute: " + string);
            this.callMethod(string);
            this.log.println(string + ": " + this.tRes.getStatusFor(string));
        }
    }

    protected void callMethod(String string) {
        this.methCalled.add(string);
        this.invokeTestMethod(this.getMethodFor(string), string);
    }

    protected void invokeTestMethod(Method method, String string) {
        if (method == null) {
            this.setStatus(string, Status.skipped(false));
        } else {
            Status status;
            try {
                method.invoke((Object)this, new Object[0]);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof StatusException) {
                    status = ((StatusException)throwable).getStatus();
                } else {
                    throwable.printStackTrace(this.log);
                    status = Status.exception(throwable);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(this.log);
                status = Status.exception(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(this.log);
                status = Status.exception(illegalArgumentException);
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace(this.log);
                status = Status.exception(classCastException);
            }
            this.setStatus(string, status);
        }
    }

    protected Method getMethodFor(String string) {
        String string2 = "_" + string;
        if (string2.endsWith("()")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        Class[] classArray = new Class[]{};
        try {
            return this.getClass().getDeclaredMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String getInterfaceName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    protected Status setField(String string, Object object) {
        Field field;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return Status.exception(noSuchFieldException);
        }
        try {
            field.set(this, object);
            return Status.passed(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Status.exception(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            return Status.exception(illegalAccessException);
        }
    }
}

