/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import lib.MultiMethodTest;

public class _XURLTransformer
extends MultiMethodTest {
    public XURLTransformer oObj = null;
    URL url;
    static final String user = "user";
    static final String invalidUserPrefix = "1";
    static final String password = "password";
    static final String server = "server";
    static final String invalidServerPrefix = "1";
    static final String port = "8080";
    static final String path = "/pub/path";
    static final String name = "file.txt";
    static final String arguments = "a=b";
    static final String mark = "mark";
    static final String expectedCompleteHTTP = "http://server:8080/pub/path/file.txt?a=b#mark";
    static final String expectedCompleteFTP = "ftp://user:password@server:8080/pub/path/file.txt";

    public void _assemble() {
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Protocol = "http://";
        uRLArray[0].Server = server;
        uRLArray[0].Port = new Integer(port).shortValue();
        uRLArray[0].Path = path;
        uRLArray[0].Name = name;
        uRLArray[0].Arguments = arguments;
        uRLArray[0].Mark = mark;
        uRLArray[0].Main = "http://server:8080/pub/path/file.txt";
        boolean bl = true;
        this.log.print("assemble http-URL: ");
        boolean bl2 = this.oObj.assemble(uRLArray);
        this.log.println(bl2);
        bl &= bl2;
        if (!expectedCompleteHTTP.equals(uRLArray[0].Complete)) {
            this.log.println("assemble works wrong");
            this.log.println("complete field : " + uRLArray[0].Complete);
            this.log.println("expected : http://server:8080/pub/path/file.txt?a=b#mark");
            bl = false;
        }
        uRLArray[0] = new URL();
        uRLArray[0].Protocol = "ftp://";
        uRLArray[0].User = user;
        uRLArray[0].Password = password;
        uRLArray[0].Server = server;
        uRLArray[0].Port = new Integer(port).shortValue();
        uRLArray[0].Path = path;
        uRLArray[0].Name = name;
        uRLArray[0].Main = expectedCompleteFTP;
        this.log.print("assemble ftp-URL: ");
        bl2 = this.oObj.assemble(uRLArray);
        this.log.println(bl2);
        bl &= bl2;
        if (!expectedCompleteFTP.equals(uRLArray[0].Complete)) {
            this.log.println("assemble works wrong");
            this.log.println("complete field : " + uRLArray[0].Complete);
            this.log.println("expected : ftp://user:password@server:8080/pub/path/file.txt");
            bl = false;
        }
        URL[] uRLArray2 = new URL[]{new URL()};
        uRLArray2[0].Server = server;
        this.log.print("assemble incomplete URL: ");
        bl2 = this.oObj.assemble(uRLArray2);
        this.log.println(bl2);
        this.tRes.tested("assemble()", bl &= !bl2);
    }

    public void _parseStrict() {
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = expectedCompleteHTTP;
        boolean bl = true;
        this.log.print("parseStrict(http://server:8080/pub/path/file.txt?a=b#mark): ");
        boolean bl2 = this.oObj.parseStrict(uRLArray);
        this.log.println(bl2);
        bl &= bl2;
        if (!uRLArray[0].Protocol.equals("http://")) {
            this.log.println("parseStrict works wrong");
            this.log.println("protocol field : " + uRLArray[0].Protocol);
            this.log.println("expected : http://");
            bl = false;
        }
        if (!uRLArray[0].Server.equals(server)) {
            this.log.println("parseStrict works wrong");
            this.log.println("server field : " + uRLArray[0].Server);
            this.log.println("expected : server");
            bl = false;
        }
        if (uRLArray[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseStrict works wrong");
            this.log.println("port field : " + uRLArray[0].Port);
            this.log.println("expected : 8080");
            bl = false;
        }
        if (!uRLArray[0].Path.equals(path) && !uRLArray[0].Path.equals("/pub/path/")) {
            this.log.println("parseStrict works wrong");
            this.log.println("path field : " + uRLArray[0].Path);
            this.log.println("expected : /pub/path");
            bl = false;
        }
        if (!uRLArray[0].Name.equals(name)) {
            this.log.println("parseStrict works wrong");
            this.log.println("name field : " + uRLArray[0].Name);
            this.log.println("expected : file.txt");
            bl = false;
        }
        if (!uRLArray[0].Arguments.equals(arguments)) {
            this.log.println("parseStrict works wrong");
            this.log.println("arguments field : " + uRLArray[0].Arguments);
            this.log.println("expected : a=b");
            bl = false;
        }
        if (!uRLArray[0].Mark.equals(mark)) {
            this.log.println("parseStrict works wrong");
            this.log.println("mark field : " + uRLArray[0].Mark);
            this.log.println("expected : mark");
            bl = false;
        }
        uRLArray[0] = new URL();
        uRLArray[0].Complete = expectedCompleteFTP;
        this.log.print("parseStrict(ftp://user:password@server:8080/pub/path/file.txt): ");
        bl2 = this.oObj.parseStrict(uRLArray);
        this.log.println(bl2);
        bl &= bl2;
        if (!uRLArray[0].Protocol.equals("ftp://")) {
            this.log.println("parseStrict works wrong");
            this.log.println("protocol field : " + uRLArray[0].Protocol);
            this.log.println("expected : ftp://");
            bl = false;
        }
        if (!uRLArray[0].User.equals(user)) {
            this.log.println("parseStrict works wrong");
            this.log.println("user field : " + uRLArray[0].User);
            this.log.println("expected : user");
            bl = false;
        }
        if (!uRLArray[0].Password.equals(password)) {
            this.log.println("parseStrict works wrong");
            this.log.println("password field : " + uRLArray[0].Password);
            this.log.println("expected : password");
            bl = false;
        }
        if (!uRLArray[0].Server.equals(server)) {
            this.log.println("parseStrict works wrong");
            this.log.println("server field : " + uRLArray[0].Server);
            this.log.println("expected : server");
            bl = false;
        }
        if (uRLArray[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseStrict works wrong");
            this.log.println("port field : " + uRLArray[0].Port);
            this.log.println("expected : 8080");
            bl = false;
        }
        if (!uRLArray[0].Path.equals(path) && !uRLArray[0].Path.equals("/pub/path/")) {
            this.log.println("parseStrict works wrong");
            this.log.println("path field : " + uRLArray[0].Path);
            this.log.println("expected : /pub/path");
            bl = false;
        }
        if (!uRLArray[0].Name.equals(name)) {
            this.log.println("parseStrict works wrong");
            this.log.println("name field : " + uRLArray[0].Name);
            this.log.println("expected : file.txt");
            bl = false;
        }
        URL[] uRLArray2 = new URL[]{new URL()};
        uRLArray2[0].Complete = server;
        this.log.print("parseStrict(server): ");
        bl2 = this.oObj.parseStrict(uRLArray2);
        this.log.println(bl2);
        this.tRes.tested("parseStrict()", bl &= !bl2);
    }

    public void _parseSmart() {
        URL[] uRLArray = new URL[1];
        String string = "1server:8080/pub/path/file.txt?a=b#mark";
        uRLArray[0] = new URL();
        uRLArray[0].Complete = string;
        boolean bl = true;
        this.log.print("parseSmart('" + string + "', 'http://'): ");
        boolean bl2 = this.oObj.parseSmart(uRLArray, "http://");
        this.log.println(bl2);
        bl &= bl2;
        if (!uRLArray[0].Protocol.equals("http://")) {
            this.log.println("parseSmart works wrong");
            this.log.println("protocol field : " + uRLArray[0].Protocol);
            this.log.println("expected : http://");
            bl = false;
        }
        if (!uRLArray[0].Server.equals("1server")) {
            this.log.println("parseSmart works wrong");
            this.log.println("server field : " + uRLArray[0].Server);
            this.log.println("expected : server");
            bl = false;
        }
        if (uRLArray[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseSmart works wrong");
            this.log.println("port field : " + uRLArray[0].Port);
            this.log.println("expected : 8080");
            bl = false;
        }
        if (!uRLArray[0].Path.equals(path) && !uRLArray[0].Path.equals("/pub/path/")) {
            this.log.println("parseSmart works wrong");
            this.log.println("path field : " + uRLArray[0].Path);
            this.log.println("expected : /pub/path");
            bl = false;
        }
        if (!uRLArray[0].Name.equals(name)) {
            this.log.println("parseSmart works wrong");
            this.log.println("name field : " + uRLArray[0].Name);
            this.log.println("expected : file.txt");
            bl = false;
        }
        if (!uRLArray[0].Arguments.equals(arguments)) {
            this.log.println("parseSmart works wrong");
            this.log.println("arguments field : " + uRLArray[0].Arguments);
            this.log.println("expected : a=b");
            bl = false;
        }
        if (!uRLArray[0].Mark.equals(mark)) {
            this.log.println("parseSmart works wrong");
            this.log.println("mark field : " + uRLArray[0].Mark);
            this.log.println("expected : mark");
            bl = false;
        }
        String string2 = "1user:password@server:8080/pub/path/file.txt";
        uRLArray[0] = new URL();
        uRLArray[0].Complete = string2;
        this.log.print("parseSmart('" + string2 + "', 'ftp://'): ");
        bl2 = this.oObj.parseSmart(uRLArray, "ftp://");
        this.log.println(bl2);
        bl &= bl2;
        if (!uRLArray[0].Protocol.equals("ftp://")) {
            this.log.println("parseSmart works wrong");
            this.log.println("protocol field : " + uRLArray[0].Protocol);
            this.log.println("expected : ftp://");
            bl = false;
        }
        if (!uRLArray[0].User.equals("1user")) {
            this.log.println("parseSmart works wrong");
            this.log.println("user field : " + uRLArray[0].User);
            this.log.println("expected : user");
            bl = false;
        }
        if (!uRLArray[0].Password.equals(password)) {
            this.log.println("parseSmart works wrong");
            this.log.println("password field : " + uRLArray[0].Password);
            this.log.println("expected : password");
            bl = false;
        }
        if (!uRLArray[0].Server.equals(server)) {
            this.log.println("parseSmart works wrong");
            this.log.println("server field : " + uRLArray[0].Server);
            this.log.println("expected : server");
            bl = false;
        }
        if (uRLArray[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseSmart works wrong");
            this.log.println("port field : " + uRLArray[0].Port);
            this.log.println("expected : 8080");
            bl = false;
        }
        if (!uRLArray[0].Path.equals(path) && !uRLArray[0].Path.equals("/pub/path/")) {
            this.log.println("parseSmart works wrong");
            this.log.println("path field : " + uRLArray[0].Path);
            this.log.println("expected : /pub/path");
            bl = false;
        }
        if (!uRLArray[0].Name.equals(name)) {
            this.log.println("parseSmart works wrong");
            this.log.println("name field : " + uRLArray[0].Name);
            this.log.println("expected : file.txt");
            bl = false;
        }
        this.tRes.tested("parseSmart()", bl);
    }

    public void _getPresentation() {
        String string;
        URL uRL = new URL();
        uRL.Complete = expectedCompleteHTTP;
        this.log.println("getPresentation('http://server:8080/pub/path/file.txt?a=b#mark', true): ");
        String string2 = this.oObj.getPresentation(uRL, true);
        boolean bl = string2.equals(expectedCompleteHTTP);
        this.log.println("Resulted presentation: " + string2);
        this.log.println("Expected presentation: http://server:8080/pub/path/file.txt?a=b#mark");
        this.log.println("Result: " + bl);
        uRL.Complete = expectedCompleteFTP;
        this.log.println("getPresentation('ftp://user:password@server:8080/pub/path/file.txt', false): ");
        String string3 = "";
        for (int i = 0; i < password.length(); ++i) {
            string3 = string3 + "*";
        }
        string3 = "<" + string3.substring(1, string3.length());
        string3 = string3.substring(0, string3.length() - 1) + ">";
        string2 = this.oObj.getPresentation(uRL, false);
        String string4 = "ftp://user:" + string3 + "@" + server + ":" + port + path + "/" + name;
        this.log.println("Resulted presentation: " + string2);
        this.log.println("Expected presentation: " + string4);
        this.log.println("Result: " + (bl &= string2.equals(string4)));
        this.log.println("getPresentation('ftp://user:password@server:8080/pub/path/file.txt', true): ");
        string2 = this.oObj.getPresentation(uRL, true);
        string4 = expectedCompleteFTP;
        this.log.println("Resulted presentation: " + string2);
        this.log.println("Expected presentation: " + string4);
        this.log.println("Result: " + (bl &= string2.equals(string4)));
        uRL.Complete = string = "*bla-bla*";
        this.log.println("getPresentation('" + string + "', false): ");
        string2 = this.oObj.getPresentation(uRL, false);
        string4 = "";
        this.log.println("Resulted presentation: " + string2);
        this.log.println("Expected presentation: " + string4);
        this.log.println("Result: " + (bl &= string2.equals(string4)));
        this.tRes.tested("getPresentation()", bl);
    }
}

