/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.CommandInfo;
import com.sun.star.ucb.GlobalTransferCommandArgument;
import com.sun.star.ucb.TransferCommandOperation;
import com.sun.star.ucb.UnsupportedCommandException;
import com.sun.star.ucb.XCommandInfo;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;
import util.utils;

public class _XCommandProcessor
extends MultiMethodTest {
    public XCommandProcessor oObj;
    int cmdId;
    static /* synthetic */ Class class$com$sun$star$ucb$XCommandInfo;

    public void _createCommandIdentifier() {
        this.log.println("creating a command line identifier");
        int n = this.oObj.createCommandIdentifier();
        this.cmdId = this.oObj.createCommandIdentifier();
        if (this.cmdId == 0 || n == 0) {
            this.log.println("createCommandLineIdentifier() returned 0 - FAILED");
        }
        if (this.cmdId == n) {
            this.log.println("the command identifier is not unique");
        }
        this.tRes.tested("createCommandIdentifier()", n != 0 && this.cmdId != 0 && this.cmdId != n);
    }

    public void _execute() {
        Object object;
        String string = "getCommandInfo";
        Command command = new Command(string, -1, null);
        this.log.println("executing command " + string);
        try {
            object = this.oObj.execute(command, 0, null);
        }
        catch (CommandAbortedException commandAbortedException) {
            this.log.println("The command aborted " + commandAbortedException.getMessage());
            commandAbortedException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", commandAbortedException);
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception " + exception.getMessage());
            exception.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", exception);
        }
        XCommandInfo xCommandInfo = (XCommandInfo)UnoRuntime.queryInterface(class$com$sun$star$ucb$XCommandInfo == null ? (class$com$sun$star$ucb$XCommandInfo = _XCommandProcessor.class$("com.sun.star.ucb.XCommandInfo")) : class$com$sun$star$ucb$XCommandInfo, object);
        CommandInfo[] commandInfoArray = xCommandInfo.getCommands();
        boolean bl = false;
        for (int i = 0; i < commandInfoArray.length; ++i) {
            if (!commandInfoArray[i].Name.equals(string)) continue;
            bl = true;
            break;
        }
        this.log.println("testing execute with wrong command");
        Command command2 = new Command("bad command", -1, null);
        try {
            this.oObj.execute(command2, 0, null);
        }
        catch (CommandAbortedException commandAbortedException) {
            this.log.println("CommandAbortedException thrown - OK");
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            this.log.println("UnsupportedCommandException thrown - OK");
        }
        catch (Exception exception) {
            this.log.println("Wrong exception thrown " + exception.getMessage());
            exception.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", exception);
        }
        this.tRes.tested("execute()", bl);
    }

    public void _abort() {
        Object object;
        this.executeMethod("createCommandIdentifier()");
        Command command = (Command)this.tEnv.getObjRelation("XCommandProcessor.AbortCommand");
        if (command == null) {
            object = "globalTransfer";
            String string = utils.getFullTestURL("SwXTextEmbeddedObject.sdw");
            String string2 = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            this.log.println("Copying '" + string + "' to '" + string2);
            GlobalTransferCommandArgument globalTransferCommandArgument = new GlobalTransferCommandArgument(TransferCommandOperation.COPY, string, string2, "", 1);
            command = new Command((String)object, -1, globalTransferCommandArgument);
        }
        object = new Thread(){

            public void run() {
                for (int i = 0; i < 10; ++i) {
                    _XCommandProcessor.this.log.println("try to abort command");
                    _XCommandProcessor.this.oObj.abort(_XCommandProcessor.this.cmdId);
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        ((Thread)object).start();
        try {
            Thread.currentThread();
            Thread.sleep(15L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.println("executing command");
        try {
            this.oObj.execute(command, this.cmdId, null);
            this.log.println("Command execution completed");
            this.log.println("CommandAbortedException is not thrown");
            this.log.println("This is OK since there is no command implemented that can be aborted");
            this.tRes.tested("abort()", true);
        }
        catch (CommandAbortedException commandAbortedException) {
            this.tRes.tested("abort()", true);
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception " + exception.getMessage());
            exception.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", exception);
        }
        try {
            ((Thread)object).join(5000L);
            ((Thread)object).interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

