/*
 * Decompiled with CFR 0.152.
 */
package ifc.table;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableRows;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTableRows
extends MultiMethodTest {
    public XTableRows oObj = null;
    public XCellRange range = null;

    public void before() {
        this.range = (XCellRange)this.tEnv.getObjRelation("XTableRows.XCellRange");
        if (this.range == null) {
            throw new StatusException(Status.failed("ObjectRelation missing"));
        }
        try {
            this.range.getCellByPosition(0, 0).setValue(17.0);
            this.range.getCellByPosition(0, 1).setValue(15.0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Couldn't set value for Cell A1");
        }
    }

    public void _insertByIndex() {
        boolean bl = true;
        this.requiredMethod("removeByIndex()");
        int n = this.oObj.getCount();
        this.log.println("Inserting row before first row");
        this.oObj.insertByIndex(0, 1);
        bl &= this.checkCell(1, 15.0);
        if (this.checkCell(1, 15.0)) {
            this.log.println("... successful");
        }
        try {
            this.oObj.insertByIndex(-1, 1);
            this.log.println("No Exception occurred while inserting row at -1");
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("Inserting row at Index -1 ... OK");
            bl &= true;
        }
        this.tRes.tested("insertByIndex()", bl);
    }

    public void _removeByIndex() {
        boolean bl = true;
        this.oObj.removeByIndex(0, 1);
        this.log.println("Removing first row");
        bl &= this.checkCell(0, 15.0);
        if (this.checkCell(0, 15.0)) {
            this.log.println("... successful");
        }
        try {
            this.oObj.removeByIndex(-1, 1);
            this.log.println("No Exception occurred while Removing row at -1");
            bl &= false;
        }
        catch (Exception exception) {
            this.log.println("Removing row at Index -1 ... OK");
            bl &= true;
        }
        this.tRes.tested("removeByIndex()", bl);
    }

    public boolean checkCell(int n, double d) {
        boolean bl;
        double d2 = 0.0;
        try {
            d2 = this.range.getCellByPosition(0, n).getValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Couldn't set value for Cell A1");
        }
        boolean bl2 = bl = d2 == d;
        if (!bl) {
            this.log.println("Expected for row " + n + " was " + d);
            this.log.println("Getting for row " + n + " - " + d2);
            this.log.println("=> FAILED");
        }
        return bl;
    }
}

