/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.sheet.XDataPilotDescriptor;
import com.sun.star.sheet.XDataPilotTables;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataPilotTables
extends MultiMethodTest {
    public XDataPilotTables oObj = null;
    XDataPilotDescriptor DPDscr = null;
    String name = "XDataPilotTables";
    CellAddress CA = new CellAddress(0, 9, 8);
    XSpreadsheet oSheet = null;

    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            throw new StatusException(Status.failed("Relation 'SHEET' not found"));
        }
    }

    public void _createDataPilotDescriptor() {
        this.DPDscr = this.oObj.createDataPilotDescriptor();
        this.tRes.tested("createDataPilotDescriptor()", this.DPDscr != null);
    }

    public void _insertNewByName() {
        this.requiredMethod("createDataPilotDescriptor()");
        boolean bl = true;
        this.log.println("Inserting new Table \"" + this.name + "\"");
        try {
            this.oObj.insertNewByName(this.name, this.CA, this.DPDscr);
            bl &= this.oSheet.getCellByPosition(this.CA.Column, this.CA.Row).getFormula().equals("Filter");
        }
        catch (Exception exception) {
            this.log.println("Exception occured! " + exception);
            bl = false;
        }
        this.log.println(bl ? "OK" : "FAILED");
        this.log.println("Trying to insert element with existent name");
        try {
            this.oObj.insertNewByName(this.name, new CellAddress(0, 7, 7), this.DPDscr);
            this.log.println("No exception! - FAILED");
            bl = false;
        }
        catch (RuntimeException runtimeException) {
            this.log.println("Expected exception - OK " + runtimeException);
        }
        this.log.println("Inserting new table " + (bl ? "OK" : "FAILED"));
        this.tRes.tested("insertNewByName()", bl);
    }

    public void _removeByName() {
        this.requiredMethod("insertNewByName()");
        boolean bl = true;
        this.log.println("Remove table with name " + this.name);
        try {
            this.oObj.removeByName(this.name);
            bl &= this.oSheet.getCellByPosition(this.CA.Column, this.CA.Row).getFormula().equals("");
        }
        catch (Exception exception) {
            this.log.println("Exception occured ! " + exception);
            bl = false;
        }
        this.log.println(bl ? "OK" : "FAILED");
        this.log.println("Removing unexistent element");
        try {
            this.oObj.removeByName(this.name);
            this.log.println("No exception! - FAILED");
            bl = false;
        }
        catch (RuntimeException runtimeException) {
            this.log.println("Expected exception - OK " + runtimeException);
        }
        this.log.println("Removing a table " + (bl ? "OK" : "FAILED"));
        this.tRes.tested("removeByName()", bl);
    }
}

