/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XOutputStream
extends MultiMethodTest {
    public XOutputStream oObj = null;
    StreamChecker checker = null;
    byte[] data = null;

    protected void before() {
        this.checker = (StreamChecker)this.tEnv.getObjRelation("XOutputStream.StreamChecker");
        if (this.checker == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XOutputStream.StreamChecker'"));
        }
        this.data = (byte[])this.tEnv.getObjRelation("ByteData");
        if (this.data == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'ByteData'"));
        }
    }

    public void _writeBytes() {
        boolean bl = true;
        try {
            this.oObj.writeBytes(this.data);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            bl = false;
        }
        XInputStream xInputStream = this.checker.getInStream();
        byte[][] byArray = new byte[1][this.data.length];
        int n = 0;
        try {
            n = xInputStream.readBytes(byArray, this.data.length);
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read data:" + iOException);
            bl = false;
        }
        for (int i = 0; i < byArray[0].length; ++i) {
            this.log.println("Expected: " + this.data[i] + ", actual is " + byArray[0][i]);
            bl &= byArray[0][i] == this.data[i];
        }
        this.tRes.tested("writeBytes()", bl);
    }

    public void _flush() {
        boolean bl;
        this.requiredMethod("writeBytes()");
        try {
            this.oObj.flush();
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("flush()", bl);
    }

    public void _closeOutput() {
        boolean bl;
        this.requiredMethod("writeBytes()");
        this.executeMethod("flush()");
        try {
            this.oObj.closeOutput();
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.log.println("This method is called in main module");
        this.tRes.tested("closeOutput()", bl);
    }

    public void after() {
        this.tEnv.dispose();
    }

    public static interface StreamChecker {
        public XInputStream getInStream();

        public void resetStreams();
    }
}

