/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.ParseResult;
import com.sun.star.i18n.XCharacterClassification;
import java.util.Locale;
import lib.MultiMethodTest;

public class _XCharacterClassification
extends MultiMethodTest {
    public XCharacterClassification oObj = null;
    public String[] languages = new String[]{"de", "en", "es", "fr", "ja", "ko", "zh"};
    public String[] countries = new String[]{"DE", "US", "ES", "FR", "JP", "KR", "CN"};
    public String[] charstyles_java = new String[]{"UNASSIGNED", "UPPERCASE_LETTER", "LOWERCASE_LETTER", "TITLECASE_LETTER", "MODIFIER_LETTER", "OTHER_LETTER", "NON_SPACING_MARK", "ENCLOSING_MARK", "COMBINING_SPACING_MARK", "DECIMAL_DIGIT_NUMBER", "LETTER_NUMBER", "OTHER_NUMBER", "SPACE_SEPARATOR", "LINE_SEPARATOR", "PARAGRAPH_SEPARATOR", "CONTROL", "FORMAT", "none17", "PRIVATE_USE", "none19", "DASH_PUNCTUATION", "START_PUNCTUATION", "END_PUNCTUATION", "CONNECTOR_PUNCTUATION", "OTHER_PUNCTUATION", "MATH_SYMBOL", "CURRENCY_SYMBOL", "MODIFIER_SYMBOL", "OTHER_SYMBOL"};
    public String[] charstyles_office = new String[]{"UNASSIGNED", "UPPERCASE_LETTER", "LOWERCASE_LETTER", "TITLECASE_LETTER", "MODIFIER_LETTER", "OTHER_LETTER", "NON_SPACING_MARK", "ENCLOSING_MARK", "COMBINING_SPACING_MARK", "DECIMAL_DIGIT_NUMBER", "LETTER_NUMBER", "OTHER_NUMBER", "SPACE_SEPARATOR", "LINE_SEPARATOR", "PARAGRAPH_SEPARATOR", "CONTROL", "FORMAT", "PRIVATE_USE", "SURROGATE", "DASH_PUNCTUATION", "START_PUNCTUATION", "END_PUNCTUATION", "CONNECTOR_PUNCTUATION", "OTHER_PUNCTUATION", "MATH_SYMBOL", "CURRENCY_SYMBOL", "MODIFIER_SYMBOL", "OTHER_SYMBOL", "INITIAL_PUNCTUATION", "FINAL_PUNCTUATION", "GENERAL_TYPES_COUNT"};
    public String[] unicode_script = new String[]{"U_BASIC_LATIN", "U_LATIN_1_SUPPLEMENT", "U_LATIN_EXTENDED_A", "U_LATIN_EXTENDED_B", "U_IPA_EXTENSIONS", "U_SPACING_MODIFIER_LETTERS", "U_COMBINING_DIACRITICAL_MARKS", "U_GREEK", "U_CYRILLIC", "U_ARMENIAN", "U_HEBREW", "U_ARABIC", "U_SYRIAC", "U_THAANA", "U_DEVANAGARI", "U_BENGALI", "U_GURMUKHI", "U_GUJARATI", "U_ORIYA", "U_TAMIL", "U_TELUGU", "U_KANNADA", "U_MALAYALAM", "U_SINHALA", "U_THAI", "U_LAO", "U_TIBETAN", "U_MYANMAR", "U_GEORGIAN", "U_HANGUL_JAMO", "U_ETHIOPIC", "U_CHEROKEE", "U_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", "U_OGHAM", "U_RUNIC", "U_KHMER", "U_MONGOLIAN", "U_LATIN_EXTENDED_ADDITIONAL", "U_GREEK_EXTENDED", "U_GENERAL_PUNCTUATION", "U_SUPERSCRIPTS_AND_SUBSCRIPTS", "U_CURRENCY_SYMBOLS", "U_COMBINING_MARKS_FOR_SYMBOLS", "U_LETTERLIKE_SYMBOLS", "U_NUMBER_FORMS", "U_ARROWS", "U_MATHEMATICAL_OPERATORS", "U_MISCELLANEOUS_TECHNICAL", "U_CONTROL_PICTURES", "U_OPTICAL_CHARACTER_RECOGNITION", "U_ENCLOSED_ALPHANUMERICS", "U_BOX_DRAWING", "U_BLOCK_ELEMENTS", "U_GEOMETRIC_SHAPES", "U_MISCELLANEOUS_SYMBOLS", "U_DINGBATS", "U_BRAILLE_PATTERNS", "U_CJK_RADICALS_SUPPLEMENT", "U_KANGXI_RADICALS", "U_IDEOGRAPHIC_DESCRIPTION_CHARACTERS", "U_CJK_SYMBOLS_AND_PUNCTUATION", "U_HIRAGANA", "U_KATAKANA", "U_BOPOMOFO", "U_HANGUL_COMPATIBILITY_JAMO", "U_KANBUN", "U_BOPOMOFO_EXTENDED", "U_ENCLOSED_CJK_LETTERS_AND_MONTHS", "U_CJK_COMPATIBILITY", "U_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "U_CJK_UNIFIED_IDEOGRAPHS", "U_YI_SYLLABLES", "U_YI_RADICALS", "U_HANGUL_SYLLABLES", "U_HIGH_SURROGATES", "U_HIGH_PRIVATE_USE_SURROGATES", "U_LOW_SURROGATES", "U_PRIVATE_USE_AREA", "U_CJK_COMPATIBILITY_IDEOGRAPHS", "U_ALPHABETIC_PRESENTATION_FORMS", "U_ARABIC_PRESENTATION_FORMS_A", "U_COMBINING_HALF_MARKS", "U_CJK_COMPATIBILITY_FORMS", "U_SMALL_FORM_VARIANTS", "U_ARABIC_PRESENTATION_FORMS_B", "U_SPECIALS", "U_HALFWIDTH_AND_FULLWIDTH_FORMS", "U_CHAR_SCRIPT_COUNT", "U_NO_SCRIPT"};

    public void _toUpper() {
        boolean bl = true;
        String string = "abcD\uff72\uff73\\@~\ufffd)??";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 7; ++i) {
            string2 = this.oObj.toUpper(string, 0, string.length(), this.getLocale(i));
            if (bl &= string2.equals(string3 = string.toUpperCase(new Locale(this.languages[i], this.countries[i])))) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + string3);
            this.log.println("Gained : " + string2);
        }
        this.tRes.tested("toUpper()", bl);
    }

    public void _toLower() {
        boolean bl = true;
        String string = "QWER\uff72\uff73\\@~\ufffd)??TZ";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 7; ++i) {
            string2 = this.oObj.toLower(string, 0, string.length(), this.getLocale(i));
            if (bl &= string2.equals(string3 = string.toLowerCase(new Locale(this.languages[i], this.countries[i])))) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + string3);
            this.log.println("Gained : " + string2);
        }
        this.tRes.tested("toLower()", bl);
    }

    public void _toTitle() {
        boolean bl = true;
        String string = new String(new char[]{'\u1fb0'});
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 7; ++i) {
            string2 = this.oObj.toTitle(string, 0, 1, this.getLocale(i));
            string3 = new String(new char[]{Character.toTitleCase(string.toCharArray()[0])});
            if (bl &= string2.equals(string3)) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + string3);
            this.log.println("Gained : " + string2);
        }
        this.tRes.tested("toTitle()", bl);
    }

    public void _getType() {
        boolean bl = true;
        char[] cArray = new char[]{'\u024a', 'A', 'a', '\u01f2', '\u02d1', '\u11ec', '\u0304', '\u20dd', '\u0d4c', '0', '\u2160', '\u00b3', ' ', '\u2028', '\u2029', '\u0090', '\u200c', '\ue000', '\udc00', '\u00ad', '(', ')', '_', '\u0f0c', '\u00f7', '\u0e3f', '\u0385', '\u0f38', '\u00ab', '\u00bb'};
        int[] nArray = new int[]{586, 65, 97, 498, 721, 4588, 772, 8413, 3404, 48, 8544, 179, 32, 8232, 8233, 144, 8204, 57344, 56320, 173, 40, 41, 95, 3852, 247, 3647, 901, 3896, 171, 187};
        String string = new String(cArray);
        for (int i = 0; i < cArray.length; ++i) {
            short s = this.oObj.getType(string, i);
            if (bl &= s == i) continue;
            this.log.println("Code :" + Integer.toHexString(nArray[i]));
            this.log.println("Gained: " + this.charstyles_office[s]);
            this.log.println("Expected : " + this.charstyles_office[i]);
        }
        this.tRes.tested("getType()", bl);
    }

    public void _getCharacterType() {
        boolean bl = true;
        String string = "Ab0)";
        int[] nArray = new int[]{226, 228, 97, 32};
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 1; j < 7; ++j) {
                int n = this.oObj.getCharacterType(string, i, this.getLocale(j));
                if (bl &= n == nArray[i]) continue;
                this.log.println("FAILED for: language=" + this.languages[j] + " ; country=" + this.countries[j]);
                this.log.println("Sysmbol :" + string.toCharArray()[i]);
                this.log.println("Gained: " + n);
                this.log.println("Expected : " + nArray[i]);
            }
        }
        this.tRes.tested("getCharacterType()", bl);
    }

    public void _getStringType() {
        boolean bl = true;
        String[] stringArray = new String[]{"01234", "AAAAA", "bbbbb", "AA()bb"};
        int[] nArray = new int[]{97, 226, 228, 230};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n = this.oObj.getStringType(stringArray[i], 0, stringArray[i].length(), this.getLocale(j));
                if (bl &= n == nArray[i]) continue;
                this.log.println("FAILED for: language=" + this.languages[j] + " ; country=" + this.countries[j]);
                this.log.println("Expected: " + nArray[i]);
                this.log.println("Gained : " + n);
            }
        }
        this.tRes.tested("getStringType()", bl);
    }

    public void _getCharacterDirection() {
        boolean bl = true;
        String string = new String(new char[]{'A', '\u05be', '0', '/', '#', '\u0660', ',', '\n', '\t', '\f', '!', '\u202a', '\u202d', '\u061b', '\u202b', '\u202e', '\u202c', '\u0300', '\u0001'});
        for (short s = 0; s < 19; s = (short)(s + 1)) {
            short s2 = this.oObj.getCharacterDirection(string, s);
            if (bl &= s2 == s) continue;
            this.log.println("Code :" + string.toCharArray()[s]);
            this.log.println("Gained: " + s2);
            this.log.println("Expected: " + s);
        }
        this.tRes.tested("getCharacterDirection()", bl);
    }

    public void _getScript() {
        boolean bl = true;
        char[] cArray = new char[]{'A', '\u0080', '\u0100', '\u0180', '\u0250', '\u02ee', '\u0305', '\u039c', '\u0406', '\u0533', '\u05a8', '\u0621', '\u0700', '\u0790', '\u0909', '\u09a1', '\u0a0a', '\u0a93', '\u0b06', '\u0b9c', '\u0c07', '\u0ca8', '\u0d09', '\u0d88', '\u0e06', '\u0ea1', '\u0f42', '\u1001', '\u10b2', '\u1105', '\u120d', '\u13b0', '\u1450', '\u1690', '\u16ae', '\u178e', '\u180b', '\u1e03', '\u1f07', '\u200a', '\u207f', '\u20a0', '\u20dd', '\u2104', '\u2161', '\u21a8', '\u220b', '\u2305', '\u2401', '\u2441', '\u2478', '\u2502', '\u2588', '\u25f7', '\u2606', '\u270f', '\u2807', '\u2e87', '\u2f02', '\u2ff2', '\u3006', '\u3046', '\u30a8', '\u3108', '\u313d', '\u3190', '\u31b7', '\u3206', '\u3309', '\u3400', '\u4e00', '\ua004', '\ua4a8', '\uac00', '\ud800', '\udb80', '\udc00', '\ue000', '\uf900', '\ufb01', '\ufb72', '\ufe20', '\ufe31', '\ufe6b', '\ufe7a', '\ufffc', '\uff08'};
        int[] nArray = new int[]{65, 128, 256, 384, 592, 750, 773, 924, 1030, 1331, 1448, 1569, 1792, 1936, 2313, 2465, 2570, 2707, 2822, 2972, 3079, 3240, 3337, 3464, 3590, 3745, 3906, 4097, 4274, 4357, 4621, 5040, 5200, 5776, 5806, 6030, 6155, 7683, 7943, 8202, 8319, 8352, 8413, 8452, 8545, 8616, 8715, 8965, 9217, 9281, 9336, 9474, 9608, 9719, 9734, 9999, 10247, 11911, 12034, 12274, 12294, 12358, 12456, 12552, 12605, 12688, 12727, 12806, 13065, 13312, 19968, 40964, 42152, 44032, 55296, 56192, 56320, 57344, 63744, 64257, 64370, 65056, 65073, 65131, 65146, 65532, 65288};
        String string = new String(cArray);
        for (int i = 0; i < cArray.length; ++i) {
            short s = this.oObj.getScript(string, i);
            bl &= s == i;
            if (string.substring(i, i + 1).hashCode() == 55296) {
                bl = true;
            }
            if (bl) continue;
            this.log.println("-- " + string.substring(i, i + 1).hashCode());
            this.log.println("Code: " + Integer.toHexString(nArray[i]));
            this.log.println("Gained: " + this.unicode_script[s]);
            this.log.println("Expected: " + this.unicode_script[i]);
        }
        this.tRes.tested("getScript()", bl);
    }

    public void _parseAnyToken() {
        int n = 45067;
        int n2 = 61487;
        String string = " 18 i18n ^";
        ParseResult parseResult = null;
        boolean bl = true;
        for (int i = 0; i < 7; ++i) {
            parseResult = this.oObj.parseAnyToken(string, 1, this.getLocale(i), n, "", n2, "");
            bl = parseResult.CharLen == 2 && parseResult.TokenType == 32 && parseResult.Value == 18.0;
            parseResult = this.oObj.parseAnyToken(string, 4, this.getLocale(i), n, "", n2, "");
            bl &= parseResult.CharLen == 4 && parseResult.TokenType == 4 && parseResult.Value == 0.0;
            parseResult = this.oObj.parseAnyToken(string, 9, this.getLocale(i), n, "", n2, "");
            bl &= parseResult.CharLen == 1 && parseResult.TokenType == 1 && parseResult.Value == 0.0;
        }
        this.tRes.tested("parseAnyToken()", bl);
    }

    public void _parsePredefinedToken() {
        int n;
        int n2 = n = 45067;
        String string = " 18 int";
        ParseResult parseResult = null;
        boolean bl = true;
        for (int i = 0; i < 7; ++i) {
            parseResult = this.oObj.parsePredefinedToken(4, string, 1, this.getLocale(i), n, "", n2, "");
            bl = parseResult.CharLen == 0;
            parseResult = this.oObj.parsePredefinedToken(4, string, 4, this.getLocale(i), n, "", n2, "");
            bl &= parseResult.CharLen == 3 && parseResult.TokenType == 4 && parseResult.Value == 0.0;
        }
        this.tRes.tested("parsePredefinedToken()", bl);
    }

    public com.sun.star.lang.Locale getLocale(int n) {
        return new com.sun.star.lang.Locale(this.languages[n], this.countries[n], "");
    }
}

